/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIModerationForum;
import org.exoplatform.ks.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.ks.common.TransformHTML;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIModerationForum.gtmpl", events={@EventConfig(listeners={OpenActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIModerationForum
extends BaseForumForm
implements UIPopupComponent {
    private String[] path = new String[0];
    List<ForumSearch> list_;
    private boolean isShowIter = true;
    private boolean isReloadPortlet = false;
    public final String SEARCH_ITERATOR = "moderationIterator";
    private JCRPageList pageList;
    private UIForumPageIterator pageIterator = (UIForumPageIterator)this.addChild(UIForumPageIterator.class, null, "moderationIterator");

    public UIModerationForum() throws Exception {
        this.setActions(new String[]{"Close"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setReloadPortlet(boolean isReloadPortlet) {
        this.isReloadPortlet = isReloadPortlet;
    }

    private String getTitleInHTMLCode(String s) {
        return TransformHTML.getTitleInHTMLCode((String)s, new ArrayList(new ExtendedBBCodeProvider().getSupportedBBCodes()));
    }

    public void setUserProfile(UserProfile userProfile) throws Exception {
        this.userProfile = userProfile;
        if (this.userProfile == null) {
            this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
        }
    }

    public String[] getPath() {
        if (this.userProfile.getUserRole() <= 1L) {
            this.path = this.userProfile.getUserRole() == 1L ? this.userProfile.getModerateForums() : new String[0];
        }
        return this.path;
    }

    public void setPath(String[] path) {
        this.path = path;
    }

    public boolean getIsShowIter() {
        return this.isShowIter;
    }

    private List<ForumSearch> getListObject() throws Exception {
        try {
            this.list_ = this.getForumService().getJobWattingForModerator(this.getPath());
        }
        catch (Exception e) {
            this.list_ = new ArrayList();
            this.log.error((Object)"list of forum search must not null: ", (Throwable)e);
        }
        this.pageList = new ForumPageList(10, this.list_.size());
        this.pageList.setPageSize(10);
        this.pageIterator.updatePageList(this.pageList);
        this.isShowIter = true;
        if (this.pageList.getAvailablePage() <= 1) {
            this.isShowIter = false;
        }
        int pageSelect = this.pageIterator.getPageSelected();
        ArrayList<ForumSearch> list = new ArrayList<ForumSearch>();
        try {
            list.addAll(this.pageList.getPageSearch(pageSelect, this.list_));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private ForumSearch getObject(String id) throws Exception {
        for (ForumSearch obj : this.list_) {
            if (!obj.getId().equals(id)) continue;
            return obj;
        }
        return null;
    }

    static /* synthetic */ ForumSearch access$000(UIModerationForum x0, String x1) throws Exception {
        return x0.getObject(x1);
    }

    static /* synthetic */ ForumService access$100(UIModerationForum x0) {
        return x0.getForumService();
    }

    static /* synthetic */ Log access$200(UIModerationForum x0) {
        return x0.log;
    }

    static /* synthetic */ ForumService access$300(UIModerationForum x0) {
        return x0.getForumService();
    }

    static /* synthetic */ Log access$400(UIModerationForum x0) {
        return x0.log;
    }

    static /* synthetic */ boolean access$500(UIModerationForum x0) {
        return x0.isReloadPortlet;
    }

    static /* synthetic */ boolean access$502(UIModerationForum x0, boolean x1) {
        x0.isReloadPortlet = x1;
        return x0.isReloadPortlet;
    }
}

