/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.popup.UISortSettingForm;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIFormForum.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UISortSettingForm
extends BaseForumForm
implements UIPopupComponent {
    public static final String FIELD_FORUMSORTBY_INPUT = "forumSortBy";
    public static final String FIELD_FORUMSORTBYTYPE_INPUT = "forumSortByType";
    public static final String FIELD_TOPICSORTBY_INPUT = "topicSortBy";
    public static final String FIELD_TOPICSORTBYTYPE_INPUT = "topicSortByType";
    private ForumAdministration administration;

    public void setInitForm() throws Exception {
        this.administration = this.getForumService().getForumAdministration();
        UIFormSelectBox forumSortBy = this.initForumSortField();
        UIFormSelectBox forumSortByType = this.initForumSortDirectionField();
        UIFormSelectBox topicSortBy = this.initTopicSortField();
        UIFormSelectBox topicSortByType = this.initTopicSortDirectionField();
        this.addUIFormInput((UIFormInput)forumSortBy);
        this.addUIFormInput((UIFormInput)forumSortByType);
        this.addUIFormInput((UIFormInput)topicSortBy);
        this.addUIFormInput((UIFormInput)topicSortByType);
    }

    private UIFormSelectBox initTopicSortDirectionField() {
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption(this.getLabel("ascending"), (Object)"ascending"));
        ls.add(new SelectItemOption(this.getLabel("descending"), (Object)"descending"));
        UIFormSelectBox topicSortByType = new UIFormSelectBox(FIELD_TOPICSORTBYTYPE_INPUT, FIELD_TOPICSORTBYTYPE_INPUT, ls);
        topicSortByType.setValue(this.administration.getTopicSortByType());
        return topicSortByType;
    }

    private UIFormSelectBox initTopicSortField() {
        String[] idLables = new String[]{"isLock", "createdDate", "modifiedDate", "lastPostDate", "postCount", "viewCount", "numberAttachments"};
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption(this.getLabel("threadName"), (Object)"name"));
        for (String string : idLables) {
            ls.add(new SelectItemOption(this.getLabel(string), (Object)string));
        }
        UIFormSelectBox topicSortBy = new UIFormSelectBox(FIELD_TOPICSORTBY_INPUT, FIELD_TOPICSORTBY_INPUT, ls);
        topicSortBy.setValue(this.administration.getTopicSortBy());
        return topicSortBy;
    }

    private UIFormSelectBox initForumSortDirectionField() {
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption(this.getLabel("ascending"), (Object)"ascending"));
        ls.add(new SelectItemOption(this.getLabel("descending"), (Object)"descending"));
        UIFormSelectBox forumSortByType = new UIFormSelectBox(FIELD_FORUMSORTBYTYPE_INPUT, FIELD_FORUMSORTBYTYPE_INPUT, ls);
        forumSortByType.setValue(this.administration.getForumSortByType());
        return forumSortByType;
    }

    private UIFormSelectBox initForumSortField() {
        String[] idLables = new String[]{"forumOrder", "isLock", "createdDate", "modifiedDate", "topicCount", "postCount"};
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption(this.getLabel("forumName"), (Object)"name"));
        for (String string : idLables) {
            ls.add(new SelectItemOption(this.getLabel(string), (Object)string));
        }
        UIFormSelectBox forumSortBy = new UIFormSelectBox(FIELD_FORUMSORTBY_INPUT, FIELD_FORUMSORTBY_INPUT, ls);
        forumSortBy.setValue(this.administration.getForumSortBy());
        return forumSortBy;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ ForumAdministration access$000(UISortSettingForm x0) {
        return x0.administration;
    }

    static /* synthetic */ ForumService access$100(UISortSettingForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ Log access$200(UISortSettingForm x0) {
        return x0.log;
    }
}

