/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll.webui;

import java.io.Writer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIForumCheckBoxInput<T>
extends UIFormCheckBoxInput<T> {
    private boolean checked = false;

    public UIForumCheckBoxInput(String name, String bindingExpression, T value) {
        super(name, bindingExpression, null);
        if (value != null) {
            this.typeValue_ = value.getClass();
        }
        this.value_ = value;
        this.setId(name);
    }

    public UIFormInput setValue(T value) {
        if (value == null) {
            return super.setValue(value);
        }
        if (value instanceof Boolean) {
            this.checked = (Boolean)value;
        } else if (Boolean.TYPE.isInstance(value)) {
            this.checked = Boolean.TYPE.cast(value);
        }
        this.typeValue_ = value.getClass();
        return super.setValue(value);
    }

    public final boolean isCheckedBox() {
        this.checked = this.isChecked();
        return this.checked;
    }

    public final UIForumCheckBoxInput setCheckedBox(boolean check) {
        this.checked = check;
        this.setChecked(check);
        return this;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        w.write("<input type='checkbox' name='");
        w.write(this.name);
        w.write("'");
        w.write(" value='");
        if (this.value_ != null) {
            w.write(String.valueOf(this.value_));
        }
        w.write("' ");
        if (this.isChecked()) {
            w.write(" checked ");
        }
        if (!this.enable_) {
            w.write(" disabled ");
        }
        w.write(" class='checkbox'/>");
        w.write("<span> " + this.name + "</span><br/>");
        if (this.isMandatory()) {
            w.write(" *");
        }
    }
}

