/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll.webui;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.poll.Utils;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollNodeTypes;
import org.exoplatform.poll.webui.BasePollForm;
import org.exoplatform.poll.webui.UIForumCheckBoxInput;
import org.exoplatform.poll.webui.UIPoll;
import org.exoplatform.poll.webui.UIPollPortlet;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/poll/webui/UIPoll.gtmpl", events={@EventConfig(listeners={VoteActionListener.class}), @EventConfig(listeners={EditPollActionListener.class}), @EventConfig(listeners={RemovePollActionListener.class}, confirm="UIPoll.msg.confirm-RemovePoll"), @EventConfig(listeners={ClosedPollActionListener.class}), @EventConfig(listeners={VoteAgainPollActionListener.class})})
public class UIPoll
extends BasePollForm {
    private Poll poll_;
    private String pollId;
    private String userId;
    private boolean isAgainVote = false;
    private boolean isEditPoll = false;
    private boolean hasPermission = true;
    private boolean isAdmin = false;
    private String[] dateUnit = new String[]{"Never", "Closed", "day(s)", "hour(s)", "minutes"};

    public UIPoll() throws Exception {
        try {
            this.dateUnit = new String[]{this.getLabel("Never"), this.getLabel("Closed"), this.getLabel("day"), this.getLabel("hour"), this.getLabel("minutes")};
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPollId() throws Exception {
        List list;
        UIPollPortlet pollPortlet = (UIPollPortlet)this.getAncestorOfType(UIPollPortlet.class);
        this.isAdmin = pollPortlet.isAdmin();
        this.userId = pollPortlet.getUserId();
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        this.pollId = portletPref.getValue(Utils.POLL_ID_SHOW, "");
        if (Utils.isEmpty((String)this.pollId) && !(list = this.getPollService().getPollSummary(null).getPollId()).isEmpty()) {
            this.pollId = (String)list.iterator().next();
        }
        this.isEditPoll = true;
    }

    public boolean hasUserInGroup(String groupId, String userId) throws Exception {
        try {
            OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
            for (Object object : organizationService.getGroupHandler().findGroupsOfUser(userId)) {
                if (!((Group)object).getId().equals(groupId)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.log.debug((Object)"Failed to check user permission by OrganizationService !", (Throwable)e);
        }
        return false;
    }

    private boolean checkPermission() throws Exception {
        String path = this.poll_.getParentPath();
        if (path.indexOf(PollNodeTypes.APPLICATION_DATA) > 0) {
            String group = path.substring(path.indexOf("/", 3), path.indexOf(PollNodeTypes.APPLICATION_DATA) - 1);
            this.hasPermission = this.hasUserInGroup(group, this.userId);
        } else {
            this.hasPermission = true;
        }
        return this.hasPermission;
    }

    public void updateFormPoll(Poll poll) throws Exception {
        if (poll.getIsClosed()) {
            poll.setExpire(Utils.getExpire((long)-1L, (Date)poll.getModifiedDate(), (String[])this.dateUnit));
        } else {
            poll.setExpire(Utils.getExpire((long)poll.getTimeOut(), (Date)poll.getModifiedDate(), (String[])this.dateUnit));
        }
        this.poll_ = poll;
        this.isEditPoll = false;
        this.checkPermission();
    }

    public void updatePollById(String pollId) throws Exception {
        this.pollId = pollId;
        this.isEditPoll = true;
    }

    private void init() throws Exception {
        if (this.hasChildren()) {
            this.removeChild(UIFormRadioBoxInput.class);
            for (int i = 0; i < 10 && this.hasChildren(); ++i) {
                this.removeChild(UIForumCheckBoxInput.class);
            }
        }
        if (this.poll_ != null) {
            if (!this.poll_.getIsMultiCheck()) {
                ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
                for (String s : this.poll_.getOption()) {
                    options.add(new SelectItemOption(s, (Object)s));
                }
                UIFormRadioBoxInput input = new UIFormRadioBoxInput("vote", "vote", options);
                input.setAlign(1);
                this.addUIFormInput((UIFormInput)input);
            } else {
                for (String s : this.poll_.getOption()) {
                    this.addUIFormInput((UIFormInput)new UIForumCheckBoxInput(s, s, (Object)false));
                }
            }
        }
    }

    private Poll getPoll() throws Exception {
        if (this.isEditPoll || this.poll_ == null) {
            this.poll_ = this.getPollService().getPoll(this.pollId);
            if (this.poll_ != null) {
                this.checkPermission();
                if (this.poll_.getIsClosed()) {
                    this.poll_.setExpire(Utils.getExpire((long)-1L, (Date)this.poll_.getModifiedDate(), (String[])this.dateUnit));
                } else {
                    this.poll_.setExpire(Utils.getExpire((long)this.poll_.getTimeOut(), (Date)this.poll_.getModifiedDate(), (String[])this.dateUnit));
                }
            } else {
                this.hasPermission = false;
            }
        }
        this.init();
        return this.poll_;
    }

    private boolean getIsEditPoll() {
        return this.isEditPoll;
    }

    public void setEditPoll(boolean isEditPoll) {
        this.isEditPoll = isEditPoll;
    }

    private boolean getCanViewEditMenu() {
        return this.isAdmin;
    }

    private boolean isGuestPermission() throws Exception {
        String[] userVotes;
        Date today;
        if (this.poll_.getIsClosed()) {
            return true;
        }
        if (Utils.isEmpty((String)this.userId)) {
            return true;
        }
        if (this.poll_.getTimeOut() > 0L && (today = new Date()).getTime() - this.poll_.getCreatedDate().getTime() >= this.poll_.getTimeOut() * 86400000L) {
            return true;
        }
        if (this.isAgainVote) {
            return false;
        }
        for (String string : userVotes = this.poll_.getUserVote()) {
            if (!(string = string.substring(0, string.indexOf(":"))).equalsIgnoreCase(this.userId)) continue;
            return true;
        }
        return false;
    }

    private String[] getInfoVote() throws Exception {
        Poll poll = this.poll_;
        String[] voteNumber = poll.getVote();
        String[] userVotes = poll.getUserVote();
        long size = 0L;
        long temp = 1L;
        if (!poll.getIsMultiCheck()) {
            size = userVotes.length;
        } else {
            for (int i = 0; i < userVotes.length; ++i) {
                size += (long)(userVotes[i].split(":").length - 1);
            }
        }
        temp = size;
        if (size == 0L) {
            size = 1L;
        }
        int l = voteNumber.length;
        String[] infoVote = new String[l + 1];
        for (int j = 0; j < l; ++j) {
            String string = voteNumber[j];
            double tmp = Double.parseDouble(string);
            double k = tmp * (double)size / 100.0;
            int t = (int)Math.round(k);
            string = "" + (double)t * 100.0 / (double)size;
            infoVote[j] = string + ":" + t;
        }
        infoVote[l] = "" + temp;
        if (poll.getIsMultiCheck()) {
            infoVote[l] = String.valueOf(userVotes.length);
        }
        return infoVote;
    }

    static /* synthetic */ Poll access$000(UIPoll x0) {
        return x0.poll_;
    }

    static /* synthetic */ String access$100(UIPoll x0) {
        return x0.userId;
    }

    static /* synthetic */ void access$200(UIPoll x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ boolean access$300(UIPoll x0) {
        return x0.isAgainVote;
    }

    static /* synthetic */ void access$400(UIPoll x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ boolean access$302(UIPoll x0, boolean x1) {
        x0.isAgainVote = x1;
        return x0.isAgainVote;
    }

    static /* synthetic */ Poll access$002(UIPoll x0, Poll x1) {
        x0.poll_ = x1;
        return x0.poll_;
    }

    static /* synthetic */ Poll access$500(UIPoll x0) throws Exception {
        return x0.getPoll();
    }

    static /* synthetic */ boolean access$602(UIPoll x0, boolean x1) {
        x0.isEditPoll = x1;
        return x0.isEditPoll;
    }

    static /* synthetic */ String access$700(UIPoll x0) {
        return x0.pollId;
    }

    static /* synthetic */ void access$800(UIPoll x0) throws Exception {
        x0.init();
    }
}

