/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll.webui;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.poll.Utils;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.webui.BasePollForm;
import org.exoplatform.poll.webui.UIPollManagement;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/poll/webui/UIPollManagement.gtmpl", events={@EventConfig(listeners={EditPollActionListener.class}), @EventConfig(listeners={DeletePollActionListener.class}), @EventConfig(listeners={AddPollActionListener.class}), @EventConfig(listeners={SaveActionListener.class})})
public class UIPollManagement
extends BasePollForm {
    public static final String FIELD_SELECT_POLL_SELECTBOX = "selectPoll";
    public static String[] BEAN_FIELD = new String[]{"question", "votes", "lastVote", "expire"};
    private static String[] ACTION = new String[]{"EditPoll", "DeletePoll"};
    private String[] dateUnit = new String[]{"Never", "Closed", "day(s)", "hour(s)", "minutes"};
    private Map<String, Poll> mapPoll = new HashMap();
    private UIFormSelectBox selectPoll;

    public UIPollManagement() throws Exception {
        if (this.getId() == null) {
            this.setId("UIPollManagement");
        }
        UIGrid categoryList = (UIGrid)this.addChild(UIGrid.class, null, "PollManagementList");
        categoryList.configure("id", BEAN_FIELD, ACTION);
        categoryList.getUIPageIterator().setId("PollManagementIterator");
        this.setActions(new String[]{"AddPoll", "Save"});
        this.selectPoll = new UIFormSelectBox(FIELD_SELECT_POLL_SELECTBOX, FIELD_SELECT_POLL_SELECTBOX, new ArrayList());
        this.addUIFormInput((UIFormInput)this.selectPoll);
        this.dateUnit = new String[]{this.getLabel("Never"), this.getLabel("Closed"), this.getLabel("day"), this.getLabel("hour"), this.getLabel("minutes")};
    }

    public long getCurrentPage() {
        return ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator().getCurrentPage();
    }

    public long getAvailablePage() {
        return ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator().getAvailablePage();
    }

    public void setCurrentPage(int page) throws Exception {
        ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator().setCurrentPage(page);
    }

    public void updateGrid() throws Exception {
        List polls = this.getPollService().getPagePoll();
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        this.mapPoll.clear();
        for (Poll poll : polls) {
            if (poll.getIsClosed()) {
                poll.setExpire(Utils.getExpire((long)-1L, (Date)poll.getModifiedDate(), (String[])this.dateUnit));
            } else {
                poll.setExpire(Utils.getExpire((long)poll.getTimeOut(), (Date)poll.getModifiedDate(), (String[])this.dateUnit));
            }
            this.mapPoll.put(poll.getId(), poll);
            list.add(new SelectItemOption(poll.getQuestion(), (Object)poll.getId()));
        }
        this.selectPoll.setOptions(list);
        if (!polls.isEmpty()) {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences portletPref = pcontext.getRequest().getPreferences();
            this.selectPoll.setValue(portletPref.getValue(Utils.POLL_ID_SHOW, ((Poll)polls.get(0)).getId()));
        }
        UIGrid uiGrid = (UIGrid)this.getChild(UIGrid.class);
        ObjectPageList objPageList = new ObjectPageList(polls, 10);
        uiGrid.getUIPageIterator().setPageList((PageList)objPageList);
    }

    static /* synthetic */ Map access$000(UIPollManagement x0) {
        return x0.mapPoll;
    }
}

