/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    public static final String POLL = "Poll".intern();
    public static final String POLL_ID_SHOW = "pollIdShow".intern();
    public static final int MAXSIGNATURE = 300;
    public static final int MAXTITLE = 100;
    public static final long MAXMESSAGE = 10000L;

    public static String getFormatDate(String format, Date myDate) {
        if (myDate == null) {
            return "";
        }
        if (!Utils.isEmpty((String)format)) {
            if (format.indexOf("DDDD") >= 0) {
                format = format.replaceAll("DDDD", "EEEE");
            }
            if (format.indexOf("DDD") >= 0) {
                format = format.replaceAll("DDD", "EEE");
            }
        }
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        Locale locale = new Locale(portalContext.getLocale().getLanguage(), portalContext.getLocale().getCountry());
        SimpleDateFormat formatter = new SimpleDateFormat(format, locale);
        return formatter.format((Object)myDate);
    }

    public static boolean isValidEmailAddresses(String addressList) throws Exception {
        if (Utils.isEmpty((String)addressList)) {
            return true;
        }
        addressList = StringUtils.remove((String)addressList, (String)" ");
        addressList = StringUtils.replace((String)addressList, (String)";", (String)",");
        try {
            InternetAddress[] iAdds = InternetAddress.parse((String)addressList, (boolean)true);
            String emailRegex = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+\\.[A-Za-z]{2,5}";
            for (int i = 0; i < iAdds.length; ++i) {
                if (iAdds[i].getAddress().matches(emailRegex)) continue;
                return false;
            }
        }
        catch (AddressException e) {
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String removeZeroFirstNumber(String str) {
        if (!Utils.isEmpty((String)str)) {
            str = str.trim();
            StringBuilder s = new StringBuilder();
            int i = 0;
            while (i + 1 < str.length() && (str.charAt(i) == '0' || str.charAt(i) == ' ')) {
                s.append(str.charAt(i));
                ++i;
            }
            str = str.replaceFirst(s.toString(), "");
        }
        return str;
    }

    public static String getSubString(String str, int max) {
        int l;
        if (!Utils.isEmpty((String)str) && (l = str.length()) > max) {
            int space = (str = str.substring(0, max)).lastIndexOf(" ");
            str = space > max - 6 ? str.substring(0, space) + "..." : str + "...";
        }
        return str;
    }

    public static String[] getColor() {
        return new String[]{"blue", "DarkGoldenRod", "green", "yellow", "BlueViolet", "orange", "darkBlue", "IndianRed", "DarkCyan", "lawnGreen"};
    }

    public static String getExpire(long timeOut, Date modifiDate, String[] dateUnit) {
        Calendar calendar;
        if (timeOut == 0L) {
            return dateUnit[0];
        }
        long timeEnd = timeOut < 1000L ? modifiDate.getTime() + timeOut * 86400000L : timeOut;
        long l = timeEnd - (calendar = CommonUtils.getGreenwichMeanTime()).getTimeInMillis();
        if (l < 0L) {
            return dateUnit[1];
        }
        long m = l / 60000L;
        if (m > 60L) {
            long h = m / 60L;
            if (h > 24L) {
                long d = h / 24L;
                return d + " " + dateUnit[2] + ", " + (h - d * 24L) + " " + dateUnit[3] + ", " + (m - h * 60L) + " " + dateUnit[4];
            }
            return h + " " + dateUnit[3] + ", " + (m - h * 60L) + dateUnit[4];
        }
        return m + " " + dateUnit[4];
    }
}

