/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.box;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.internal.macro.box.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.ParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class DefaultMacroContentParser
implements MacroContentParser {
    @Requirement
    private ComponentManager componentManager;
    private ParserUtils parserUtils = new ParserUtils();

    @Override
    public List<Block> parse(String content, Syntax syntax, boolean removeTopLevelParagraph) throws MacroExecutionException {
        try {
            List blocks = this.getSyntaxParser(syntax).parse((Reader)new StringReader(content)).getChildren();
            if (removeTopLevelParagraph) {
                this.parserUtils.removeTopLevelParagraph(blocks);
            }
            return blocks;
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "]", (Throwable)e);
        }
    }

    private Parser getSyntaxParser(Syntax syntax) throws MacroExecutionException {
        try {
            return (Parser)this.componentManager.lookup(Parser.class, syntax.toIdString());
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find source parser for syntax [" + syntax + "]", (Throwable)e);
        }
    }
}

