/*
 * Decompiled with CFR 0.152.
 */
package org.python;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import org.python.core.CodeFlag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version {
    public static String PY_VERSION;
    public static int PY_MAJOR_VERSION;
    public static int PY_MINOR_VERSION;
    public static int PY_MICRO_VERSION;
    public static int PY_RELEASE_LEVEL;
    public static int PY_RELEASE_SERIAL;
    public static String DATE;
    public static String TIME;
    public static String SVN_REVISION;
    public static String BRANCH;
    public static String SHORT_BRANCH;
    private static final Collection<CodeFlag> defaultCodeFlags;
    private static final String headURL = "$HeadURL: https://jython.svn.sourceforge.net/svnroot/jython/tags/Release_2_5_2beta1/jython/src/org/python/Version.java $";

    private static void initVersion() {
        Version.loadProperties();
        int jython2 = headURL.indexOf("/jython/");
        if (jython2 > -1) {
            int brEnd;
            int brEnd2;
            int brStart = jython2 + 8;
            String end = headURL.substring(brStart, headURL.length());
            if (end.startsWith("trunk/")) {
                SHORT_BRANCH = "trunk";
                BRANCH = "trunk";
                return;
            }
            if ((end.startsWith("tags/") || end.startsWith("branches/")) && (brEnd2 = end.indexOf(47, (brEnd = end.indexOf(47)) + 1)) > -1) {
                BRANCH = end.substring(0, brEnd2);
                SHORT_BRANCH = end.substring(brEnd + 1, brEnd2);
                return;
            }
        }
        BRANCH = "";
        SHORT_BRANCH = "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        boolean loaded = false;
        String versionProperties = "/org/python/version.properties";
        InputStream in = Version.class.getResourceAsStream("/org/python/version.properties");
        if (in != null) {
            try {
                Properties properties = new Properties();
                properties.load(in);
                loaded = true;
                PY_VERSION = properties.getProperty("jython.version");
                PY_MAJOR_VERSION = Integer.valueOf(properties.getProperty("jython.major_version"));
                PY_MINOR_VERSION = Integer.valueOf(properties.getProperty("jython.minor_version"));
                PY_MICRO_VERSION = Integer.valueOf(properties.getProperty("jython.micro_version"));
                PY_RELEASE_LEVEL = Integer.valueOf(properties.getProperty("jython.release_level"));
                PY_RELEASE_SERIAL = Integer.valueOf(properties.getProperty("jython.release_serial"));
                DATE = properties.getProperty("jython.build.date");
                TIME = properties.getProperty("jython.build.time");
                SVN_REVISION = properties.getProperty("jython.build.svn_revision");
            }
            catch (IOException ioe) {
                System.err.println("There was a problem loading ".concat("/org/python/version.properties").concat(":"));
                ioe.printStackTrace();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!loaded) {
            throw new RuntimeException("unable to load ".concat("/org/python/version.properties"));
        }
    }

    public static String getSubversionRevision() {
        return SVN_REVISION;
    }

    public static String getSubversionShortBranch() {
        return SHORT_BRANCH;
    }

    public static String getBuildInfo() {
        String revision = Version.getSubversionRevision();
        String sep = "".equals(revision) ? "" : ":";
        String branch = Version.getSubversionShortBranch();
        return String.format("%s%s%s, %.20s, %.9s", branch, sep, revision, DATE, TIME);
    }

    public static String getVM() {
        return String.format("\n[%s (%s)]", System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor"));
    }

    public static String getVersion() {
        return String.format("%.80s (%.80s) %.80s", PY_VERSION, Version.getBuildInfo(), Version.getVM());
    }

    public static Set<CodeFlag> getDefaultCodeFlags() {
        return EnumSet.copyOf(defaultCodeFlags);
    }

    static {
        defaultCodeFlags = Arrays.asList(CodeFlag.CO_NESTED, CodeFlag.CO_GENERATOR_ALLOWED);
        Version.initVersion();
    }
}

