/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.commons;

import java.util.StringTokenizer;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;

public class NameValidator {
    public static void validate(String s) throws Exception {
        String invalidCharacters = ": @ / \\ | ^ # ; [ ] { } < > * ' \" + ? &";
        if (s == null || s.trim().length() == 0) {
            throw new IllegalNameException();
        }
        for (int i = 0; i < s.length(); ++i) {
            String test;
            StringTokenizer tokens = new StringTokenizer(invalidCharacters);
            char c = s.charAt(i);
            boolean isInvalid = false;
            while (tokens.hasMoreTokens() && !(isInvalid = (test = tokens.nextToken()).equals(String.valueOf(c)))) {
            }
            if (Character.isLetter(c) || Character.isDigit(c) || !isInvalid) continue;
            throw new IllegalNameException(invalidCharacters);
        }
    }

    public static void validateFileName(String s) throws Exception {
        if (s == null || s.trim().length() == 0) {
            throw new IllegalNameException();
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || Character.isSpaceChar(c) || c == '_' || c == '-' || c == '(' || c == ')' || c == '.' || c == ',') continue;
            throw new IllegalNameException();
        }
    }
}

