/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.wiki.chromattic.ext.ntdef.NTVersion;
import org.exoplatform.wiki.commons.VersionNameComparatorDesc;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.service.diff.DiffResult;
import org.exoplatform.wiki.service.diff.DiffService;
import org.exoplatform.wiki.webui.UIWikiPageVersionsCompare;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.action.ShowHistoryActionListener;
import org.exoplatform.wiki.webui.control.action.ViewRevisionActionListener;
import org.exoplatform.wiki.webui.core.UIWikiContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiPageVersionsCompare.gtmpl", events={@EventConfig(listeners={ShowHistoryActionListener.class}), @EventConfig(listeners={ViewRevisionActionListener.class}), @EventConfig(listeners={CompareActionListener.class})})
public class UIWikiPageVersionsCompare
extends UIWikiContainer {
    private String differencesAsHTML;
    private String currentVersionIndex;
    private List<NTVersion> versions;
    private NTVersion fromVersion;
    private NTVersion toVersion;
    private int changes;
    public static final String SHOW_HISTORY = "ShowHistory";
    public static final String VIEW_REVISION = "ViewRevision";
    public static final String COMPARE_ACTION = "Compare";
    public static final String FROM_PARAM = "from";
    public static final String TO_PARAM = "to";

    public UIWikiPageVersionsCompare() {
        this.accept_Modes = Arrays.asList(WikiMode.COMPAREREVISION);
    }

    public List<NTVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<NTVersion> versions) {
        this.versions = versions;
    }

    public String getDifferencesAsHTML() {
        return this.differencesAsHTML;
    }

    public void setDifferencesAsHTML(String differencesAsHTML) {
        this.differencesAsHTML = differencesAsHTML;
    }

    public String getCurrentVersionIndex() {
        return this.currentVersionIndex;
    }

    public void setCurrentVersionIndex(String currentVersionIndex) {
        this.currentVersionIndex = currentVersionIndex;
    }

    public NTVersion getFromVersion() {
        return this.fromVersion;
    }

    public void setFromVersion(NTVersion fromVersion) {
        this.fromVersion = fromVersion;
    }

    public NTVersion getToVersion() {
        return this.toVersion;
    }

    public void setToVersion(NTVersion toVersion) {
        this.toVersion = toVersion;
    }

    public int getChanges() {
        return this.changes;
    }

    public void setChanges(int changes) {
        this.changes = changes;
    }

    public void renderVersionsDifference(List<NTVersion> versions, int from, int to) throws Exception {
        Collections.sort(versions, new VersionNameComparatorDesc());
        if (from < to) {
            int temp = to;
            to = from;
            from = temp;
        }
        this.versions = versions;
        NTVersion toVersion = versions.get(to);
        String toVersionContent = ((AttachmentImpl)toVersion.getNTFrozenNode().getChildren().get("content")).getText();
        NTVersion fromVersion = versions.get(from);
        String fromVersionContent = ((AttachmentImpl)fromVersion.getNTFrozenNode().getChildren().get("content")).getText();
        DiffService diffService = (DiffService)this.getApplicationComponent(DiffService.class);
        this.setRendered(true);
        this.setFromVersion(fromVersion);
        this.setToVersion(toVersion);
        this.setCurrentVersionIndex(String.valueOf(versions.size()));
        DiffResult diffResult = diffService.getDifferencesAsHTML(fromVersionContent, toVersionContent, true);
        this.setDifferencesAsHTML(diffResult.getDiffHTML());
        this.setChanges(diffResult.getChanges());
    }
}

