/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.core;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.wiki.webui.core.UIAdvancePageIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIAdvancePageIterator.gtmpl", events={@EventConfig(listeners={GoPageActionListener.class}), @EventConfig(listeners={GoNumberPageActionListener.class})})
public class UIAdvancePageIterator
extends UIForm {
    public static String PREVIOUS = "previous".intern();
    public static String NEXT = "next".intern();
    public static String FIRST = "first".intern();
    public static String LAST = "last".intern();
    public static String GOPAGE = "GoPage".intern();
    public static String GOTOPPAGE = "goPageTop".intern();
    private PageList pageList;
    private int beginPageRange = 0;
    private int endPageRange = 0;

    public UIAdvancePageIterator() {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(GOTOPPAGE, null));
        this.setSubmitAction("return false;");
    }

    public void setPageList(PageList pageList) {
        this.pageList = pageList;
    }

    public PageList getPageList() {
        return this.pageList;
    }

    public List<String> getDisplayedRange() throws Exception {
        long page;
        int max_Page = this.pageList.getAvailablePage();
        if (this.pageList.getCurrentPage() > max_Page) {
            this.pageList.getPage(max_Page);
        }
        if ((page = (long)this.pageList.getCurrentPage()) <= 3L) {
            this.beginPageRange = 1;
            this.endPageRange = max_Page <= 7 ? max_Page : 7;
        } else if ((long)max_Page > page + 3L) {
            this.endPageRange = (int)(page + 3L);
            this.beginPageRange = (int)(page - 3L);
        } else {
            this.endPageRange = max_Page;
            this.beginPageRange = max_Page > 7 ? max_Page - 6 : 1;
        }
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = this.beginPageRange; i <= this.endPageRange; ++i) {
            temp.add(String.valueOf(i));
        }
        return temp;
    }

    static /* synthetic */ PageList access$000(UIAdvancePageIterator x0) {
        return x0.pageList;
    }
}

