/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.handler;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.exoplatform.wiki.IWikiHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikbookWikiHandler
implements IWikiHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)WikbookWikiHandler.class.toString());
    public static final String FILE_EXT_WIKI = ".wiki";
    private File rootDir;
    private File homeFile;
    private File homeDir;
    private File attachmentsDir;

    public WikbookWikiHandler(String root, String homePage) {
        this.rootDir = new File(root);
        this.homeDir = new File(this.rootDir, homePage);
        this.homeFile = new File(this.homeDir, homePage + FILE_EXT_WIKI);
        this.attachmentsDir = new File(root, "attachments");
    }

    public void start(String targetUser, String targetPwd) {
        if (this.homeDir.exists()) {
            LOGGER.warn("WARNING The export dir already exists, the existing content won't be removed but may be altered.");
        }
        this.rootDir.mkdirs();
        this.homeDir.mkdirs();
        this.attachmentsDir.mkdirs();
        if (!this.homeFile.exists()) {
            try {
                this.homeFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error("Can't create file : ");
            }
        }
    }

    public void stop() {
    }

    public String normalizePageName(String title, boolean replaceSpaces) {
        return title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createPage(String path, String pageName, boolean hasChildren, String syntax) {
        File parentDir;
        File pageDir = parentDir = new File(this.rootDir, path);
        if (hasChildren) {
            pageDir = new File(parentDir, pageName);
            pageDir.mkdirs();
        }
        String parentName = WikbookWikiHandler.getFilenameFromPath(path) + FILE_EXT_WIKI;
        File parentFile = new File(parentDir, parentName);
        File pageFile = new File(pageDir, pageName + FILE_EXT_WIKI);
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(parentFile, true));
            bufferedWriter.write("{{include name=" + pageName + ".wiki}}\n");
            if (!pageFile.exists()) {
                pageFile.createNewFile();
                LOGGER.info("[Create] new file :" + pageFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            LOGGER.error("File creation failed : " + pageName);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    LOGGER.info("Failed to close the buffer writer");
                }
            }
        }
        return pageName;
    }

    public boolean transferContent(String content, String path) {
        String fileName = WikbookWikiHandler.getFilenameFromPath(path);
        File file = new File(this.rootDir, path + "/" + fileName + FILE_EXT_WIKI);
        if (!file.exists()) {
            file = new File(this.rootDir, path + FILE_EXT_WIKI);
        }
        try {
            FileUtils.writeStringToFile((File)file, (String)content);
        }
        catch (IOException e) {
            LOGGER.error("Transfer content failed : " + fileName);
            return false;
        }
        return true;
    }

    protected static String getFilenameFromPath(String path) {
        if (path == null || path.endsWith("/")) {
            return "";
        }
        if (!path.contains("/")) {
            return path;
        }
        int pos = path.lastIndexOf(47);
        return path.substring(pos + 1);
    }

    public boolean checkPageExists(String path) {
        String fileName = WikbookWikiHandler.getFilenameFromPath(path);
        File file = new File(this.rootDir, path + "/" + fileName + FILE_EXT_WIKI);
        File fileNoDir = new File(this.rootDir, path + FILE_EXT_WIKI);
        return file.exists() || fileNoDir.exists();
    }

    public boolean checkAttachmentExists(String targetSpace, String pageName, String attachmentName) {
        File attachment = new File(this.attachmentsDir, attachmentName);
        return attachment.exists();
    }

    public boolean uploadAttachment(String targetSpace, String pageName, String attachmentName, String contentType, InputStream stream) {
        File attachment = new File(this.attachmentsDir, attachmentName);
        try {
            IOUtils.copy((InputStream)stream, (OutputStream)new FileOutputStream(attachment));
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Attachment can't be saved");
            return false;
        }
    }

    public boolean uploadDocument(String targetSpace, String pageName, String attachmentName, String contentType, InputStream data) {
        return this.uploadAttachment(targetSpace, pageName, attachmentName, contentType, data);
    }
}

