/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.exoplatform.wiki.util.MacroMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MacroExtractor {
    private MacroExtractor() {
    }

    public static Map<String, Integer> extractMacro(Map<String, Integer> macrosMap, String body) {
        HashMap<String, Integer> foundMacros = new HashMap<String, Integer>();
        String newbody = MacroExtractor.cleanupBody(body);
        String[] macros = newbody.split("\\{");
        String previousPiece = "";
        for (String piece : macros) {
            if (piece.contains("}") && !previousPiece.endsWith("\\")) {
                String[] submacros = piece.split("}");
                String extractedMacro = submacros.length > 0 ? submacros[0] : "";
                submacros = extractedMacro.split(":");
                extractedMacro = submacros.length > 0 ? submacros[0] : "";
                extractedMacro = extractedMacro.trim();
                extractedMacro = extractedMacro.replaceAll("\n", "");
                extractedMacro = extractedMacro.replaceAll("\r", "");
                MacroMap.addMacro(macrosMap, extractedMacro);
                MacroMap.addMacro(foundMacros, extractedMacro);
            }
            previousPiece = piece;
        }
        return foundMacros;
    }

    private static String cleanupBody(String body) {
        String newbody = body;
        newbody = newbody.replaceAll("\\{\\{.*\\}\\}", "");
        newbody = MacroExtractor.removeBlocks("code", newbody);
        newbody = MacroExtractor.removeBlocks("csv", newbody);
        newbody = MacroExtractor.removeBlocks("noformat", newbody);
        newbody = MacroExtractor.removeBlocks("style", newbody);
        return newbody;
    }

    public static Set<String> extractMacroWithParams(String body) {
        HashSet<String> foundMacros = new HashSet<String>();
        String newbody = MacroExtractor.cleanupBody(body);
        String[] macros = newbody.split("\\{");
        String previousPiece = "";
        for (String piece : macros) {
            if (piece.contains("}") && !previousPiece.endsWith("\\")) {
                String[] submacros = piece.split("}");
                String extractedMacro = submacros.length > 0 ? submacros[0] : "";
                extractedMacro = extractedMacro.trim();
                extractedMacro = extractedMacro.replaceAll("\n", "");
                extractedMacro = extractedMacro.replaceAll("\r", "");
                foundMacros.add(extractedMacro);
            }
            previousPiece = piece;
        }
        return foundMacros;
    }

    public static String removeBlocks(String tag, String result) {
        String[] split = result.split("\\{" + tag);
        boolean matching = true;
        boolean starting = true;
        StringBuilder content = new StringBuilder();
        for (String piece : split) {
            if (matching) {
                if (!starting) {
                    piece = piece.substring(piece.indexOf("}") + 1);
                }
                content.append(piece);
            } else {
                content.append("{").append(tag).append("}");
            }
            matching = !matching;
            starting = false;
        }
        return content.toString();
    }
}

