/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.service.impl.AnswerEventListener;
import org.exoplatform.ks.ext.impl.ForumTransformHTML;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;

public class AnswersSpaceActivityPublisher
extends AnswerEventListener {
    public static final String SPACE_APP_ID = "ks-answer:spaces";
    public static final String QUESTION_ID_KEY = "QuestionId";
    public static final String ANSWER_ID_KEY = "AnswerId";
    public static final String COMMENT_ID_KEY = "CommentId";
    public static final String ACTIVITY_TYPE_KEY = "ActivityType";
    public static final String AUTHOR_KEY = "Author";
    public static final String LINK_KEY = "Link";
    public static final String QUESTION_NAME_KEY = "Name";
    public static final String LANGUAGE_KEY = "Language";
    public static final String ANSWER = "Answer";
    public static final String QUESTION = "Question";
    public static final String COMMENT = "Comment";
    public static final String ANSWER_ADD = "AnswerAdd";
    public static final String QUESTION_ADD = "QuestionAdd";
    public static final String COMMENT_ADD = "CommentAdd";
    public static final String ANSWER_UPDATE = "AnswerUpdate";
    public static final String QUESTION_UPDATE = "QuestionUpdate";
    public static final String COMMENT_UPDATE = "CommentUpdate";
    private static Log LOG = ExoLogger.getExoLogger(AnswerEventListener.class);

    public void saveAnswer(String questionId, Answer answer, boolean isNew) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            FAQService faqS = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
            Question q = faqS.getQuestionById(questionId);
            String catId = q.getCategoryId();
            if (catId == null || catId.indexOf(Utils.CATE_SPACE_ID_PREFIX) < 0) {
                return;
            }
            String msg = "@" + answer.getResponseBy();
            String body = answer.getResponses();
            String spaceId = catId.split(Utils.CATE_SPACE_ID_PREFIX)[1];
            IdentityManager identityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            Identity spaceIdentity = identityM.getOrCreateIdentity("space", spaceId, false);
            Identity userIdentity = identityM.getOrCreateIdentity("organization", answer.getResponseBy());
            Activity activity = new Activity();
            activity.setUserId(userIdentity.getId());
            activity.setTitle(StringEscapeUtils.unescapeHtml((String)msg));
            activity.setBody(StringEscapeUtils.unescapeHtml((String)ForumTransformHTML.cleanHtmlCode(body, Collections.EMPTY_LIST)));
            activity.setType(SPACE_APP_ID);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(QUESTION_ID_KEY, questionId);
            params.put(ACTIVITY_TYPE_KEY, isNew ? ANSWER_ADD : ANSWER_UPDATE);
            params.put(ANSWER_ID_KEY, answer.getId());
            params.put(AUTHOR_KEY, answer.getResponseBy());
            params.put(QUESTION_NAME_KEY, q.getQuestion());
            params.put(LINK_KEY, q.getLink());
            params.put(LANGUAGE_KEY, q.getLanguage());
            activity.setTemplateParams(params);
            activityM.recordActivity(spaceIdentity, activity);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not record Activity for space when post answer " + e.getMessage()));
        }
    }

    public void saveComment(String questionId, Comment comment, boolean isNew) {
    }

    public void saveQuestion(Question question, boolean isNew) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            String catId = question.getCategoryId();
            if (catId == null || catId.indexOf(Utils.CATE_SPACE_ID_PREFIX) < 0) {
                return;
            }
            String msg = "@" + question.getAuthor();
            String body = question.getDetail();
            String spaceId = catId.split(Utils.CATE_SPACE_ID_PREFIX)[1];
            IdentityManager identityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            Identity spaceIdentity = identityM.getOrCreateIdentity("space", spaceId, false);
            Identity userIdentity = identityM.getOrCreateIdentity("organization", question.getAuthor());
            Activity activity = new Activity();
            activity.setUserId(userIdentity.getId());
            activity.setTitle(StringEscapeUtils.unescapeHtml((String)msg));
            activity.setBody(StringEscapeUtils.unescapeHtml((String)body));
            activity.setType(SPACE_APP_ID);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(QUESTION_ID_KEY, question.getId());
            params.put(ACTIVITY_TYPE_KEY, isNew ? QUESTION_ADD : QUESTION_UPDATE);
            params.put(QUESTION_NAME_KEY, question.getQuestion());
            params.put(LINK_KEY, question.getLink());
            params.put(LANGUAGE_KEY, question.getLanguage());
            activity.setTemplateParams(params);
            activityM.recordActivity(spaceIdentity, activity);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not record Activity for space when add new questin " + e.getMessage()));
        }
    }

    public void saveAnswer(String questionId, Answer[] answers, boolean isNew) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            FAQService faqS = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
            Question q = faqS.getQuestionById(questionId);
            String catId = q.getCategoryId();
            if (catId == null || catId.indexOf(Utils.CATE_SPACE_ID_PREFIX) < 0) {
                return;
            }
            if (answers != null) {
                for (Answer a : answers) {
                    this.saveAnswer(questionId, a, isNew);
                }
            }
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not record Activity for space when post answer " + e.getMessage()));
        }
    }
}

