/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.exoplatform.ks.ext.impl.BaseKSActivity;
import org.exoplatform.ks.ext.impl.WikiSpaceActivityPublisher;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.wiki.utils.Utils;

@ComponentConfig(template="classpath:groovy/ks/social-integration/plugin/space/WikiUIActivity.gtmpl")
public class WikiUIActivity
extends BaseKSActivity {
    String getActivityMessage(WebuiBindingContext _ctx) throws Exception {
        String activityType = this.getActivityParamValue("act_key");
        if (activityType.equalsIgnoreCase("add_page")) {
            return _ctx.appRes("WikiUIActivity.label.page-create");
        }
        if ("update_page".equalsIgnoreCase(activityType)) {
            return _ctx.appRes("WikiUIActivity.label.page-update");
        }
        return "";
    }

    String getPageName() {
        return this.getActivityParamValue(WikiSpaceActivityPublisher.PAGE_TITLE_KEY);
    }

    String getPageURL() {
        String pageId = this.getActivityParamValue(WikiSpaceActivityPublisher.PAGE_ID_KEY);
        String typeId = this.getActivityParamValue(WikiSpaceActivityPublisher.PAGE_TYPE_KEY);
        String owner = this.getActivityParamValue(WikiSpaceActivityPublisher.PAGE_OWNER_KEY);
        StringBuilder sb = new StringBuilder();
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        String portalURI = portalRequestContext.getPortalURI();
        sb.append(portalURI);
        sb.append(this.getActivityParamValue(WikiSpaceActivityPublisher.SPACE_URL_KEY));
        sb.append("/").append(this.getActivityParamValue(WikiSpaceActivityPublisher.PORTLET_NAME_KEY)).append("/");
        if (!"portal".equalsIgnoreCase(typeId)) {
            sb.append(typeId.toLowerCase());
            sb.append("/");
            sb.append(Utils.validateWikiOwner((String)typeId, (String)owner));
            sb.append("/");
        }
        try {
            sb.append(URLEncoder.encode(pageId, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return sb.toString();
        }
        return sb.toString();
    }
}

