/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.PersistentApplicationState;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.pc.ExoPortletState;
import org.exoplatform.portal.pc.ExoPortletStateType;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.portal.pom.spi.wsrp.WSRP;
import org.exoplatform.portal.pom.spi.wsrp.WSRPPortletStateType;
import org.exoplatform.portal.webui.application.GadgetUtil;
import org.exoplatform.web.application.gadget.GadgetApplication;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.StatefulPortletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelAdapter<S, C extends Serializable> {
    private static final ModelAdapter<Portlet, ExoPortletState> PORTLET = new ModelAdapter<Portlet, ExoPortletState>(){

        @Override
        public StatefulPortletContext<ExoPortletState> getPortletContext(ExoContainer container, String applicationId, ApplicationState<Portlet> applicationState) throws Exception {
            DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
            Portlet preferences = (Portlet)dataStorage.load(applicationState, ApplicationType.PORTLET);
            PortletContext producerOfferedPortletContext = this.getProducerOfferedPortletContext(applicationId);
            ExoPortletState map = new ExoPortletState(producerOfferedPortletContext.getId());
            if (preferences != null) {
                for (Preference pref : preferences) {
                    map.getState().put(pref.getName(), pref.getValues());
                }
            }
            return StatefulPortletContext.create((String)"local._dumbvalue", (PortletStateType)ExoPortletStateType.getInstance(), (Serializable)map);
        }

        @Override
        public ApplicationState<Portlet> update(ExoContainer container, ExoPortletState updateState, ApplicationState<Portlet> applicationState) throws Exception {
            PortletBuilder builder = new PortletBuilder();
            for (Map.Entry entry : updateState.getState().entrySet()) {
                builder.add((String)entry.getKey(), (List)entry.getValue());
            }
            if (applicationState instanceof TransientApplicationState) {
                TransientApplicationState transientState = (TransientApplicationState)applicationState;
                transientState.setContentState((Object)builder.build());
                return transientState;
            }
            DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
            return dataStorage.save(applicationState, (Object)builder.build());
        }

        @Override
        public PortletContext getProducerOfferedPortletContext(String applicationState) {
            String[] chunks = Utils.split((String)"/", (String)applicationState);
            String appName = chunks[0];
            String portletName = chunks[1];
            return PortletContext.createPortletContext((String)("local./" + appName + "." + portletName));
        }

        @Override
        public Portlet getState(ExoContainer container, ApplicationState<Portlet> applicationState) throws Exception {
            if (applicationState instanceof TransientApplicationState) {
                TransientApplicationState transientState = (TransientApplicationState)applicationState;
                Portlet pref = (Portlet)transientState.getContentState();
                if (pref == null) {
                    pref = new Portlet();
                }
                return pref;
            }
            DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
            Portlet pref = (Portlet)dataStorage.load(applicationState, ApplicationType.PORTLET);
            if (pref == null) {
                pref = new Portlet();
            }
            return pref;
        }
    };
    private static final ModelAdapter<org.exoplatform.portal.pom.spi.gadget.Gadget, ExoPortletState> GADGET = new ModelAdapter<org.exoplatform.portal.pom.spi.gadget.Gadget, ExoPortletState>(){
        private final String WRAPPER_ID = "local./dashboard.GadgetPortlet";
        private final PortletContext WRAPPER_CONTEXT = PortletContext.createPortletContext((String)"local./dashboard.GadgetPortlet");

        @Override
        public StatefulPortletContext<ExoPortletState> getPortletContext(ExoContainer container, String applicationId, ApplicationState<org.exoplatform.portal.pom.spi.gadget.Gadget> applicationState) throws Exception {
            GadgetRegistryService gadgetService = (GadgetRegistryService)container.getComponentInstanceOfType(GadgetRegistryService.class);
            Gadget model = gadgetService.getGadget(applicationId);
            GadgetApplication application = new GadgetApplication(model.getName(), model.getUrl(), model.isLocal());
            String url = GadgetUtil.reproduceUrl(application.getUrl(), application.isLocal());
            ExoPortletState prefs = new ExoPortletState("local./dashboard.GadgetPortlet");
            prefs.getState().put("url", Arrays.asList(url));
            return StatefulPortletContext.create((String)"local._dumbvalue", (PortletStateType)ExoPortletStateType.getInstance(), (Serializable)prefs);
        }

        @Override
        public ApplicationState<org.exoplatform.portal.pom.spi.gadget.Gadget> update(ExoContainer container, ExoPortletState updateState, ApplicationState<org.exoplatform.portal.pom.spi.gadget.Gadget> gadgetApplicationState) throws Exception {
            throw new UnsupportedOperationException("Cannot edit gadget preferences");
        }

        @Override
        public PortletContext getProducerOfferedPortletContext(String applicationState) {
            return this.WRAPPER_CONTEXT;
        }

        @Override
        public Portlet getState(ExoContainer container, ApplicationState<org.exoplatform.portal.pom.spi.gadget.Gadget> applicationState) throws Exception {
            return null;
        }
    };
    private static final ModelAdapter<WSRP, WSRP> WSRP = new ModelAdapter<WSRP, WSRP>(){

        @Override
        public Portlet getState(ExoContainer container, ApplicationState<WSRP> state) throws Exception {
            return null;
        }

        @Override
        public PortletContext getProducerOfferedPortletContext(String applicationId) {
            return PortletContext.createPortletContext((String)applicationId);
        }

        @Override
        public StatefulPortletContext<WSRP> getPortletContext(ExoContainer container, String applicationId, ApplicationState<WSRP> state) throws Exception {
            DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
            WSRP wsrp = (WSRP)dataStorage.load(state, ApplicationType.WSRP_PORTLET);
            if (wsrp == null) {
                wsrp = new WSRP();
                wsrp.setPortletId(applicationId);
            }
            return StatefulPortletContext.create((String)wsrp.getPortletId(), (PortletStateType)WSRPPortletStateType.instance, (Serializable)wsrp);
        }

        @Override
        public ApplicationState<WSRP> update(ExoContainer container, WSRP updateState, ApplicationState<WSRP> state) throws Exception {
            if (state instanceof TransientApplicationState) {
                TransientApplicationState transientState = (TransientApplicationState)state;
                transientState.setContentState((Object)updateState);
                return transientState;
            }
            PersistentApplicationState persistentState = (PersistentApplicationState)state;
            DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
            return dataStorage.save((ApplicationState)persistentState, (Object)updateState);
        }
    };

    public static <S, C extends Serializable, I> ModelAdapter<S, C> getAdapter(ApplicationType<S> type) {
        if (type == ApplicationType.PORTLET) {
            ModelAdapter<Portlet, ExoPortletState> adapter = PORTLET;
            return adapter;
        }
        if (type == ApplicationType.GADGET) {
            ModelAdapter<org.exoplatform.portal.pom.spi.gadget.Gadget, ExoPortletState> adapter = GADGET;
            return adapter;
        }
        if (type == ApplicationType.WSRP_PORTLET) {
            ModelAdapter<WSRP, WSRP> adapter = WSRP;
            return adapter;
        }
        throw new AssertionError();
    }

    public abstract PortletContext getProducerOfferedPortletContext(String var1);

    public abstract StatefulPortletContext<C> getPortletContext(ExoContainer var1, String var2, ApplicationState<S> var3) throws Exception;

    public abstract ApplicationState<S> update(ExoContainer var1, C var2, ApplicationState<S> var3) throws Exception;

    public abstract Portlet getState(ExoContainer var1, ApplicationState<S> var2) throws Exception;
}

