/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.UIPageNodeSelector;
import org.exoplatform.portal.webui.page.UIDesktopPage;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPagePreview;
import org.exoplatform.portal.webui.page.UIPageTemplateOptions;
import org.exoplatform.portal.webui.page.UIPageWizard;
import org.exoplatform.portal.webui.page.UIWizardPageSelectLayoutForm;
import org.exoplatform.portal.webui.page.UIWizardPageSetInfo;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComposer;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/webui/core/UIWizard.gtmpl", events={@EventConfig(listeners={ViewStep1ActionListener.class}), @EventConfig(listeners={ViewStep2ActionListener.class}), @EventConfig(listeners={ViewStep3ActionListener.class}), @EventConfig(listeners={ViewStep4ActionListener.class}), @EventConfig(listeners={UIPageWizard.AbortActionListener.class})})})
public class UIPageCreationWizard
extends UIPageWizard {
    public static final int FIRST_STEP = 1;
    public static final int SECONDE_STEP = 2;
    public static final int THIRD_STEP = 3;
    public static final int NUMBER_OF_STEPs = 3;

    public UIPageCreationWizard() throws Exception {
        UIWizardPageSetInfo uiPageInfo = (UIWizardPageSetInfo)((UIWizardPageSetInfo)this.addChild(UIWizardPageSetInfo.class, null, null)).setRendered(false);
        ((UIWizardPageSelectLayoutForm)this.addChild(UIWizardPageSelectLayoutForm.class, null, null)).setRendered(false);
        ((UIPagePreview)this.addChild(UIPagePreview.class, null, null)).setRendered(false);
        this.setNumberSteps(3);
        this.viewStep(1);
        this.setShowWelcomeComponent(false);
        boolean isUserNav = Util.getUIPortal().getSelectedNavigation().getOwnerType().equals("user");
        if (isUserNav) {
            ((UIPageNodeSelector)uiPageInfo.getChild(UIPageNodeSelector.class)).setRendered(false);
        }
    }

    private void saveData() throws Exception {
        UserPortalConfigService service = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        UIPagePreview uiPagePreview = (UIPagePreview)this.getChild(UIPagePreview.class);
        UIPage uiPage = (UIPage)uiPagePreview.getUIComponent();
        UIPortal uiPortal = Util.getUIPortal();
        UIWizardPageSetInfo uiPageInfo = (UIWizardPageSetInfo)this.getChild(UIWizardPageSetInfo.class);
        UIPageNodeSelector uiNodeSelector = (UIPageNodeSelector)uiPageInfo.getChild(UIPageNodeSelector.class);
        PageNode selectedNode = uiNodeSelector.getSelectedPageNode();
        PageNavigation pageNav = uiNodeSelector.getSelectedNavigation();
        if ("user".equals(pageNav.getOwnerType())) {
            selectedNode = null;
        }
        Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
        PageNode pageNode = uiPageInfo.getPageNode();
        pageNode.setPageReference(page.getPageId());
        if (selectedNode != null) {
            ArrayList<PageNode> children = selectedNode.getChildren();
            if (children == null) {
                children = new ArrayList<PageNode>();
            }
            children.add(pageNode);
            selectedNode.setChildren(children);
        } else {
            pageNav.addNode(pageNode);
        }
        pageNav.setModifier(((WebuiRequestContext)RequestContext.getCurrentInstance()).getRemoteUser());
        uiNodeSelector.selectPageNodeByUri(pageNode.getUri());
        service.create(page);
        service.update(pageNav);
        this.setNavigation(uiPortal.getNavigations(), uiNodeSelector.getSelectedNavigation());
        String uri = pageNav.getId() + "::" + pageNode.getUri();
        PageNodeEvent<UIPortal> pnevent = new PageNodeEvent<UIPortal>(uiPortal, "ChangePageNode", uri);
        uiPortal.broadcast(pnevent, Event.Phase.PROCESS);
    }

    private void setNavigation(List<PageNavigation> navs, PageNavigation nav) {
        for (int i = 0; i < navs.size(); ++i) {
            if (navs.get(i).getId() != nav.getId()) continue;
            navs.set(i, nav);
            return;
        }
    }

    public boolean isSelectedNodeExist() throws Exception {
        UIWizardPageSetInfo uiPageSetInfo = (UIWizardPageSetInfo)this.getChild(UIWizardPageSetInfo.class);
        PageNavigation navigation = ((UIPageNodeSelector)uiPageSetInfo.getChild(UIPageNodeSelector.class)).getSelectedNavigation();
        PageNode pageNode = uiPageSetInfo.getPageNode();
        PageNode selectedPageNode = uiPageSetInfo.getSelectedPageNode();
        List sibbling = null;
        sibbling = selectedPageNode != null ? selectedPageNode.getChildren() : navigation.getNodes();
        if (sibbling != null) {
            for (PageNode ele : sibbling) {
                if (!ele.getUri().equals(pageNode.getUri())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep4ActionListener
    extends EventListener<UIPageCreationWizard> {
        public void execute(Event<UIPageCreationWizard> event) throws Exception {
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)((Object)event.getSource());
            uiWizard.setShowActions(true);
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiWizard.getAncestorOfType(UIPortalApplication.class);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiWizard.getAncestorOfType(UIWorkingWorkspace.class);
            ((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(false);
            if (uiWizard.isSelectedNodeExist()) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.NameNotSame", null));
                uiWizard.setDescriptionWizard(1);
                uiWizard.viewStep(1);
                uiWizard.updateWizardComponent();
                return;
            }
            uiPortalApp.setModeState(0);
            uiWizard.saveData();
            UIPortalToolPanel toolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
            toolPanel.setUIComponent(null);
            uiWizard.updateUIPortal(uiPortalApp, event);
            JavascriptManager jsManager = event.getRequestContext().getJavascriptManager();
            jsManager.addJavascript((CharSequence)"eXo.portal.portalMode=0;");
            UIWizardPageSetInfo uiPageInfo = (UIWizardPageSetInfo)uiWizard.getChild(UIWizardPageSetInfo.class);
            UIPageNodeSelector uiNodeSelector = (UIPageNodeSelector)uiPageInfo.getChild(UIPageNodeSelector.class);
            PageNode selectedNode = uiNodeSelector.getSelectedPageNode();
            String uri = Util.getPortalRequestContext().getPortalURI() + selectedNode.getUri();
            jsManager.addJavascript((CharSequence)("window.location = '" + uri + "';"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep3ActionListener
    extends EventListener<UIPageCreationWizard> {
        private void setDefaultPermission(Page page, String ownerType, String ownerId) {
            UIPortal uiPortal = Util.getUIPortal();
            if ("portal".equals(ownerType)) {
                page.setAccessPermissions(uiPortal.getAccessPermissions());
                page.setEditPermission(uiPortal.getEditPermission());
            } else if ("group".equals(ownerType)) {
                UserACL acl = (UserACL)Util.getUIPortalApplication().getApplicationComponent(UserACL.class);
                ownerId = ownerId.startsWith("/") ? ownerId : "/" + ownerId;
                page.setAccessPermissions(new String[]{"*:" + ownerId});
                page.setEditPermission(acl.getMakableMT() + ":" + ownerId);
            }
        }

        public void execute(Event<UIPageCreationWizard> event) throws Exception {
            boolean isDesktopPage;
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)((Object)event.getSource());
            uiWizard.setShowActions(false);
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiWizard.getAncestorOfType(UIPortalApplication.class);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiWizard.getAncestorOfType(UIWorkingWorkspace.class);
            PortalRequestContext context = Util.getPortalRequestContext();
            if (uiWizard.isSelectedNodeExist()) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.NameNotSame", null));
                uiWizard.setDescriptionWizard(1);
                uiWizard.viewStep(1);
                uiWizard.updateWizardComponent();
                return;
            }
            uiWizard.viewStep(3);
            if (uiWizard.getSelectedStep() < 3) {
                uiWizard.setShowActions(true);
                uiWizard.setDescriptionWizard(uiWizard.getSelectedStep());
                uiWizard.updateWizardComponent();
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.StepByStep", null));
                return;
            }
            ((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(true);
            UIPageTemplateOptions uiPageTemplateOptions = (UIPageTemplateOptions)uiWizard.findFirstComponentOfType(UIPageTemplateOptions.class);
            UIWizardPageSetInfo uiPageInfo = (UIWizardPageSetInfo)uiWizard.getChild(UIWizardPageSetInfo.class);
            UIPageNodeSelector uiNodeSelector = (UIPageNodeSelector)uiPageInfo.getChild(UIPageNodeSelector.class);
            PageNavigation pageNavi = uiNodeSelector.getSelectedNavigation();
            String ownerType = pageNavi.getOwnerType();
            String ownerId = pageNavi.getOwnerId();
            PageNode pageNode = uiPageInfo.getPageNode();
            Page page = uiPageTemplateOptions.createPageFromSelectedOption(ownerType, ownerId);
            page.setCreator(context.getRemoteUser());
            page.setName("page" + page.hashCode());
            String pageId = pageNavi.getOwnerType() + "::" + pageNavi.getOwnerId() + "::" + page.getName();
            DataStorage storage = (DataStorage)uiWizard.getApplicationComponent(DataStorage.class);
            if (storage.getPage(pageId) != null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.NameNotSame", null));
                uiWizard.setDescriptionWizard(1);
                uiWizard.viewStep(1);
                uiWizard.updateWizardComponent();
            }
            page.setModifiable(true);
            this.setDefaultPermission(page, ownerType, ownerId);
            if (page.getTitle() == null || page.getTitle().trim().length() == 0) {
                page.setTitle(pageNode.getName());
            }
            if (isDesktopPage = "Desktop".equals(page.getFactoryId())) {
                page.setShowMaxWindow(Boolean.valueOf(true));
            }
            UIPagePreview uiPagePreview = (UIPagePreview)uiWizard.getChild(UIPagePreview.class);
            UIPage uiPage = "Desktop".equals(page.getFactoryId()) ? (UIPage)uiWizard.createUIComponent(context, UIDesktopPage.class, null, null) : (UIPage)uiWizard.createUIComponent(context, UIPage.class, null, null);
            PortalDataMapper.toUIPage(uiPage, page);
            uiPagePreview.setUIComponent((UIComponent)uiPage);
            if (isDesktopPage) {
                uiWizard.saveData();
                uiWizard.updateUIPortal(uiPortalApp, event);
                return;
            }
            uiWizard.updateWizardComponent();
            uiPageTemplateOptions.setSelectedOption(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep2ActionListener
    extends EventListener<UIPageCreationWizard> {
        public void execute(Event<UIPageCreationWizard> event) throws Exception {
            Calendar endCalendar;
            Date endDate;
            Calendar startCalendar;
            Date startDate;
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)((Object)event.getSource());
            uiWizard.setShowActions(true);
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiWizard.getAncestorOfType(UIPortalApplication.class);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiWizard.getAncestorOfType(UIWorkingWorkspace.class);
            ((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(false);
            uiWizard.viewStep(2);
            if (uiWizard.getSelectedStep() < 2) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.StepByStep", null));
                uiWizard.setDescriptionWizard(1);
                uiWizard.viewStep(1);
                uiWizard.updateWizardComponent();
                return;
            }
            if (uiWizard.isSelectedNodeExist()) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.NameNotSame", null));
                uiWizard.viewStep(1);
                uiWizard.updateWizardComponent();
                return;
            }
            UIWizardPageSetInfo uiPageSetInfo = (UIWizardPageSetInfo)uiWizard.getChild(UIWizardPageSetInfo.class);
            UIPageNodeSelector uiNodeSelector = (UIPageNodeSelector)uiPageSetInfo.getChild(UIPageNodeSelector.class);
            uiWizard.setDescriptionWizard(2);
            uiWizard.updateWizardComponent();
            PageNavigation navigation = uiNodeSelector.getSelectedNavigation();
            if (navigation == null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.notSelectedPageNavigation", (Object[])new String[0]));
                uiWizard.viewStep(1);
                return;
            }
            if (uiPageSetInfo.getUIFormCheckBoxInput("showPublicationDate").isChecked() && (startDate = (startCalendar = uiPageSetInfo.getUIFormDateTimeInput("startPublicationDate").getCalendar()).getTime()).after(endDate = (endCalendar = uiPageSetInfo.getUIFormDateTimeInput("endPublicationDate").getCalendar()).getTime())) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm2.msg.startDateBeforeEndDate", null));
                uiWizard.viewStep(1);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep1ActionListener
    extends EventListener<UIPageWizard> {
        public void execute(Event<UIPageWizard> event) throws Exception {
            UIPageWizard uiWizard = (UIPageWizard)((Object)event.getSource());
            uiWizard.setDescriptionWizard(1);
            uiWizard.updateWizardComponent();
            uiWizard.viewStep(1);
            uiWizard.setShowActions(true);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiWizard.getAncestorOfType(UIWorkingWorkspace.class);
            ((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(false);
        }
    }
}

