/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.page.UIPageSelector2;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputIconSelector;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.IdentifierValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;
import org.exoplatform.webui.form.validator.Validator;

public class UIPageNodeForm2
extends UIFormTabPane {
    private PageNode pageNode_;
    private String owner_;
    private String ownerType_;
    private Object selectedParent;
    private static final String SHOW_PUBLICATION_DATE = "showPublicationDate";
    private static final String START_PUBLICATION_DATE = "startPublicationDate";
    private static final String END_PUBLICATION_DATE = "endPublicationDate";

    public UIPageNodeForm2() throws Exception {
        super("UIPageNodeForm");
        UIFormInputSet uiSettingSet = new UIFormInputSet("PageNodeSetting");
        UIFormCheckBoxInput uiDateInputCheck = new UIFormCheckBoxInput(SHOW_PUBLICATION_DATE, SHOW_PUBLICATION_DATE, (Object)false);
        uiDateInputCheck.setOnChange("SwitchPublicationDate");
        uiSettingSet.addUIFormInput((UIFormInput)new UIFormStringInput("uri", "uri", null).setEditable(false)).addUIFormInput((UIFormInput)new UIFormStringInput("name", "name", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(IdentifierValidator.class, new Object[0])).addUIFormInput((UIFormInput)new UIFormStringInput("label", "label", null).addValidator(StringLengthValidator.class, new Object[]{3, 120})).addUIFormInput((UIFormInput)new UIFormCheckBoxInput("visible", "visible", (Object)true).setChecked(true)).addUIFormInput((UIFormInput)uiDateInputCheck).addUIFormInput((UIFormInput)new UIFormDateTimeInput(START_PUBLICATION_DATE, null, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(DateTimeValidator.class, new Object[0])).addUIFormInput((UIFormInput)new UIFormDateTimeInput(END_PUBLICATION_DATE, null, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(DateTimeValidator.class, new Object[0]));
        this.addUIFormInput(uiSettingSet);
        this.setSelectedTab(uiSettingSet.getId());
        UIPageSelector2 uiPageSelector = (UIPageSelector2)this.createUIComponent(UIPageSelector2.class, null, null);
        uiPageSelector.configure("UIPageSelector2", "pageReference");
        this.addUIFormInput((UIFormInput)uiPageSelector);
        UIFormInputIconSelector uiIconSelector = new UIFormInputIconSelector("Icon", "icon");
        this.addUIFormInput((UIFormInput)uiIconSelector);
        this.setActions(new String[]{"Save", "Back"});
    }

    public PageNode getPageNode() {
        return this.pageNode_;
    }

    public void setValues(PageNode pageNode) throws Exception {
        this.pageNode_ = pageNode;
        if (pageNode == null) {
            this.getUIStringInput("name").setEditable(true);
            ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon("Default");
            this.setShowPublicationDate(false);
            return;
        }
        this.getUIStringInput("name").setEditable(false);
        this.invokeGetBindingBean(this.pageNode_);
    }

    public void invokeGetBindingBean(Object bean) throws Exception {
        super.invokeGetBindingBean(bean);
        PageNode pageNode = (PageNode)bean;
        String icon = this.pageNode_.getIcon();
        if (icon == null || icon.length() < 0) {
            icon = "Default";
        }
        ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon(icon);
        this.getUIStringInput("label").setValue((Object)this.pageNode_.getLabel());
        this.getUIFormCheckBoxInput("visible").setChecked(this.pageNode_.isVisible());
        this.setShowPublicationDate(pageNode.isShowPublicationDate());
        Calendar cal = Calendar.getInstance();
        if (pageNode.getStartPublicationDate() != null) {
            cal.setTime(pageNode.getStartPublicationDate());
            this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setCalendar(cal);
        } else {
            this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setValue(null);
        }
        if (pageNode.getEndPublicationDate() != null) {
            cal.setTime(pageNode.getEndPublicationDate());
            this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setCalendar(cal);
        } else {
            this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setValue(null);
        }
    }

    public void invokeSetBindingBean(Object bean) throws Exception {
        super.invokeSetBindingBean(bean);
        PageNode node = (PageNode)bean;
        Calendar cal = this.getUIFormDateTimeInput(START_PUBLICATION_DATE).getCalendar();
        Date date = cal != null ? cal.getTime() : null;
        node.setStartPublicationDate(date);
        cal = this.getUIFormDateTimeInput(END_PUBLICATION_DATE).getCalendar();
        date = cal != null ? cal.getTime() : null;
        node.setEndPublicationDate(date);
    }

    public void setShowPublicationDate(boolean show) {
        this.getUIFormCheckBoxInput(SHOW_PUBLICATION_DATE).setChecked(show);
        this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setRendered(show);
        this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setRendered(show);
    }

    public Object getSelectedParent() {
        return this.selectedParent;
    }

    public void setSelectedParent(Object obj) {
        this.selectedParent = obj;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
        UIPageSelector2 uiPageSelector = (UIPageSelector2)this.getChild(UIPageSelector2.class);
        if (uiPageSelector == null) {
            return;
        }
        UIPopupWindow uiPopupWindowPage = (UIPopupWindow)uiPageSelector.getChild(UIPopupWindow.class);
        if (uiPopupWindowPage == null) {
            return;
        }
        uiPopupWindowPage.processRender(context);
    }

    public void setOwner(String owner_) {
        this.owner_ = owner_;
    }

    public String getOwner() {
        return this.owner_;
    }

    public void setOwnerType(String ownerType_) {
        this.ownerType_ = ownerType_;
    }

    public String getOwnerType() {
        return this.ownerType_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreatePageActionListener
    extends EventListener<UIPageNodeForm2> {
        public void execute(Event<UIPageNodeForm2> event) throws Exception {
            UIPageNodeForm2 uiForm = (UIPageNodeForm2)((Object)event.getSource());
            UIPageSelector2 pageSelector = (UIPageSelector2)uiForm.findFirstComponentOfType(UIPageSelector2.class);
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            UIFormInputSet uiInputSet = (UIFormInputSet)pageSelector.getChild(UIFormInputSet.class);
            List children = uiInputSet.getChildren();
            for (UIComponent uiChild : children) {
                List validators;
                UIFormInputBase uiInput;
                if (!(uiChild instanceof UIFormInputBase) || !(uiInput = (UIFormInputBase)uiChild).isValid() || (validators = uiInput.getValidators()) == null) continue;
                try {
                    for (Validator validator : validators) {
                        validator.validate((UIFormInput)uiInput);
                    }
                }
                catch (MessageException ex) {
                    uiPortalApp.addMessage(ex.getDetailMessage());
                    return;
                }
                catch (Exception ex) {
                    uiPortalApp.addMessage(new ApplicationMessage(ex.getMessage(), null));
                    return;
                }
            }
            UserACL userACL = (UserACL)uiForm.getApplicationComponent(UserACL.class);
            String ownerId = uiForm.getOwner();
            String[] accessPermission = new String[]{"*:" + ownerId};
            String editPermission = userACL.getMakableMT() + ":" + ownerId;
            if ("portal".equals(uiForm.getOwnerType())) {
                UIPortal uiPortal = Util.getUIPortal();
                accessPermission = uiPortal.getAccessPermissions();
                editPermission = uiPortal.getEditPermission();
            }
            UIFormStringInput uiPageName = (UIFormStringInput)uiInputSet.getChildById("pageName");
            UIFormStringInput uiPageTitle = (UIFormStringInput)uiInputSet.getChildById("pageTitle");
            Page page = new Page();
            page.setOwnerType(uiForm.getOwnerType());
            page.setOwnerId(ownerId);
            page.setName((String)uiPageName.getValue());
            String title = (String)uiPageTitle.getValue();
            if (title == null || title.trim().length() < 1) {
                title = page.getName();
            }
            page.setTitle(title);
            page.setShowMaxWindow(Boolean.valueOf(false));
            page.setAccessPermissions(accessPermission);
            page.setEditPermission(editPermission);
            userACL.hasPermission(page);
            page.setCreator(pcontext.getRemoteUser());
            page.setModifiable(true);
            if (page.getChildren() == null) {
                page.setChildren(new ArrayList());
            }
            UserPortalConfigService service = (UserPortalConfigService)uiForm.getApplicationComponent(UserPortalConfigService.class);
            DataStorage dataStorage = (DataStorage)uiForm.getApplicationComponent(DataStorage.class);
            Page existPage = dataStorage.getPage(page.getPageId());
            if (existPage != null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageForm.msg.sameName", null));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            service.create(page);
            pageSelector.setValue(page.getPageId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClearPageActionListener
    extends EventListener<UIPageNodeForm2> {
        public void execute(Event<UIPageNodeForm2> event) throws Exception {
            UIPageNodeForm2 uiForm = (UIPageNodeForm2)((Object)event.getSource());
            UIPageSelector2 pageSelector = (UIPageSelector2)uiForm.findFirstComponentOfType(UIPageSelector2.class);
            pageSelector.setPage(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pageSelector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SwitchPublicationDateActionListener
    extends EventListener<UIPageNodeForm2> {
        public void execute(Event<UIPageNodeForm2> event) throws Exception {
            UIPageNodeForm2 uiForm = (UIPageNodeForm2)((Object)event.getSource());
            boolean isCheck = uiForm.getUIFormCheckBoxInput(UIPageNodeForm2.SHOW_PUBLICATION_DATE).isChecked();
            uiForm.getUIFormDateTimeInput(UIPageNodeForm2.START_PUBLICATION_DATE).setRendered(isCheck);
            uiForm.getUIFormDateTimeInput(UIPageNodeForm2.END_PUBLICATION_DATE).setRendered(isCheck);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIPageNodeForm2> {
        public void execute(Event<UIPageNodeForm2> event) throws Exception {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPageNodeForm2> {
        public void execute(Event<UIPageNodeForm2> event) throws Exception {
            UIFormInputIconSelector uiIconSelector;
            Calendar endCalendar;
            Date endDate;
            Calendar startCalendar;
            Date startDate;
            WebuiRequestContext ctx = event.getRequestContext();
            UIPageNodeForm2 uiPageNodeForm = (UIPageNodeForm2)((Object)event.getSource());
            UIApplication uiApp = ctx.getUIApplication();
            if (uiPageNodeForm.getUIFormCheckBoxInput(UIPageNodeForm2.SHOW_PUBLICATION_DATE).isChecked() && (startDate = (startCalendar = uiPageNodeForm.getUIFormDateTimeInput(UIPageNodeForm2.START_PUBLICATION_DATE).getCalendar()).getTime()).after(endDate = (endCalendar = uiPageNodeForm.getUIFormDateTimeInput(UIPageNodeForm2.END_PUBLICATION_DATE).getCalendar()).getTime())) {
                uiApp.addMessage(new ApplicationMessage("UIPageNodeForm2.msg.startDateBeforeEndDate", null));
                return;
            }
            PageNode pageNode = uiPageNodeForm.getPageNode();
            if (pageNode == null) {
                pageNode = new PageNode();
            }
            uiPageNodeForm.invokeSetBindingBean(pageNode);
            UIPageSelector2 pageSelector = (UIPageSelector2)uiPageNodeForm.getChild(UIPageSelector2.class);
            if (pageSelector.getPage() == null) {
                pageNode.setPageReference(null);
            }
            if ((uiIconSelector = (UIFormInputIconSelector)uiPageNodeForm.getChild(UIFormInputIconSelector.class)).getSelectedIcon().equals("Default")) {
                pageNode.setIcon(null);
            } else {
                pageNode.setIcon(uiIconSelector.getSelectedIcon());
            }
            if (pageNode.getLabel() == null) {
                pageNode.setLabel(pageNode.getName());
            }
            String remoteUser = ctx.getRemoteUser();
            Object selectedParent = uiPageNodeForm.getSelectedParent();
            PageNavigation pageNav = null;
            if (selectedParent instanceof PageNavigation) {
                pageNav = (PageNavigation)selectedParent;
                pageNav.setModifier(remoteUser);
                pageNode.setUri(pageNode.getName());
                if (!pageNav.getNodes().contains(pageNode)) {
                    if (PageNavigationUtils.searchPageNodeByUri(pageNav, pageNode.getUri()) != null) {
                        uiApp.addMessage(new ApplicationMessage("UIPageNodeForm2.msg.SameName", null));
                        return;
                    }
                    pageNav.addNode(pageNode);
                }
            } else if (selectedParent instanceof PageNode) {
                PageNode parentNode = (PageNode)selectedParent;
                ArrayList<PageNode> children = parentNode.getChildren();
                if (children == null) {
                    children = new ArrayList<PageNode>();
                    parentNode.setChildren(children);
                }
                pageNode.setUri(parentNode.getUri() + "/" + pageNode.getName());
                if (!children.contains(pageNode)) {
                    if (PageNavigationUtils.searchPageNodeByUri(parentNode, pageNode.getUri()) != null) {
                        uiApp.addMessage(new ApplicationMessage("UIPageNodeForm2.msg.SameName", null));
                        return;
                    }
                    children.add(pageNode);
                }
            }
            uiPageNodeForm.createEvent("Back", Event.Phase.DECODE, ctx).broadcast();
        }
    }
}

