/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.portal.account.UIAccountSetting;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPageActionListener;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortalActionListener;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.portal.webui.portal.UIPortalLifecycle;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIPortalLifecycle.class, template="system:/groovy/portal/webui/portal/UIPortal.gtmpl", events={@EventConfig(listeners={UIPageActionListener.ChangePageNodeActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.ChangeApplicationListActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.MoveChildActionListener.class}), @EventConfig(listeners={ChangeWindowStateActionListener.class}), @EventConfig(listeners={LogoutActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.ShowLoginFormActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.ChangeLanguageActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.EditPortalPropertiesActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.ChangeSkinActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.RecoveryPasswordAndUsernameActionListener.class}), @EventConfig(listeners={AccountSettingsActionListener.class}), @EventConfig(listeners={UIPortalActionListener.PingActionListener.class})})
public class UIPortal
extends UIContainer {
    private String storageId;
    private String owner;
    private String ownerType;
    private String locale;
    private String[] accessPermissions;
    private String editPermission;
    private String skin;
    private Properties properties;
    private List<PageNavigation> navigations;
    private List<PageNode> selectedPaths_;
    private PageNode selectedNode_;
    private PageNavigation selectedNavigation_;
    private Map<String, String[]> publicParameters_ = new HashMap<String, String[]>();
    private UIComponent maximizedUIComponent;

    @Override
    public String getStorageId() {
        return this.storageId;
    }

    @Override
    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String s) {
        this.owner = s;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String s) {
        this.locale = s;
    }

    @Override
    public String[] getAccessPermissions() {
        return this.accessPermissions;
    }

    @Override
    public void setAccessPermissions(String[] accessGroups) {
        this.accessPermissions = accessGroups;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String s) {
        this.skin = s;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public Map<String, String[]> getPublicParameters() {
        return this.publicParameters_;
    }

    public void setPublicParameters(Map<String, String[]> publicParams) {
        this.publicParameters_ = publicParams;
    }

    public List<PageNavigation> getNavigations() throws Exception {
        UserPortalConfigService serv = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        for (int i = 0; i < this.navigations.size(); ++i) {
            PageNavigation ele = this.navigations.get(i);
            if (serv.getPageNavigation(ele.getOwnerType(), ele.getOwnerId()) != null) continue;
            this.navigations.remove(i);
            --i;
        }
        return this.navigations;
    }

    public void setNavigation(List<PageNavigation> navs) throws Exception {
        UIPageBody uiPageBody;
        this.navigations = navs;
        this.selectedPaths_ = new ArrayList<PageNode>();
        if (this.navigations == null || this.navigations.size() < 1) {
            return;
        }
        PageNavigation pNav = null;
        for (PageNavigation nav : navs) {
            if (nav.getNodes() == null || nav.getNodes().size() <= 0) continue;
            pNav = nav;
            break;
        }
        if (pNav == null) {
            return;
        }
        if (this.selectedNode_ == null) {
            this.selectedNode_ = (PageNode)pNav.getNodes().get(0);
            this.selectedPaths_.add(this.selectedNode_);
        }
        if ((uiPageBody = (UIPageBody)this.findFirstComponentOfType(UIPageBody.class)) == null) {
            return;
        }
        uiPageBody.setPageBody(this.selectedNode_, this);
        UIPortalApplication uiApp = Util.getUIPortalApplication();
        this.refreshNavigation(uiApp.getLocale());
    }

    public void setSelectedNode(PageNode node) {
        this.selectedNode_ = node;
    }

    public PageNode getSelectedNode() throws Exception {
        if (this.selectedNode_ != null) {
            return this.selectedNode_;
        }
        if (this.getSelectedNavigation() == null || this.selectedNavigation_.getNodes() == null || this.selectedNavigation_.getNodes().size() < 1) {
            return null;
        }
        this.selectedNode_ = (PageNode)this.selectedNavigation_.getNodes().get(0);
        return this.selectedNode_;
    }

    public List<PageNode> getSelectedPaths() {
        return this.selectedPaths_;
    }

    public void setSelectedPaths(List<PageNode> nodes) {
        this.selectedPaths_ = nodes;
    }

    public PageNavigation getSelectedNavigation() throws Exception {
        if (this.selectedNavigation_ != null && this.selectedNavigation_.getNodes() != null && this.selectedNavigation_.getNodes().size() > 0) {
            return this.selectedNavigation_;
        }
        if (this.getNavigations().size() < 1) {
            return null;
        }
        List<PageNavigation> navs = this.getNavigations();
        PageNavigation pNav = navs.get(0);
        for (PageNavigation nav : navs) {
            if (nav.getNodes() == null || nav.getNodes().size() <= 0) continue;
            pNav = nav;
            break;
        }
        this.setSelectedNavigation(pNav);
        return pNav;
    }

    public PageNavigation getPageNavigation(int id) {
        for (PageNavigation nav : this.navigations) {
            if (nav.getId() != id) continue;
            return nav;
        }
        return null;
    }

    public void setSelectedNavigation(PageNavigation selectedNavigation) {
        this.selectedNavigation_ = selectedNavigation;
    }

    public UIComponent getMaximizedUIComponent() {
        return this.maximizedUIComponent;
    }

    public void setMaximizedUIComponent(UIComponent maximizedReferenceComponent) {
        this.maximizedUIComponent = maximizedReferenceComponent;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get((Object)name);
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public void setProperty(String name, String value) {
        if (name == null || this.properties == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            this.properties.remove((Object)name);
        } else {
            this.properties.setProperty(name, value);
        }
    }

    public void removeProperty(String name) {
        if (name == null || this.properties == null) {
            throw new NullPointerException();
        }
        this.properties.remove((Object)name);
    }

    public String getSessionAlive() {
        return this.getProperty("sessionAlive", "onDemand");
    }

    public void setSessionAlive(String type) {
        this.setProperty("sessionAlive", type);
    }

    @Deprecated
    public void refreshNavigation() {
        ResourceBundleManager mgr = (ResourceBundleManager)this.getApplicationComponent(ResourceBundleManager.class);
        for (PageNavigation nav : this.navigations) {
            if (nav.getOwnerType().equals("user")) continue;
            ResourceBundle res = mgr.getNavigationResourceBundle(this.locale, nav.getOwnerType(), nav.getOwnerId());
            for (PageNode node : nav.getNodes()) {
                this.resolveLabel(res, node);
            }
        }
    }

    public void refreshNavigation(Locale locale) {
        for (PageNavigation nav : this.navigations) {
            this.localizePageNavigation(nav, locale);
        }
    }

    private void localizePageNavigation(PageNavigation nav, Locale locale) {
        ResourceBundleManager mgr = (ResourceBundleManager)this.getApplicationComponent(ResourceBundleManager.class);
        if (nav.getOwnerType().equals("user")) {
            return;
        }
        ResourceBundle res = mgr.getNavigationResourceBundle(locale.getLanguage(), nav.getOwnerType(), nav.getOwnerId());
        for (PageNode node : nav.getNodes()) {
            this.resolveLabel(res, node);
        }
    }

    private void resolveLabel(ResourceBundle res, PageNode node) {
        node.setResolvedLabel(res);
        if (node.getChildren() == null) {
            return;
        }
        for (PageNode childNode : node.getChildren()) {
            this.resolveLabel(res, childNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AccountSettingsActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIAccountSetting uiAccountForm = uiMaskWS.createUIComponent(UIAccountSetting.class, null, null);
            uiMaskWS.setUIComponent((UIComponent)uiAccountForm);
            uiMaskWS.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeWindowStateActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortal uiPortal = (UIPortal)((Object)event.getSource());
            String portletId = event.getRequestContext().getRequestParameter("portletId");
            UIPortlet uiPortlet = (UIPortlet)uiPortal.findComponentById(portletId);
            WebuiRequestContext context = event.getRequestContext();
            uiPortlet.createEvent("ChangeWindowState", event.getExecutionPhase(), context).broadcast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogoutActionListener
    extends EventListener<UIComponent> {
        public void execute(Event<UIComponent> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            HttpServletRequest req = prContext.getRequest();
            String token = this.getTokenCookie(req);
            if (token != null) {
                AbstractTokenService tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                tokenService.deleteToken((Object)token);
            }
            req.getSession().invalidate();
            Cookie cookie = new Cookie("rememberme", "");
            cookie.setPath(req.getContextPath());
            cookie.setMaxAge(0);
            prContext.getResponse().addCookie(cookie);
            String portalName = URLEncoder.encode(prContext.getPortalOwner(), "UTF-8");
            String redirect = req.getContextPath() + "/public/" + portalName + "/";
            prContext.getResponse().sendRedirect(redirect);
            prContext.setResponseComplete(true);
        }

        private String getTokenCookie(HttpServletRequest req) {
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!"rememberme".equals(cookie.getName())) continue;
                    return cookie.getValue();
                }
            }
            return null;
        }
    }
}

