/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.Method;
import java.util.ArrayList;

class MatchData {
    Method method;
    int invocationMatchDegree = -1;
    int returnOrThrowingMatchDegree = -1;
    ArrayList argsIndices = null;
    int argsDegreeSum = 0;
    int currentParam;

    MatchData() {
    }

    MatchData(Method method) {
        this.method = method;
    }

    MatchData(Method method, int currentParam, int firstParamMatchDegree) {
        this.method = method;
        this.currentParam = currentParam;
        this.invocationMatchDegree = firstParamMatchDegree;
    }

    public String toString() {
        return "MatchData[invMatch=" + this.invocationMatchDegree + "rtnMatch=" + this.returnOrThrowingMatchDegree + "args=" + (this.argsIndices != null ? this.argsIndices.size() : 0) + "sum=" + this.argsDegreeSum + "]";
    }

    int compare(MatchData other, boolean checkArgs) {
        int invMatch = this.compareMatchDegrees(this.invocationMatchDegree, other.invocationMatchDegree);
        if (invMatch != 0) {
            return invMatch;
        }
        int retMatch = this.compareMatchDegrees(this.returnOrThrowingMatchDegree, other.returnOrThrowingMatchDegree);
        if (retMatch != 0) {
            return retMatch;
        }
        if (checkArgs) {
            if (this.argsIndices == null && other.argsIndices == null) {
                return 0;
            }
            if (this.argsIndices != null && other.argsIndices == null) {
                return -1;
            }
            if (this.argsIndices == null && other.argsIndices != null) {
                return 1;
            }
            if (this.argsIndices.size() > other.argsIndices.size()) {
                return -1;
            }
            if (this.argsIndices.size() < other.argsIndices.size()) {
                return 1;
            }
            return this.argsDegreeSum < other.argsDegreeSum ? -1 : 1;
        }
        return 0;
    }

    int compareMatchDegrees(int mine, int other) {
        if (mine < 0 && other >= 0) {
            return 1;
        }
        if (mine >= 0 && other < 0) {
            return -1;
        }
        if (mine >= 0 && other >= 0 && mine != other) {
            return mine > other ? -1 : 1;
        }
        return 0;
    }
}

