/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gatein.common.net.URLTools;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.wsrp.WSRPPortletURL;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPResourceURL
extends WSRPPortletURL {
    private static final Logger log = Logger.getLogger(WSRPResourceURL.class);
    private URL resourceURL;
    private boolean requiresRewrite = false;
    private static final Map<String, MediaType> SUPPORTED_RESOURCE_TYPES = new HashMap<String, MediaType>(4);

    public WSRPResourceURL(Mode mode, WindowState windowState, boolean secure, URL resourceURL, boolean requiresRewrite) {
        super(mode, windowState, secure);
        this.resourceURL = resourceURL;
        this.requiresRewrite = requiresRewrite;
    }

    public WSRPResourceURL() {
    }

    @Override
    protected String getURLType() {
        return "resource";
    }

    @Override
    protected void appendEnd(StringBuffer sb) {
        if (this.resourceURL != null) {
            this.createURLParameter(sb, "wsrp-url", this.resourceURL.toExternalForm());
        }
        if (this.requiresRewrite) {
            this.createURLParameter(sb, "wsrp-requiresRewrite", "true");
        }
    }

    @Override
    protected void dealWithSpecificParams(Map<String, String> params, String originalURL) {
        super.dealWithSpecificParams(params, originalURL);
        String paramValue = this.getRawParameterValueFor(params, "wsrp-requiresRewrite");
        if (paramValue == null) {
            throw new IllegalArgumentException("The parsed parameters don't contain a value for the required wsrp-requiresRewrite parameter in " + originalURL);
        }
        this.requiresRewrite = Boolean.valueOf(paramValue);
        params.remove("wsrp-requiresRewrite");
        paramValue = this.getRawParameterValueFor(params, "wsrp-url");
        if (paramValue != null) {
            try {
                paramValue = URLTools.decodeXWWWFormURL((String)paramValue);
                if (this.requiresRewrite) {
                    log.debug((Object)"Required re-writing but this is not yet implemented...");
                }
                this.resourceURL = new URL(paramValue);
                String file = this.resourceURL.getFile();
                MediaType mediaType = SUPPORTED_RESOURCE_TYPES.get(file);
                if (mediaType == null) {
                    log.debug((Object)("Couldn't determine (based on extension) MIME type of file: " + file + "\nRetrieving the associated resource will probably fail."));
                }
                params.remove("wsrp-url");
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Malformed URL: " + paramValue, e);
            }
        } else {
            throw new IllegalArgumentException("The parsed parameters don't contain a value for the required wsrp-url parameter in " + originalURL);
        }
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(this.resourceURL.toExternalForm());
        this.appendExtraParams(result);
        if (this.extra != null) {
            result.append(this.extra);
        }
        return result.toString();
    }

    static {
        SUPPORTED_RESOURCE_TYPES.put("css", MediaType.TEXT_CSS);
        SUPPORTED_RESOURCE_TYPES.put("js", MediaType.TEXT_JAVASCRIPT);
        SUPPORTED_RESOURCE_TYPES.put("png", MediaType.create((String)"image/png"));
        MediaType jpeg = MediaType.create((String)"image/jpeg");
        SUPPORTED_RESOURCE_TYPES.put("jpg", jpeg);
        SUPPORTED_RESOURCE_TYPES.put("jpeg", jpeg);
        SUPPORTED_RESOURCE_TYPES.put("gif", MediaType.create((String)"image/gif"));
        SUPPORTED_RESOURCE_TYPES.put("pdf", MediaType.create((String)"application/pdf"));
        SUPPORTED_RESOURCE_TYPES.put("txt", MediaType.create((String)"text/plain"));
    }
}

