/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.sm.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.mq.sm.jdbc.JDBCStateManager;

public class MSSQLJDBCStateManager
extends JDBCStateManager {
    static final Logger log = Logger.getLogger((Class)MSSQLJDBCStateManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDB() throws Exception {
        this.CREATE_USER_TABLE = this.sqlProperties.getProperty("CREATE_USER_TABLE", this.CREATE_USER_TABLE);
        this.CREATE_ROLE_TABLE = this.sqlProperties.getProperty("CREATE_ROLE_TABLE", this.CREATE_ROLE_TABLE);
        this.CREATE_SUBSCRIPTION_TABLE = this.sqlProperties.getProperty("CREATE_SUBSCRIPTION_TABLE", this.CREATE_SUBSCRIPTION_TABLE);
        this.GET_SUBSCRIPTION = this.sqlProperties.getProperty("GET_SUBSCRIPTION", this.GET_SUBSCRIPTION);
        this.GET_SUBSCRIPTIONS_FOR_TOPIC = this.sqlProperties.getProperty("GET_SUBSCRIPTIONS_FOR_TOPIC", this.GET_SUBSCRIPTIONS_FOR_TOPIC);
        this.LOCK_SUBSCRIPTION = this.sqlProperties.getProperty("LOCK_SUBSCRIPTION", this.LOCK_SUBSCRIPTION);
        this.INSERT_SUBSCRIPTION = this.sqlProperties.getProperty("INSERT_SUBSCRIPTION", this.INSERT_SUBSCRIPTION);
        this.UPDATE_SUBSCRIPTION = this.sqlProperties.getProperty("UPDATE_SUBSCRIPTION", this.UPDATE_SUBSCRIPTION);
        this.REMOVE_SUBSCRIPTION = this.sqlProperties.getProperty("REMOVE_SUBSCRIPTION", this.REMOVE_SUBSCRIPTION);
        this.GET_USER_BY_CLIENTID = this.sqlProperties.getProperty("GET_USER_BY_CLIENTID", this.GET_USER_BY_CLIENTID);
        this.GET_USER = this.sqlProperties.getProperty("GET_USER", this.GET_USER);
        Iterator<Map.Entry<Object, Object>> i = this.sqlProperties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("POPULATE.TABLES.")) continue;
            this.POPULATE_TABLES.add(entry.getValue());
        }
        String createString = this.sqlProperties.getProperty("CREATE_TABLES_ON_START_UP");
        if (createString == null) {
            createString = this.sqlProperties.getProperty("CREATE_TABLES_ON_STARTUP");
        }
        this.createTables = createString == null ? true : createString.trim().equalsIgnoreCase("true");
        if (this.createTables) {
            Connection connection = null;
            connection = this.dataSource.getConnection();
            try {
                PreparedStatement statement;
                try {
                    statement = connection.prepareStatement(this.CREATE_USER_TABLE);
                    statement.executeUpdate();
                }
                catch (SQLException ignored) {
                    log.trace((Object)("Error creating table: " + this.CREATE_USER_TABLE), (Throwable)ignored);
                }
                try {
                    statement = connection.prepareStatement(this.CREATE_ROLE_TABLE);
                    statement.executeUpdate();
                }
                catch (SQLException ignored) {
                    log.trace((Object)("Error creating table: " + this.CREATE_ROLE_TABLE), (Throwable)ignored);
                }
                try {
                    statement = connection.prepareStatement(this.CREATE_SUBSCRIPTION_TABLE);
                    statement.executeUpdate();
                }
                catch (SQLException ignored) {
                    log.trace((Object)("Error creating table: " + this.CREATE_SUBSCRIPTION_TABLE), (Throwable)ignored);
                }
                Iterator iter = this.POPULATE_TABLES.iterator();
                String nextQry = null;
                while (iter.hasNext()) {
                    try {
                        nextQry = (String)iter.next();
                        statement = connection.prepareStatement(nextQry);
                        statement.execute();
                    }
                    catch (SQLException ignored) {
                        log.trace((Object)("Error populating tables: " + nextQry), (Throwable)ignored);
                    }
                }
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqle) {
                    log.trace((Object)("Error when closing connection " + sqle));
                }
            }
        }
    }
}

