/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.jboss.mx.util.MetaDataUtil;

public abstract class OpenType
implements Serializable {
    private static final long serialVersionUID = -9195195325186646468L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("className", String.class), new ObjectStreamField("description", String.class), new ObjectStreamField("typeName", String.class)};
    private String className;
    private String description;
    private String typeName;
    private transient boolean array = false;
    public static final String[] ALLOWED_CLASSNAMES = new String[]{Void.class.getName(), Boolean.class.getName(), Character.class.getName(), Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), String.class.getName(), Date.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName(), ObjectName.class.getName(), CompositeData.class.getName(), TabularData.class.getName()};

    protected OpenType(String className, String typeName, String description) throws OpenDataException {
        this.init(className, typeName, description);
    }

    public String getClassName() {
        return this.className;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isArray() {
        return this.array;
    }

    public abstract boolean isValue(Object var1);

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = in.readFields();
        String className = (String)getField.get("className", null);
        String typeName = (String)getField.get("typeName", null);
        String description = (String)getField.get("description", null);
        try {
            this.init(className, typeName, description);
        }
        catch (Exception e) {
            throw new StreamCorruptedException(e.toString());
        }
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    private void init(String className, String typeName, String description) throws OpenDataException {
        if (className == null || className.trim().equals("")) {
            throw new IllegalArgumentException("null or empty class name");
        }
        if (typeName == null || typeName.trim().equals("")) {
            throw new IllegalArgumentException("null or empty type name");
        }
        if (description == null || description.trim().equals("")) {
            throw new IllegalArgumentException("null or empty description");
        }
        String testClassName = MetaDataUtil.getBaseClassName((String)className);
        if (testClassName == null) {
            throw new OpenDataException("Invalid array declaration (see the javadocs for java.lang.Class): " + className);
        }
        if (!testClassName.equals(className)) {
            this.array = true;
        }
        boolean ok = false;
        for (int i = 0; i < ALLOWED_CLASSNAMES.length; ++i) {
            if (!testClassName.equals(ALLOWED_CLASSNAMES[i])) continue;
            ok = true;
            break;
        }
        if (!ok) {
            throw new OpenDataException("Not an OpenType allowed class name: " + className);
        }
        this.className = className;
        this.typeName = typeName;
        this.description = description;
    }
}

