/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.NetBootFile;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class NetBootHelper {
    public static final String DEFAULT_NETBOOT_LISTING_URL = "jboss.netboot.listing.url";
    protected static Logger log = Logger.getLogger((Class)NetBootHelper.class);
    protected static boolean traceEnabled = log.isTraceEnabled();

    public static String buildDownloadUrlForFile(String baseUrl, String directory, String filename) {
        String part = baseUrl;
        if (part.charAt(part.length() - 1) != '/') {
            part = part + "/";
        }
        if ((part = part + directory).charAt(part.length() - 1) != '/') {
            part = part + "/";
        }
        part = part + filename;
        return part;
    }

    public static String getDefaultDownloadUrl() {
        return System.getProperty("jboss.server.home.url");
    }

    public static String getDefaultListUrl() throws IllegalStateException {
        String defaultUrl = System.getProperty(DEFAULT_NETBOOT_LISTING_URL);
        if (defaultUrl == null) {
            String autofallback = System.getProperty("jboss.netboot.use.jbossweb");
            if (autofallback == null || !autofallback.equalsIgnoreCase("false")) {
                if (traceEnabled) {
                    log.trace((Object)"jboss.netboot.use.jbossweb not defined but fallback activated...");
                }
                defaultUrl = System.getProperty("jboss.home.url");
                int cropSize = defaultUrl.length();
                if (defaultUrl.endsWith("/files")) {
                    cropSize -= "/files".length() - 1;
                } else if (defaultUrl.endsWith("/files/")) {
                    cropSize -= "/files/".length() - 1;
                } else {
                    throw new IllegalStateException("No wildcard permitted in non-file URL deployment when jboss.netboot.listing.url not defined. You must either use the JBossWeb NetBoot WAR extension, specify individual jars, use the URL:* notation or specify the jboss.netboot.listing.url system property");
                }
                defaultUrl = System.getProperty("jboss.home.url").substring(0, cropSize) + "List?";
                if (traceEnabled) {
                    log.trace((Object)("...using: " + defaultUrl));
                }
            } else {
                if (traceEnabled) {
                    log.trace((Object)"jboss.netboot.use.jbossweb not defined and fallback explicitly deactivated");
                }
                throw new IllegalStateException("No wildcard permitted in non-file URL deployment when jboss.netboot.listing.url not defined. You must either specify individual jars, use the URL:* notation or specify the jboss.netboot.listing.url system property");
            }
        }
        return StringPropertyReplacer.replaceProperties((String)defaultUrl);
    }

    public static String buildListUrlForFolder(String baseUrl, String directory) throws IllegalStateException, UnsupportedEncodingException {
        String listUrl = null;
        listUrl = baseUrl == null || "".equals(baseUrl) ? NetBootHelper.getDefaultListUrl() : baseUrl;
        return listUrl + "dir=" + URLEncoder.encode(directory, "UTF-8");
    }

    public static NetBootFile[] listAllFromDirectory(String lister) throws Exception {
        return NetBootHelper.listAllFromDirectory(lister, true, true);
    }

    public static NetBootFile[] listFilesFromDirectory(String lister) throws Exception {
        return NetBootHelper.listAllFromDirectory(lister, false, true);
    }

    public static NetBootFile[] listDirectoriesFromDirectory(String lister) throws Exception {
        return NetBootHelper.listAllFromDirectory(lister, true, false);
    }

    protected static NetBootFile[] listAllFromDirectory(String lister, boolean doDir, boolean doFiles) throws Exception {
        long size;
        long lastModified;
        String name;
        Element item;
        Iterator dirContentIter;
        if (traceEnabled) {
            log.trace((Object)("Getting directory listing from: " + lister));
        }
        ArrayList<NetBootFile> result = new ArrayList<NetBootFile>();
        InputStream stream = new URL(lister).openStream();
        InputSource is = new InputSource(stream);
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = parser.parse(is);
        if (doFiles) {
            dirContentIter = NetBootHelper.getChildrenByTagName(doc.getDocumentElement(), "file");
            while (dirContentIter.hasNext()) {
                item = (Element)dirContentIter.next();
                name = NetBootHelper.getUniqueChild(item, "name").getFirstChild().getNodeValue();
                lastModified = Long.parseLong(NetBootHelper.getUniqueChild(item, "modified").getFirstChild().getNodeValue());
                size = Long.parseLong(NetBootHelper.getUniqueChild(item, "size").getFirstChild().getNodeValue());
                result.add(new NetBootFile(name, size, lastModified, false, lister));
            }
        }
        if (doFiles) {
            dirContentIter = NetBootHelper.getChildrenByTagName(doc.getDocumentElement(), "directory");
            while (dirContentIter.hasNext()) {
                item = (Element)dirContentIter.next();
                name = NetBootHelper.getUniqueChild(item, "name").getFirstChild().getNodeValue();
                lastModified = Long.parseLong(NetBootHelper.getUniqueChild(item, "modified").getFirstChild().getNodeValue());
                size = Long.parseLong(NetBootHelper.getUniqueChild(item, "size").getFirstChild().getNodeValue());
                result.add(new NetBootFile(name, size, lastModified, true, lister));
            }
        }
        return result.toArray(new NetBootFile[0]);
    }

    protected static Element getUniqueChild(Element element, String tagName) throws DeploymentException {
        Iterator goodChildren = NetBootHelper.getChildrenByTagName(element, tagName);
        if (goodChildren != null && goodChildren.hasNext()) {
            Element child = (Element)goodChildren.next();
            if (goodChildren.hasNext()) {
                throw new DeploymentException("expected only one " + tagName + " tag");
            }
            return child;
        }
        throw new DeploymentException("expected one " + tagName + " tag");
    }

    protected static Iterator getChildrenByTagName(Element element, String tagName) {
        if (element == null) {
            return null;
        }
        NodeList children = element.getChildNodes();
        ArrayList<Element> goodChildren = new ArrayList<Element>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeType() != 1 || !((Element)currentChild).getTagName().equals(tagName)) continue;
            goodChildren.add((Element)currentChild);
        }
        return goodChildren.iterator();
    }
}

