/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.jaxws.impl;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.SortedMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxws.AbstractWrapperGenerator;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.jboss.ws.tools.jaxws.impl.WritableWrapperGenerator;
import org.jboss.wsf.common.JavaUtils;

public class SourceWrapperGenerator
extends AbstractWrapperGenerator
implements WritableWrapperGenerator {
    private static Logger log = Logger.getLogger(SourceWrapperGenerator.class);
    private PrintStream stream;
    private JCodeModel codeModel;

    public SourceWrapperGenerator(ClassLoader loader, PrintStream stream) {
        super(loader);
        this.stream = stream;
        this.codeModel = new JCodeModel();
    }

    public void reset(ClassLoader loader) {
        super.reset(loader);
        this.codeModel = new JCodeModel();
    }

    public void write(File directory) throws IOException {
        this.stream.println("Writing Source:");
        this.codeModel.build(directory, this.stream);
    }

    public void generate(ParameterMetaData pmd) {
        List<WrappedParameter> wrappedParameters = pmd.getWrappedParameters();
        OperationMetaData operationMetaData = pmd.getOperationMetaData();
        if (!operationMetaData.isDocumentWrapped()) {
            throw new WSException("Operation is not document/literal (wrapped)");
        }
        if (wrappedParameters == null) {
            throw new WSException("Cannot generate a type when their is no type information");
        }
        String wrapperName = pmd.getJavaTypeName();
        if (log.isDebugEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Generating wrapper: " + wrapperName));
        }
        try {
            JDefinedClass clazz = this.codeModel._class(wrapperName);
            SourceWrapperGenerator.addClassAnnotations(clazz, pmd.getXmlName(), pmd.getXmlType(), null);
            for (WrappedParameter wrapped : wrappedParameters) {
                this.addProperty(clazz, wrapped.getType(), wrapped.getName(), wrapped.getVariable());
            }
        }
        catch (Exception e) {
            throw new WSException("Could not generate wrapper type: " + wrapperName, e);
        }
    }

    public void generate(FaultMetaData fmd) {
        String faultBeanName = fmd.getFaultBeanName();
        Class exception = fmd.getJavaType();
        try {
            SortedMap<String, Class<?>> properties = this.getExceptionProperties(exception);
            String[] propertyOrder = properties.keySet().toArray(new String[0]);
            JDefinedClass clazz = this.codeModel._class(faultBeanName);
            SourceWrapperGenerator.addClassAnnotations(clazz, fmd.getXmlName(), fmd.getXmlType(), propertyOrder);
            for (String property : propertyOrder) {
                this.addProperty(clazz, ((Class)properties.get(property)).getName(), new QName(property), property);
            }
        }
        catch (Exception e) {
            throw new WSException("Could not generate wrapper type: " + faultBeanName, e);
        }
    }

    private static String getterPrefix(Class type) {
        return Boolean.TYPE == type || Boolean.class == type ? "is" : "get";
    }

    private void addProperty(JDefinedClass clazz, String typeName, QName name, String variable) throws ClassNotFoundException {
        Class type = JavaUtils.loadJavaType(typeName, this.loader);
        JFieldVar field = clazz.field(4, type, variable);
        JAnnotationUse annotation = field.annotate(XmlElement.class);
        if (name.getNamespaceURI() != null) {
            annotation.param("namespace", name.getNamespaceURI());
        }
        annotation.param("name", name.getLocalPart());
        JMethod method = clazz.method(1, type, SourceWrapperGenerator.getterPrefix(type) + JavaUtils.capitalize(variable));
        method.body()._return((JExpression)JExpr._this().ref(variable));
        method = clazz.method(1, Void.TYPE, "set" + JavaUtils.capitalize(variable));
        method.body().assign((JAssignmentTarget)JExpr._this().ref(variable), (JExpression)method.param(type, variable));
    }

    private static void addClassAnnotations(JDefinedClass clazz, QName xmlName, QName xmlType, String[] propertyOrder) {
        JAnnotationUse annotation = clazz.annotate(XmlRootElement.class);
        if (xmlName.getNamespaceURI() != null && xmlName.getNamespaceURI().length() > 0) {
            annotation.param("namespace", xmlName.getNamespaceURI());
        }
        annotation.param("name", xmlName.getLocalPart());
        annotation = clazz.annotate(XmlType.class);
        if (xmlType.getNamespaceURI() != null & xmlType.getNamespaceURI().length() > 0) {
            annotation.param("namespace", xmlType.getNamespaceURI());
        }
        annotation.param("name", xmlType.getLocalPart());
        if (propertyOrder != null) {
            JAnnotationArrayMember paramArray = annotation.paramArray("propOrder");
            for (String property : propertyOrder) {
                paramArray.param(property);
            }
        }
        annotation = clazz.annotate(XmlAccessorType.class);
        annotation.param("value", (Enum)XmlAccessType.FIELD);
    }
}

