/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class ConnectTest
extends ChannelTestBase {
    Channel channel;
    final int TIMES = 10;

    public ConnectTest(String name) {
        super(name);
    }

    public void tearDown() throws Exception {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        super.tearDown();
    }

    void doIt(int times) {
        for (int i = 0; i < times; ++i) {
            System.out.println("\nAttempt #" + (i + 1));
            System.out.print("Connecting to channel: ");
            try {
                this.channel.connect("ConnectTest");
                System.out.println("-- connected: " + this.channel.getView() + " --");
            }
            catch (Exception e) {
                System.out.println("-- connection failed --");
                System.err.println(e);
            }
            System.out.print("Disconnecting from channel: ");
            this.channel.disconnect();
            System.out.println("-- disconnected --");
        }
    }

    public void testConnectAndDisconnect() throws Exception {
        System.out.print("Creating channel: ");
        this.channel = this.createChannel();
        System.out.println("-- created --");
        this.doIt(10);
        System.out.print("Closing channel: ");
        this.channel.close();
        System.out.println("-- closed --");
        System.out.println("Remaining threads are:");
        Util.printThreads();
    }

    public void testDisconnectConnectOne() throws Exception {
        this.channel = this.createChannel();
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup2");
        View view = this.channel.getView();
        ConnectTest.assertEquals((int)1, (int)view.size());
        ConnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
        this.channel.close();
        System.out.println("Remaining threads are:");
        Util.printThreads();
    }

    public void testDisconnectConnectTwo() throws Exception {
        JChannel coordinator = this.createChannel("A");
        ((Channel)coordinator).connect("testgroup");
        View view = ((Channel)coordinator).getView();
        System.out.println("-- view for coordinator: " + view);
        this.channel = this.createChannel("A");
        this.channel.connect("testgroup1");
        view = this.channel.getView();
        System.out.println("-- view for channel: " + view);
        this.channel.disconnect();
        this.channel.connect("testgroup");
        view = this.channel.getView();
        System.out.println("-- view for channel: " + view);
        ConnectTest.assertEquals((int)2, (int)view.size());
        ConnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
        ConnectTest.assertTrue((boolean)view.containsMember(((Channel)coordinator).getLocalAddress()));
        ((Channel)coordinator).close();
        this.channel.close();
        System.out.println("Remaining threads are:");
        Util.printThreads();
    }

    public void testDisconnectConnectSendTwo() throws Exception {
        Promise msgPromise = new Promise();
        JChannel coordinator = this.createChannel("A");
        ((Channel)coordinator).connect("testgroup");
        PullPushAdapter ppa = new PullPushAdapter((Transport)coordinator, new PromisedMessageListener(msgPromise));
        ppa.start();
        this.channel = this.createChannel("A");
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = (Message)msgPromise.getResult(20000L);
        ConnectTest.assertTrue((msg != null ? 1 : 0) != 0);
        ConnectTest.assertEquals((Object)"payload", (Object)msg.getObject());
        ppa.stop();
        ((Channel)coordinator).close();
        this.channel.close();
        System.out.println("Remaining threads are:");
        Util.printThreads();
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ConnectTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    private static class PromisedMessageListener
    implements MessageListener {
        private Promise promise;

        public PromisedMessageListener(Promise promise) {
            this.promise = promise;
        }

        public byte[] getState() {
            return null;
        }

        public void receive(Message msg) {
            this.promise.setResult(msg);
        }

        public void setState(byte[] state) {
        }
    }
}

