/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class MessageBundlingTest
extends ChannelTestBase {
    private JChannel ch1;
    private JChannel ch2;
    private MyReceiver r2;
    private static final long LATENCY = 30L;
    private static final long SLEEP = 5000L;
    private static final boolean BUNDLING = true;
    private static final int MAX_BYTES = 20000;

    public void setUp() throws Exception {
        super.setUp();
        this.ch1 = this.createChannel();
        this.setBundling(this.ch1, true, 20000, 30L);
        this.setLoopback(this.ch1, false);
        this.ch1.setReceiver(new NullReceiver());
        this.ch1.connect("x");
        this.ch2 = this.createChannel();
        this.setBundling(this.ch2, true, 20000, 30L);
        this.setLoopback(this.ch1, false);
        this.r2 = new MyReceiver();
        this.ch2.setReceiver(this.r2);
        this.ch2.connect("x");
        View view = this.ch2.getView();
        MessageBundlingTest.assertEquals((int)2, (int)view.size());
    }

    public void tearDown() throws Exception {
        this.closeChannel(this.ch2);
        this.closeChannel(this.ch1);
        super.tearDown();
    }

    protected boolean useBlocking() {
        return false;
    }

    public void testLatencyWithoutMessageBundling() throws ChannelClosedException, ChannelNotConnectedException {
        Message tmp = new Message();
        this.setBundling(this.ch1, false, 20000, 30L);
        this.r2.setNumExpectedMesssages(1);
        Promise promise = new Promise();
        this.r2.setPromise(promise);
        long time = System.currentTimeMillis();
        this.ch1.send(tmp);
        System.out.println(">>> sent message at " + new Date());
        promise.getResult(5000L);
        List<Long> list = this.r2.getTimes();
        MessageBundlingTest.assertEquals((int)1, (int)list.size());
        Long time2 = list.get(0);
        long diff = time2 - time;
        System.out.println("latency: " + diff + " ms");
        MessageBundlingTest.assertTrue((String)("latency (" + diff + "ms) should be less than " + 30L + " ms"), (diff < 30L ? 1 : 0) != 0);
    }

    public void testLatencyWithMessageBundling() throws ChannelClosedException, ChannelNotConnectedException {
        Message tmp = new Message();
        this.r2.setNumExpectedMesssages(1);
        Promise promise = new Promise();
        this.r2.setPromise(promise);
        long time = System.currentTimeMillis();
        this.ch1.send(tmp);
        System.out.println(">>> sent message at " + new Date());
        promise.getResult(5000L);
        List<Long> list = this.r2.getTimes();
        MessageBundlingTest.assertEquals((int)1, (int)list.size());
        Long time2 = list.get(0);
        long diff = time2 - time;
        System.out.println("latency: " + diff + " ms");
        MessageBundlingTest.assertTrue((String)("latency (" + diff + "ms) should be more than the bundling timeout (" + 30L + "ms), but less than 2 times the LATENCY (" + 60L + ")"), (diff > 30L && diff < 60L ? 1 : 0) != 0);
    }

    public void testLatencyWithMessageBundlingAndLoopback() throws ChannelClosedException, ChannelNotConnectedException {
        Message tmp = new Message();
        this.setLoopback(this.ch1, true);
        this.setLoopback(this.ch2, true);
        this.r2.setNumExpectedMesssages(1);
        Promise promise = new Promise();
        this.r2.setPromise(promise);
        long time = System.currentTimeMillis();
        System.out.println(">>> sending message at " + new Date());
        this.ch1.send(tmp);
        promise.getResult(5000L);
        List<Long> list = this.r2.getTimes();
        MessageBundlingTest.assertEquals((int)1, (int)list.size());
        Long time2 = list.get(0);
        long diff = time2 - time;
        System.out.println("latency: " + diff + " ms");
        MessageBundlingTest.assertTrue((String)("latency (" + diff + "ms) should be more than the bundling timeout (" + 30L + "ms), but less than 2 times the LATENCY (" + 60L + ")"), (diff > 30L && diff < 60L ? 1 : 0) != 0);
    }

    public void testLatencyWithMessageBundlingAndMaxBytes() throws ChannelClosedException, ChannelNotConnectedException {
        this.setLoopback(this.ch1, true);
        this.setLoopback(this.ch2, true);
        this.r2.setNumExpectedMesssages(10);
        Promise promise = new Promise();
        this.r2.setPromise(promise);
        Util.sleep(60L);
        System.out.println(">>> sending 10 messages at " + new Date());
        for (int i = 0; i < 10; ++i) {
            this.ch1.send(new Message(null, null, new byte[2000]));
        }
        promise.getResult(5000L);
        List<Long> list = this.r2.getTimes();
        MessageBundlingTest.assertEquals((int)10, (int)list.size());
        for (Long val : list) {
            System.out.println(val);
        }
    }

    public void testSimple() throws ChannelClosedException, ChannelNotConnectedException {
        Message tmp = new Message();
        this.ch2.setReceiver(new SimpleReceiver());
        this.ch1.send(tmp);
        System.out.println(">>> sent message at " + new Date());
        Util.sleep(10000L);
    }

    private void setLoopback(JChannel ch, boolean b) {
        ProtocolStack stack = ch.getProtocolStack();
        Vector<Protocol> prots = stack.getProtocols();
        TP transport = (TP)prots.lastElement();
        transport.setLoopback(b);
    }

    private void setBundling(JChannel ch, boolean enabled, int max_bytes, long timeout) {
        ProtocolStack stack = ch.getProtocolStack();
        Vector<Protocol> prots = stack.getProtocols();
        TP transport = (TP)prots.lastElement();
        transport.setEnableBundling(enabled);
        transport.setMaxBundleSize(max_bytes);
        transport.setMaxBundleTimeout(timeout);
    }

    private void closeChannel(Channel c) {
        if (c != null && (c.isOpen() || c.isConnected())) {
            c.close();
        }
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{MessageBundlingTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        private final List<Long> times = new LinkedList<Long>();
        private int num_expected_msgs;
        private Promise promise;

        private MyReceiver() {
        }

        public List<Long> getTimes() {
            return this.times;
        }

        public void setNumExpectedMesssages(int num_expected_msgs) {
            this.num_expected_msgs = num_expected_msgs;
        }

        public void setPromise(Promise promise) {
            this.promise = promise;
        }

        public int size() {
            return this.times.size();
        }

        @Override
        public void receive(Message msg) {
            this.times.add(new Long(System.currentTimeMillis()));
            System.out.println("<<< received message from " + msg.getSrc() + " at " + new Date());
            if (this.times.size() >= this.num_expected_msgs && this.promise != null) {
                this.promise.setResult(this.times.size());
            }
        }
    }

    private static class SimpleReceiver
    extends ReceiverAdapter {
        long start = System.currentTimeMillis();

        private SimpleReceiver() {
        }

        public void receive(Message msg) {
            System.out.println("<<< received message from " + msg.getSrc() + " at " + new Date() + ", latency=" + (System.currentTimeMillis() - this.start) + " ms");
        }
    }

    private static class NullReceiver
    extends ReceiverAdapter {
        private NullReceiver() {
        }

        public void receive(Message msg) {
        }
    }
}

