/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.RepositoryIndexSearcherHolder;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SystemSearchManager
extends SearchManager {
    private final Log log = ExoLogger.getLogger((String)"jcr.SystemSearchManager");
    private boolean isStarted = false;
    private List<ItemStateChangesLog> changesLogBuffer = new ArrayList<ItemStateChangesLog>();
    public static final String INDEX_DIR_SUFFIX = "system";

    public SystemSearchManager(QueryHandlerEntry config, NamespaceRegistryImpl nsReg, NodeTypeDataManager ntReg, WorkspacePersistentDataManager itemMgr, DocumentReaderService service, ConfigurationManager cfm, RepositoryIndexSearcherHolder indexSearcherHolder) throws RepositoryException, RepositoryConfigurationException {
        super(config, nsReg, ntReg, itemMgr, null, service, cfm, indexSearcherHolder);
    }

    public void onSaveItems(ItemStateChangesLog changesLog) {
        if (!this.isStarted) {
            this.changesLogBuffer.add(changesLog);
        } else {
            super.onSaveItems(changesLog);
        }
    }

    public void start() {
        this.isStarted = true;
        try {
            if (this.indexingTree == null) {
                ArrayList<QPath> excludedPaths = new ArrayList<QPath>();
                NodeData indexingRootNodeData = (NodeData)this.itemMgr.getItemData("00exo0jcr0system0uuid00000000000");
                this.indexingTree = new IndexingTree(indexingRootNodeData, excludedPaths);
            }
            this.initializeQueryHandler();
        }
        catch (RepositoryException e) {
            this.log.error((Object)e.getLocalizedMessage());
            this.handler = null;
            this.changesLogBuffer.clear();
            this.changesLogBuffer = null;
            throw new RuntimeException(e);
        }
        catch (RepositoryConfigurationException e) {
            this.log.error((Object)e.getLocalizedMessage());
            this.handler = null;
            this.changesLogBuffer.clear();
            this.changesLogBuffer = null;
            throw new RuntimeException(e);
        }
        for (ItemStateChangesLog bufferedChangesLog : this.changesLogBuffer) {
            super.onSaveItems(bufferedChangesLog);
        }
        this.changesLogBuffer.clear();
        this.changesLogBuffer = null;
    }

    protected QueryHandlerContext createQueryHandlerContext(QueryHandler parentHandler) throws RepositoryConfigurationException {
        QueryHandlerContext context = new QueryHandlerContext(this.itemMgr, this.indexingTree, this.nodeTypeDataManager, this.nsReg, parentHandler, this.getIndexDir() + "_" + INDEX_DIR_SUFFIX, this.extractor, this.changesLogBuffer.size() > 0 && !this.isStarted, this.virtualTableResolver);
        return context;
    }
}

