/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.definition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.definition.PortalContainerDefinition;
import org.exoplatform.container.definition.PortalContainerDefinitionPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalContainerConfig
implements Startable {
    public static final String DEFAULT_PORTAL_CONTAINER_NAME = "portal";
    public static final String DEFAULT_REST_CONTEXT_NAME = "rest";
    public static final String DEFAULT_REALM_NAME = "exo-domain";
    private String defaultPortalContainerName;
    private String defaultRestContextName;
    private String defaultRealmName;
    private volatile boolean initialized;
    private List<String> portalContainerNames;
    private Map<String, List<String>> scopes;
    private Map<String, PortalContainerDefinition> definitions = Collections.unmodifiableMap(new HashMap());

    public PortalContainerConfig() {
        this(null);
    }

    public PortalContainerConfig(InitParams params) {
        ValueParam vRn;
        ValueParam vRc;
        if (params == null) {
            return;
        }
        ValueParam vDpc = params.getValueParam("default.portal.container");
        if (vDpc != null && vDpc.getValue().trim().length() > 0) {
            this.defaultPortalContainerName = vDpc.getValue().trim();
        }
        if ((vRc = params.getValueParam("default.rest.context")) != null && vRc.getValue().trim().length() > 0) {
            this.defaultRestContextName = vRc.getValue().trim();
        }
        if ((vRn = params.getValueParam("default.realm.name")) != null && vRn.getValue().trim().length() > 0) {
            this.defaultRealmName = vRn.getValue().trim();
        }
    }

    public String getDefaultPortalContainer() {
        return this.defaultPortalContainerName;
    }

    public String getDefaultRestContext() {
        return this.defaultRestContextName;
    }

    public String getDefaultRealmName() {
        return this.defaultRealmName;
    }

    public boolean hasDefinition() {
        return !this.definitions.isEmpty();
    }

    public synchronized void registerPortalContainerName(String name) {
        if (!this.portalContainerNames.contains(name)) {
            ArrayList<String> lPortalContainerNames = new ArrayList<String>(this.portalContainerNames.size() + 1);
            lPortalContainerNames.add(name);
            lPortalContainerNames.addAll(this.portalContainerNames);
            this.portalContainerNames = Collections.unmodifiableList(lPortalContainerNames);
        }
    }

    public synchronized void unregisterPortalContainerName(String name) {
        if (this.portalContainerNames.contains(name)) {
            ArrayList<String> lPortalContainerNames = new ArrayList<String>(this.portalContainerNames);
            lPortalContainerNames.remove(name);
            this.portalContainerNames = Collections.unmodifiableList(lPortalContainerNames);
        }
    }

    public boolean isPortalContainerName(String name) {
        return name == null ? false : this.portalContainerNames.contains(name);
    }

    public List<String> getPortalContainerNames(String contextName) {
        if (contextName == null) {
            throw new IllegalArgumentException("The context name cannot be null");
        }
        List<String> result = this.scopes.get(contextName);
        if (result == null || result.isEmpty()) {
            String portalContainerName = this.portalContainerNames.contains(contextName) ? contextName : this.defaultPortalContainerName;
            return Collections.singletonList(portalContainerName);
        }
        return result;
    }

    public String getPortalContainerName(String contextName) {
        if (contextName == null) {
            throw new IllegalArgumentException("The context name cannot be null");
        }
        if (this.portalContainerNames.contains(contextName)) {
            return contextName;
        }
        List<String> result = this.scopes.get(contextName);
        if (result == null || result.isEmpty()) {
            return this.defaultPortalContainerName;
        }
        return result.get(0);
    }

    public List<String> getDependencies(String portalContainerName) {
        PortalContainerDefinition definition = this.definitions.get(portalContainerName);
        return definition == null ? null : definition.getDependencies();
    }

    public String getRestContextName(String portalContainerName) {
        PortalContainerDefinition definition = this.definitions.get(portalContainerName);
        if (definition == null) {
            return this.defaultRestContextName;
        }
        String contextName = definition.getRestContextName();
        return contextName == null ? this.defaultRestContextName : contextName;
    }

    public String getRealmName(String portalContainerName) {
        PortalContainerDefinition definition = this.definitions.get(portalContainerName);
        if (definition == null) {
            return this.defaultRealmName;
        }
        String realmName = definition.getRealmName();
        return realmName == null ? this.defaultRealmName : realmName;
    }

    public boolean isScopeValid(String portalContainerName, String contextName) {
        List<String> result = this.scopes.get(contextName);
        if (result == null || result.isEmpty()) {
            return true;
        }
        return result.contains(portalContainerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPlugin(PortalContainerDefinitionPlugin plugin) {
        List<PortalContainerDefinition> lDefs = plugin.getPortalContainerDefinitions();
        if (lDefs != null && !lDefs.isEmpty()) {
            PortalContainerConfig portalContainerConfig = this;
            synchronized (portalContainerConfig) {
                if (this.initialized) {
                    throw new IllegalStateException("The PortalContainerConfig has already been initialized");
                }
                HashMap<String, PortalContainerDefinition> tempDefinitions = new HashMap<String, PortalContainerDefinition>(this.definitions);
                for (PortalContainerDefinition def : lDefs) {
                    String name = def.getName();
                    if (name == null || (name = name.trim()).length() == 0) continue;
                    def.setName(name);
                    tempDefinitions.put(name, def);
                }
                this.definitions = Collections.unmodifiableMap(tempDefinitions);
            }
        }
    }

    private void registerDependencies(PortalContainerDefinition definition, Map<String, List<String>> scopes) {
        List<String> dependencies = definition.getDependencies();
        if (definition == null || dependencies.isEmpty()) {
            return;
        }
        for (String context : dependencies) {
            if (context == null || (context = context.trim()).length() == 0) continue;
            List<String> lPortalContainerNames = scopes.get(context);
            lPortalContainerNames = lPortalContainerNames == null ? new ArrayList<String>() : new ArrayList<String>(lPortalContainerNames);
            lPortalContainerNames.add(definition.getName());
            scopes.put(context, Collections.unmodifiableList(lPortalContainerNames));
        }
    }

    private void initialize(Map<String, PortalContainerDefinition> mDefinitions) {
        if (mDefinitions.isEmpty() && this.defaultPortalContainerName == null) {
            this.defaultPortalContainerName = DEFAULT_PORTAL_CONTAINER_NAME;
        }
        ArrayList<String> lPortalContainerNames = new ArrayList<String>(mDefinitions.size() + 1);
        if (this.defaultPortalContainerName != null) {
            lPortalContainerNames.add(this.defaultPortalContainerName);
        }
        HashMap<String, List<String>> mScopes = new HashMap<String, List<String>>();
        for (Map.Entry<String, PortalContainerDefinition> entry : mDefinitions.entrySet()) {
            PortalContainerDefinition definition = entry.getValue();
            String name = definition.getName();
            if (!name.equals(this.defaultPortalContainerName)) {
                if (this.defaultPortalContainerName == null) {
                    this.defaultPortalContainerName = name;
                }
                lPortalContainerNames.add(name);
            }
            if (this.defaultRestContextName == null) {
                this.defaultRestContextName = definition.getRestContextName();
            }
            if (this.defaultRealmName == null) {
                this.defaultRealmName = definition.getRealmName();
            }
            this.registerDependencies(definition, mScopes);
        }
        this.portalContainerNames = Collections.unmodifiableList(lPortalContainerNames);
        this.scopes = Collections.unmodifiableMap(mScopes);
        if (this.defaultRestContextName == null) {
            this.defaultRestContextName = DEFAULT_REST_CONTEXT_NAME;
        }
        if (this.defaultRealmName == null) {
            this.defaultRealmName = DEFAULT_REALM_NAME;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.initialized) {
            PortalContainerConfig portalContainerConfig = this;
            synchronized (portalContainerConfig) {
                if (this.initialized) {
                    return;
                }
                this.initialized = true;
            }
        } else {
            return;
        }
        this.initialize(this.definitions);
    }

    public void stop() {
    }
}

