/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.resource.connectionmanager.InternalManagedConnectionPool;

public class IdleRemover {
    private final Logger log = Logger.getLogger(this.getClass());
    private final Collection pools = new ArrayList();
    private long interval = Long.MAX_VALUE;
    private long next = Long.MAX_VALUE;
    private static final IdleRemover remover = new IdleRemover();

    public static void registerPool(InternalManagedConnectionPool mcp, long interval) {
        remover.internalRegisterPool(mcp, interval);
    }

    public static void unregisterPool(InternalManagedConnectionPool mcp) {
        remover.internalUnregisterPool(mcp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForBackgroundThread() {
        Collection collection = IdleRemover.remover.pools;
        synchronized (collection) {
            return;
        }
    }

    private IdleRemover() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                IdleRemoverRunnable runnable = new IdleRemoverRunnable();
                Thread removerThread = new Thread((Runnable)runnable, "IdleRemover");
                removerThread.setDaemon(true);
                removerThread.start();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRegisterPool(InternalManagedConnectionPool mcp, long interval) {
        this.log.debug((Object)("internalRegisterPool: registering pool with interval " + interval + " old interval: " + this.interval));
        Collection collection = this.pools;
        synchronized (collection) {
            this.pools.add(mcp);
            if (interval > 1L && interval / 2L < this.interval) {
                this.interval = interval / 2L;
                long maybeNext = System.currentTimeMillis() + this.interval;
                if (this.next > maybeNext && maybeNext > 0L) {
                    this.next = maybeNext;
                    this.log.debug((Object)("internalRegisterPool: about to notify thread: old next: " + this.next + ", new next: " + maybeNext));
                    this.pools.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUnregisterPool(InternalManagedConnectionPool mcp) {
        Collection collection = this.pools;
        synchronized (collection) {
            this.pools.remove(mcp);
            if (this.pools.size() == 0) {
                this.log.debug((Object)"internalUnregisterPool: setting interval to Long.MAX_VALUE");
                this.interval = Long.MAX_VALUE;
            }
        }
    }

    private void setupContextClassLoader() {
        final ClassLoader cl = IdleRemover.class.getClassLoader();
        if (cl == null) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Thread.currentThread().setContextClassLoader(cl);
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    private class IdleRemoverRunnable
    implements Runnable {
        private IdleRemoverRunnable() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            IdleRemover.this.setupContextClassLoader();
            Collection collection = IdleRemover.this.pools;
            synchronized (collection) {
                while (true) {
                    try {
                        while (true) {
                            IdleRemover.this.pools.wait(IdleRemover.this.interval);
                            IdleRemover.this.log.debug((Object)("run: IdleRemover notifying pools, interval: " + IdleRemover.this.interval));
                            Iterator i = IdleRemover.this.pools.iterator();
                            while (i.hasNext()) {
                                ((InternalManagedConnectionPool)i.next()).removeTimedOut();
                            }
                            IdleRemover.this.next = System.currentTimeMillis() + IdleRemover.this.interval;
                            if (IdleRemover.this.next >= 0L) continue;
                            IdleRemover.this.next = Long.MAX_VALUE;
                        }
                    }
                    catch (InterruptedException ie) {
                        IdleRemover.this.log.info((Object)"run: IdleRemover has been interrupted, returning");
                        return;
                    }
                    catch (RuntimeException e) {
                        IdleRemover.this.log.warn((Object)"run: IdleRemover ignored unexpected runtime exception", (Throwable)e);
                        continue;
                    }
                    catch (Error e) {
                        IdleRemover.this.log.warn((Object)"run: IdleRemover ignored unexpected error", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

