/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.jcr;

import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.chromattic.common.AbstractFilterIterator;
import org.chromattic.common.CompoundIterator;
import org.chromattic.core.jcr.NodeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinkManager {
    private Map<String, Entry> entries = new HashMap<String, Entry>();
    protected final Session session;

    public AbstractLinkManager(Session session) {
        this.session = session;
    }

    public Iterator<Node> getReferents(Node referenced, String propertyName) throws RepositoryException {
        Entry entry = this.getEntry(referenced);
        return entry.iterator(propertyName);
    }

    protected abstract Node _getReferenced(Property var1) throws RepositoryException;

    protected abstract void _setReferenced(Node var1, String var2, Node var3) throws RepositoryException;

    protected abstract Iterator<Node> _getReferents(Node var1, String var2) throws RepositoryException;

    public Node getReferenced(Node referent, String propertyName) throws RepositoryException {
        if (referent.hasProperty(propertyName)) {
            Property property = referent.getProperty(propertyName);
            return this._getReferenced(property);
        }
        return null;
    }

    public Node setReferenced(Node referent, String propertyName, Node referenced) throws RepositoryException {
        Property property;
        Node oldReferenced = null;
        if (referent.hasProperty(propertyName) && (oldReferenced = this._getReferenced(property = referent.getProperty(propertyName))) != null) {
            Entry entry = this.getEntry(oldReferenced);
            boolean scheduleForAddition = true;
            NodeSet propertyScheduledForAddition = (NodeSet)entry.propertiesScheduledForAddition.get(propertyName);
            if (propertyScheduledForAddition != null && propertyScheduledForAddition.contains(referent)) {
                propertyScheduledForAddition.remove(referent);
                scheduleForAddition = false;
            }
            if (scheduleForAddition) {
                NodeSet propertyScheduledForRemoval = (NodeSet)entry.propertiesScheduledForRemoval.get(propertyName);
                if (propertyScheduledForRemoval == null) {
                    propertyScheduledForRemoval = new NodeSet();
                    entry.propertiesScheduledForRemoval.put(propertyName, propertyScheduledForRemoval);
                }
                propertyScheduledForRemoval.add(referent);
                entry.version++;
            }
        }
        this._setReferenced(referent, propertyName, referenced);
        if (referenced != null) {
            Entry entry = this.getEntry(referenced);
            NodeSet srcs = (NodeSet)entry.propertiesScheduledForAddition.get(propertyName);
            if (srcs == null) {
                srcs = new NodeSet();
                entry.propertiesScheduledForAddition.put(propertyName, srcs);
            }
            srcs.add(referent);
            entry.version++;
        }
        return oldReferenced;
    }

    public void clear() {
        this.entries.clear();
    }

    private Entry getEntry(Node referenced) throws RepositoryException {
        Entry entry = this.entries.get(referenced.getUUID());
        if (entry == null) {
            entry = new Entry(referenced);
            this.entries.put(referenced.getUUID(), entry);
        }
        return entry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry {
        private int version = 0;
        private final Node referenced;
        private final Map<String, NodeSet> propertiesScheduledForAddition;
        private final Map<String, NodeSet> propertiesScheduledForRemoval;

        private Entry(Node referenced) {
            this.referenced = referenced;
            this.propertiesScheduledForAddition = new HashMap<String, NodeSet>();
            this.propertiesScheduledForRemoval = new HashMap<String, NodeSet>();
        }

        public Iterator<Node> iterator(String propertyName) throws RepositoryException {
            Set blah = this.propertiesScheduledForRemoval.get(propertyName);
            if (blah == null) {
                blah = Collections.emptySet();
            }
            final Set tutu = blah;
            Iterator<Node> aaa = AbstractLinkManager.this._getReferents(this.referenced, propertyName);
            AbstractFilterIterator<Node, Node> i1 = new AbstractFilterIterator<Node, Node>(aaa){

                protected Node adapt(Node node) {
                    if (!tutu.contains(node)) {
                        return node;
                    }
                    return null;
                }
            };
            NodeSet srcs = this.propertiesScheduledForAddition.get(propertyName);
            if (srcs == null) {
                srcs = new NodeSet();
                this.propertiesScheduledForAddition.put(propertyName, srcs);
            }
            Iterator<Node> i2 = srcs.iterator();
            return new CompoundIterator<Node>(new Iterator[]{i1, i2}){
                int version;
                {
                    this.version = Entry.this.version;
                }

                private void check() {
                    if (this.version != Entry.this.version) {
                        throw new ConcurrentModificationException();
                    }
                }

                public boolean hasNext() {
                    this.check();
                    return super.hasNext();
                }

                public Node next() {
                    this.check();
                    return (Node)super.next();
                }

                public void remove() {
                    this.check();
                    super.remove();
                    this.version = Entry.this.version++;
                }
            };
        }
    }
}

