/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageUtils {
    public static void createNodeFromPageTemplate(String nodeName, String nodeLabel, String pageId, PageNode parentNode) throws Exception {
        UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
        UserPortalConfigService configService = (UserPortalConfigService)uiPortalApp.getApplicationComponent(UserPortalConfigService.class);
        String accessUser = Util.getPortalRequestContext().getRemoteUser();
        PageNode node = configService.createNodeFromPageTemplate(nodeName, nodeLabel, pageId, "user", accessUser);
        node.setUri(parentNode.getUri() + "/" + node.getName());
        if (parentNode.getChildren() == null) {
            parentNode.setChildren(new ArrayList());
        }
        parentNode.getChildren().add(node);
    }

    public static void createNodeFromPageTemplate(String nodeName, String nodeLabel, String pageId, PageNavigation navi) throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        UserPortalConfigService configService = (UserPortalConfigService)uiPortal.getApplicationComponent(UserPortalConfigService.class);
        String accessUser = Util.getPortalRequestContext().getRemoteUser();
        PageNode node = configService.createNodeFromPageTemplate(nodeName, nodeLabel, pageId, "user", accessUser);
        node.setUri(node.getName());
        navi.addNode(node);
        configService.update(navi);
        PageUtils.setNavigation(uiPortal.getNavigations(), navi);
    }

    private static void setNavigation(List<PageNavigation> navs, PageNavigation nav) {
        for (int i = 0; i < navs.size(); ++i) {
            if (navs.get(i).getId() != nav.getId()) continue;
            navs.set(i, nav);
            return;
        }
    }
}

