/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.resource.Skin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UISiteBody;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplicationLifecycle;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIPortalApplicationLifecycle.class, template="system:/groovy/portal/webui/workspace/UIPortalApplication.gtmpl")
public class UIPortalApplication
extends UIApplication {
    public static final int NORMAL_MODE = 0;
    public static final int APP_BLOCK_EDIT_MODE = 1;
    public static final int APP_VIEW_EDIT_MODE = 2;
    public static final int CONTAINER_BLOCK_EDIT_MODE = 3;
    public static final int CONTAINER_VIEW_EDIT_MODE = 4;
    private int modeState = 0;
    private String nodePath_;
    private Locale locale_ = Locale.ENGLISH;
    private Orientation orientation_ = Orientation.LT;
    public static final String UI_WORKING_WS_ID = "UIWorkingWorkspace";
    public static final String UI_VIEWING_WS_ID = "UIViewWS";
    public static final String UI_EDITTING_WS_ID = "UIEditInlineWS";
    public static final String UI_MASK_WS_ID = "UIMaskWorkspace";
    private String skin_ = "Default";
    private UserPortalConfig userPortalConfig_;
    private boolean isSessionOpen = false;

    public UIPortalApplication() throws Exception {
        log = ExoLogger.getLogger((String)"portal:UIPortalApplication");
        PortalRequestContext context = (PortalRequestContext)PortalRequestContext.getCurrentInstance();
        this.userPortalConfig_ = (UserPortalConfig)context.getAttribute(UserPortalConfig.class);
        if (this.userPortalConfig_ == null) {
            throw new Exception("Can't load user portal config");
        }
        String portalLanguage = null;
        LocaleConfigService localeConfigService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        LocaleConfig localeConfig = localeConfigService.getLocaleConfig(this.userPortalConfig_.getPortalConfig().getLocale());
        String user = context.getRemoteUser();
        if (user != null) {
            UserProfile userProfile = orgService.getUserProfileHandler().findUserProfileByName(user);
            if (userProfile != null) {
                portalLanguage = (String)userProfile.getUserInfoMap().get("user.language");
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Could not load user profile for " + user + ". Using default portal locale."));
            }
        }
        localeConfig = localeConfigService.getLocaleConfig(portalLanguage);
        if (!(portalLanguage != null && portalLanguage.equals(localeConfig.getLanguage()) || (portalLanguage = context.getRequest().getLocale().getLanguage()).equals((localeConfig = localeConfigService.getLocaleConfig(portalLanguage)).getLanguage()))) {
            localeConfig = localeConfigService.getLocaleConfig(this.userPortalConfig_.getPortalConfig().getLocale());
        }
        this.setLocale(localeConfig.getLocale());
        this.setOrientation(localeConfig.getOrientation());
        context.setUIApplication(this);
        this.addWorkingWorkspace();
        String currentSkin = this.userPortalConfig_.getPortalConfig().getSkin();
        if (currentSkin != null && currentSkin.trim().length() > 0) {
            this.skin_ = currentSkin;
        }
        this.setOwner(context.getPortalOwner());
    }

    public boolean isSessionOpen() {
        return this.isSessionOpen;
    }

    public void setSessionOpen(boolean isSessionOpen) {
        this.isSessionOpen = isSessionOpen;
    }

    public Orientation getOrientation() {
        return this.orientation_;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation_ = orientation;
    }

    public Locale getLocale() {
        return this.locale_;
    }

    public void setLocale(Locale locale) {
        this.locale_ = locale;
    }

    public void setModeState(int mode) {
        this.modeState = mode;
    }

    public int getModeState() {
        return this.modeState;
    }

    public boolean isEditing() {
        return this.modeState != 0;
    }

    public Collection<String> getJavascriptURLs() {
        JavascriptConfigService service = (JavascriptConfigService)this.getApplicationComponent(JavascriptConfigService.class);
        return service.getAvailableScriptsPaths();
    }

    public Collection<Skin> getPortalSkins() {
        Set<SkinConfig> portletConfigs;
        SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        ArrayList<Skin> skins = new ArrayList<Skin>(skinService.getPortalSkins(this.skin_));
        SkinConfig skinConfig = skinService.getSkin(Util.getUIPortal().getName(), this.skin_);
        if (skinConfig != null) {
            skins.add((Skin)skinConfig);
        }
        if (!(portletConfigs = this.getPortalPortletSkins()).isEmpty()) {
            skins.add(skinService.merge(portletConfigs));
        }
        return skins;
    }

    private Set<SkinConfig> getPortalPortletSkins() {
        HashSet<SkinConfig> portletConfigs = new HashSet<SkinConfig>();
        for (UIComponent child : ((UIPortal)this.findFirstComponentOfType(UIPortal.class)).getChildren()) {
            SkinConfig portletConfig;
            if (!(child instanceof UIPortlet) || (portletConfig = this.getPortletSkinConfig((UIPortlet)child)) == null) continue;
            portletConfigs.add(portletConfig);
        }
        return portletConfigs;
    }

    public String getSkin() {
        return this.skin_;
    }

    public void setSkin(String skin) {
        this.skin_ = skin;
    }

    private SkinConfig getSkin(String module) {
        SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        return skinService.getSkin(module, this.skin_);
    }

    public Set<Skin> getPortletSkins() {
        HashSet<Skin> skins = new HashSet<Skin>();
        ArrayList uiportlets = new ArrayList();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)this.getChildById(UI_WORKING_WS_ID);
        UIPortal uiPortal = (UIPortal)uiWorkingWS.findFirstComponentOfType(UIPortal.class);
        uiPortal.findComponentOfType(uiportlets, UIPortlet.class);
        UIPortalToolPanel toolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
        if (toolPanel != null && toolPanel.isRendered()) {
            toolPanel.findComponentOfType(uiportlets, UIPortlet.class);
        }
        Set<SkinConfig> portletConfigs = this.getPortalPortletSkins();
        for (UIPortlet uiPortlet : uiportlets) {
            SkinConfig skinConfig = this.getPortletSkinConfig(uiPortlet);
            if (skinConfig == null || portletConfigs.contains(skinConfig)) continue;
            skins.add((Skin)skinConfig);
        }
        return skins;
    }

    private SkinConfig getPortletSkinConfig(UIPortlet portlet) {
        String portletId = portlet.getSkinId();
        if (portletId != null) {
            return this.getSkin(portletId);
        }
        return null;
    }

    private void addWorkingWorkspace() throws Exception {
        UIWorkingWorkspace uiWorkingWorkspace = (UIWorkingWorkspace)this.addChild(UIWorkingWorkspace.class, UI_WORKING_WS_ID, null);
        UIComponentDecorator uiViewWS = (UIComponentDecorator)uiWorkingWorkspace.addChild(UIComponentDecorator.class, null, UI_VIEWING_WS_ID);
        DataStorage dataStorage = (DataStorage)this.getApplicationComponent(DataStorage.class);
        Container container = dataStorage.getSharedLayout();
        UIPortal uiPortal = (UIPortal)this.createUIComponent(UIPortal.class, null, null);
        PortalDataMapper.toUIPortal(uiPortal, this.userPortalConfig_);
        ((UIEditInlineWorkspace)uiWorkingWorkspace.addChild(UIEditInlineWorkspace.class, null, UI_EDITTING_WS_ID)).setRendered(false);
        if (container != null) {
            UIContainer uiContainer = (UIContainer)this.createUIComponent(UIContainer.class, null, null);
            uiContainer.setStorageId(container.getStorageId());
            PortalDataMapper.toUIContainer(uiContainer, container);
            UISiteBody uiSiteBody = (UISiteBody)uiContainer.findFirstComponentOfType(UISiteBody.class);
            uiSiteBody.setUIComponent((UIComponent)uiPortal);
            uiContainer.setRendered(true);
            uiViewWS.setUIComponent((UIComponent)uiContainer);
        } else {
            uiViewWS.setUIComponent((UIComponent)uiPortal);
        }
        this.addChild(UIMaskWorkspace.class, UI_MASK_WS_ID, null);
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        String nodePath = pcontext.getNodePath().trim();
        if (!nodePath.equals(this.nodePath_)) {
            this.nodePath_ = nodePath;
            UIPortal uiPortal = (UIPortal)this.findFirstComponentOfType(UIPortal.class);
            PageNodeEvent<UIPortal> pnevent = new PageNodeEvent<UIPortal>(uiPortal, "ChangePageNode", this.nodePath_);
            uiPortal.broadcast(pnevent, Event.Phase.PROCESS);
        }
        super.processDecode(context);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        if (!context.useAjax()) {
            super.processRender(context);
        } else {
            PortalRequestContext pcontext = (PortalRequestContext)context;
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)this.getChildById(UI_MASK_WS_ID);
            if (uiMaskWS.isUpdated()) {
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            }
            if (this.getUIPopupMessages().hasMessage()) {
                pcontext.addUIComponentToUpdateByAjax((UIComponent)this.getUIPopupMessages());
            }
            Set list = context.getUIComponentToUpdateByAjax();
            ArrayList<UIPortlet> uiPortlets = new ArrayList<UIPortlet>(3);
            ArrayList<UIComponent> uiDataComponents = new ArrayList<UIComponent>(5);
            if (list != null) {
                for (UIComponent uicomponent : list) {
                    if (uicomponent instanceof UIPortlet) {
                        uiPortlets.add((UIPortlet)uicomponent);
                        continue;
                    }
                    uiDataComponents.add(uicomponent);
                }
            }
            w.write("<div class=\"PortalResponse\">");
            w.write("<div class=\"PortalResponseData\">");
            for (UIComponent uicomponent : uiDataComponents) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AJAX call: Need to refresh the UI component " + uicomponent.getName()));
                }
                this.renderBlockToUpdate(uicomponent, context, w);
            }
            w.write("</div>");
            if (!context.getFullRender()) {
                for (UIPortlet uiPortlet : uiPortlets) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("AJAX call: Need to refresh the Portlet " + uiPortlet.getId()));
                    }
                    w.write("<div class=\"PortletResponse\" style=\"display: none\">");
                    w.append("<div class=\"PortletResponsePortletId\">" + uiPortlet.getId() + "</div>");
                    w.append("<div class=\"PortletResponseData\">");
                    uiPortlet.processRender(context);
                    w.append("</div>");
                    w.append("<div class=\"PortletResponseScript\"></div>");
                    w.write("</div>");
                }
            }
            w.write("<div class=\"PortalResponseScript\">");
            w.write(pcontext.getJavascriptManager().getJavascript());
            w.write("eXo.core.Browser.onLoad();\n");
            w.write(pcontext.getJavascriptManager().getCustomizedOnLoadScript());
            String skin = this.getAddSkinScript(list);
            if (skin != null) {
                w.write(skin);
            }
            w.write("</div>");
            w.write("</div>");
        }
    }

    private String getAddSkinScript(Set<UIComponent> updateComponents) {
        if (updateComponents == null) {
            return null;
        }
        ArrayList uiportlets = new ArrayList();
        for (UIComponent uicomponent : updateComponents) {
            UIComponentDecorator uiDecorator;
            if (uicomponent instanceof org.exoplatform.webui.core.UIContainer) {
                org.exoplatform.webui.core.UIContainer uiContainer = (org.exoplatform.webui.core.UIContainer)uicomponent;
                uiContainer.findComponentOfType(uiportlets, UIPortlet.class);
            }
            if (!(uicomponent instanceof UIComponentDecorator) || !((uiDecorator = (UIComponentDecorator)uicomponent).getUIComponent() instanceof org.exoplatform.webui.core.UIContainer)) continue;
            org.exoplatform.webui.core.UIContainer uiContainer = (org.exoplatform.webui.core.UIContainer)uiDecorator.getUIComponent();
            uiContainer.findComponentOfType(uiportlets, UIPortlet.class);
        }
        ArrayList<SkinConfig> skins = new ArrayList<SkinConfig>();
        SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        for (UIPortlet uiPortlet : uiportlets) {
            SkinConfig skinConfig;
            String skinId = uiPortlet.getSkinId();
            if (skinId == null || (skinConfig = skinService.getSkin(skinId, this.skin_)) == null) continue;
            skins.add(skinConfig);
        }
        StringBuilder b = new StringBuilder(1000);
        for (SkinConfig ele : skins) {
            SkinURL url = ele.createURL();
            url.setOrientation(this.orientation_);
            b.append("eXo.core.Skin.addSkin('").append(ele.getId()).append("','").append(url).append("');\n");
        }
        return b.toString();
    }

    public UserPortalConfig getUserPortalConfig() {
        return this.userPortalConfig_;
    }

    public void setUserPortalConfig(UserPortalConfig userPortalConfig) {
        this.userPortalConfig_ = userPortalConfig;
    }
}

