/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.helpers;

import java.beans.Introspector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ExceptionMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.ws.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.ws.metadata.jaxrpcmapping.PortMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceInterfaceMapping;
import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.ws.metadata.jaxrpcmapping.WsdlMessageMapping;
import org.jboss.ws.metadata.jaxrpcmapping.WsdlReturnValueMapping;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceMessageReference;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.HeaderUtil;
import org.jboss.ws.tools.RPCSignature;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.tools.helpers.ReturnTypeUnwrapper;
import org.jboss.wsf.common.JavaUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingFileGeneratorHelper {
    private static final Logger log = Logger.getLogger(MappingFileGeneratorHelper.class);
    private WSDLDefinitions wsdlDefinitions = null;
    private String typeNamespace;
    private String serviceName = null;
    private String packageName = null;
    private Set<String> registeredTypes = new HashSet<String>();
    private Set<String> registeredExceptions = new HashSet<String>();
    private LiteralTypeMapping typeMapping = null;
    private String wsdlStyle;
    private WSDLUtils utils = WSDLUtils.getInstance();
    private String parameterStyle;

    public MappingFileGeneratorHelper(WSDLDefinitions wsdl, String sname, String pname, Class seiClass, LiteralTypeMapping ltm, String paramStyle) {
        this.wsdlDefinitions = wsdl;
        this.serviceName = sname;
        this.packageName = pname;
        this.typeMapping = ltm;
        this.wsdlStyle = this.utils.getWSDLStyle(wsdl);
        this.parameterStyle = paramStyle;
        this.checkEssentials();
    }

    public String getTypeNamespace() {
        return this.typeNamespace;
    }

    public PackageMapping constructPackageMapping(JavaWsdlMapping jwm, String packageType, String ns) {
        PackageMapping pk = new PackageMapping(jwm);
        pk.setPackageType(packageType);
        pk.setNamespaceURI(ns);
        return pk;
    }

    public ServiceInterfaceMapping constructServiceInterfaceMapping(JavaWsdlMapping jwm, WSDLService ser) {
        String javaServiceName = this.serviceName = ser.getName().getLocalPart();
        if (this.wsdlDefinitions.getInterface(new QName(this.wsdlDefinitions.getTargetNamespace(), this.serviceName)) != null) {
            javaServiceName = javaServiceName + "_Service";
        }
        if (this.serviceName == null || this.serviceName.length() == 0) {
            throw new IllegalArgumentException("MappingFileGenerator:Service Name is null");
        }
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        String prefix = "serviceNS";
        ServiceInterfaceMapping sim = new ServiceInterfaceMapping(jwm);
        sim.setServiceInterface(this.packageName + "." + javaServiceName);
        sim.setWsdlServiceName(new QName(targetNS, this.serviceName, prefix));
        WSDLEndpoint[] endpoints = ser.getEndpoints();
        int lenendpoints = 0;
        if (endpoints != null) {
            lenendpoints = endpoints.length;
        }
        for (int j = 0; j < lenendpoints; ++j) {
            WSDLEndpoint endpt = endpoints[j];
            String portname = endpt.getName().getLocalPart();
            PortMapping pm = new PortMapping(sim);
            pm.setPortName(portname);
            pm.setJavaPortName(portname);
            sim.addPortMapping(pm);
        }
        return sim;
    }

    public void constructServiceEndpointInterfaceMapping(JavaWsdlMapping jwm, WSDLService ser) {
        this.serviceName = ser.getName().getLocalPart();
        if (this.serviceName == null || this.serviceName.length() == 0) {
            throw new IllegalArgumentException("MappingFileGenerator:Service Name is null");
        }
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        WSDLEndpoint[] endpoints = ser.getEndpoints();
        int lenendpoints = 0;
        if (endpoints != null) {
            lenendpoints = endpoints.length;
        }
        for (int j = 0; j < lenendpoints; ++j) {
            WSDLEndpoint endpt = endpoints[j];
            QName binding = endpt.getBinding();
            WSDLBinding wsdlbind = this.wsdlDefinitions.getBinding(binding);
            String bindName = wsdlbind.getName().getLocalPart();
            QName portTypeName = wsdlbind.getInterfaceName();
            WSDLInterface wsdlintf = this.wsdlDefinitions.getInterface(portTypeName);
            String portName = wsdlintf.getName().getLocalPart();
            String javaPortName = this.utils.chopPortType(portName);
            if (this.wsdlDefinitions.getService(javaPortName) != null) {
                javaPortName = javaPortName + "_PortType";
            }
            ServiceEndpointInterfaceMapping seim = new ServiceEndpointInterfaceMapping(jwm);
            seim.setServiceEndpointInterface(this.packageName + "." + javaPortName);
            seim.setWsdlPortType(new QName(targetNS, portName, "portTypeNS"));
            seim.setWsdlBinding(new QName(targetNS, bindName, "bindingNS"));
            this.constructServiceEndpointMethodMapping(seim, wsdlintf);
            jwm.addServiceEndpointInterfaceMappings(seim);
        }
    }

    public void constructServiceEndpointMethodMapping(ServiceEndpointInterfaceMapping seim, WSDLInterface intf) {
        WSDLInterfaceOperation[] wioparr = intf.getOperations();
        int len = 0;
        if (wioparr != null) {
            len = wioparr.length;
        }
        for (int j = 0; j < len; ++j) {
            WSDLInterfaceOperation wiop = wioparr[j];
            String opname = wiop.getName().getLocalPart();
            ServiceEndpointMethodMapping semm = new ServiceEndpointMethodMapping(seim);
            semm.setJavaMethodName(ToolsUtils.firstLetterLowerCase(opname));
            semm.setWsdlOperation(opname);
            semm.setWrappedElement(this.isWrapped());
            WSDLBindingOperation bindingOperation = HeaderUtil.getWSDLBindingOperation(this.wsdlDefinitions, wiop);
            if (this.isDocStyle()) {
                this.constructDOCParameters(semm, wiop, bindingOperation);
            } else {
                this.constructRPCParameters(semm, wiop, bindingOperation);
            }
            seim.addServiceEndpointMethodMapping(semm);
        }
    }

    private void constructDOCParameters(ServiceEndpointMethodMapping semm, WSDLInterfaceOperation wiop, WSDLBindingOperation bindingOperation) {
        QName xmlType;
        QName xmlName;
        WSDLInterfaceOperationInput win = WSDLUtils.getWsdl11Input(wiop);
        WSDLInterfaceOperationOutput output = WSDLUtils.getWsdl11Output(wiop);
        JBossXSModel schemaModel = WSDLUtils.getSchemaModel(this.wsdlDefinitions.getWsdlTypes());
        MethodParamPartsMapping mpin = null;
        boolean holder = false;
        if (win != null) {
            xmlName = win.getElement();
            xmlType = win.getXMLType();
            String partName = win.getPartName();
            String wsdlMessageName = win.getMessageName().getLocalPart();
            XSTypeDefinition xt = schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
            boolean wrapped = this.isWrapped();
            if (wrapped) {
                wrapped = this.unwrapRequest(semm, wsdlMessageName, xmlName.getLocalPart(), xt);
            }
            if (!wrapped) {
                if (xt instanceof XSSimpleTypeDefinition) {
                    xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
                }
                String paramMode = "IN";
                boolean bl = holder = output != null && xmlName.equals(output.getElement());
                if (holder) {
                    paramMode = "INOUT";
                }
                mpin = this.getMethodParamPartsMapping(semm, xmlName, xmlType, 0, wsdlMessageName, paramMode, partName, false, true);
                semm.addMethodParamPartsMapping(mpin);
            }
        }
        if (!holder && output != null) {
            xmlName = output.getElement();
            xmlType = output.getXMLType();
            boolean primitive = true;
            String targetNS = this.wsdlDefinitions.getTargetNamespace();
            QName messageName = new QName(targetNS, output.getMessageName().getLocalPart(), "wsdlMsgNS");
            String partName = output.getPartName();
            String containingElement = xmlName.getLocalPart();
            boolean array = false;
            XSTypeDefinition xt = schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
            ReturnTypeUnwrapper unwrapper = new ReturnTypeUnwrapper(xmlType, schemaModel, this.isWrapped());
            if (unwrapper.unwrap() && unwrapper.unwrappedElement != null) {
                XSElementDeclaration element = unwrapper.unwrappedElement;
                xt = element.getTypeDefinition();
                primitive = unwrapper.primitive;
                partName = element.getName();
                containingElement = containingElement + unwrapper.unwrappedElement.getName();
                array = unwrapper.array;
                if (xt.getAnonymous()) {
                    xmlType = new QName(containingElement);
                } else if (unwrapper.xmlType != null) {
                    xmlType = unwrapper.xmlType;
                }
            }
            if (wiop.getInputByPartName(xmlName.getLocalPart()) == null) {
                if (xt instanceof XSSimpleTypeDefinition) {
                    xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
                }
                String javaType = this.getJavaTypeAsString(xmlName, xmlType, array, primitive);
                if (!(!this.isDocStyle() && "void".equals(javaType))) {
                    WsdlReturnValueMapping wrvm = new WsdlReturnValueMapping(semm);
                    wrvm.setMethodReturnValue(javaType);
                    wrvm.setWsdlMessage(messageName);
                    wrvm.setWsdlMessagePartName(partName);
                    semm.setWsdlReturnValueMapping(wrvm);
                }
            }
        }
        if (bindingOperation != null) {
            this.constructHeaderParameters(semm, wiop, bindingOperation);
        }
    }

    private void constructHeaderParameters(ServiceEndpointMethodMapping semm, WSDLInterfaceOperation wiop, WSDLBindingOperation bindingOperation) {
        WSDLSOAPHeader[] inputHeaders = HeaderUtil.getSignatureHeaders(bindingOperation.getInputs());
        WSDLSOAPHeader[] outputHeaders = HeaderUtil.getSignatureHeaders(bindingOperation.getOutputs());
        String wsdlMessageName = bindingOperation.getWsdlBinding().getInterface().getName().getLocalPart();
        int paramPosition = 1;
        for (WSDLSOAPHeader currentInput : inputHeaders) {
            boolean inOutput = HeaderUtil.containsMatchingPart(outputHeaders, currentInput);
            String mode = this.getMode(true, inOutput);
            this.constructHeaderParameter(semm, currentInput, paramPosition++, wsdlMessageName, mode);
        }
        for (WSDLSOAPHeader currentOutput : outputHeaders) {
            boolean inInput = HeaderUtil.containsMatchingPart(inputHeaders, currentOutput);
            if (inInput) continue;
            this.constructHeaderParameter(semm, currentOutput, paramPosition++, wsdlMessageName, "OUT");
        }
    }

    private void constructHeaderParameter(ServiceEndpointMethodMapping semm, WSDLSOAPHeader header, int paramPosition, String wsdlMessageName, String mode) {
        QName elementName = header.getElement();
        JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdlDefinitions.getWsdlTypes());
        XSElementDeclaration xe = xsmodel.getElementDeclaration(elementName.getLocalPart(), elementName.getNamespaceURI());
        XSTypeDefinition xt = xe.getTypeDefinition();
        WSDLTypes wsdlTypes = this.wsdlDefinitions.getWsdlTypes();
        QName xmlType = wsdlTypes.getXMLType(header.getElement());
        xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
        if (xt instanceof XSSimpleTypeDefinition) {
            xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
        }
        String partName = header.getPartName();
        MethodParamPartsMapping mpin = this.getMethodParamPartsMapping(semm, elementName, xmlType, paramPosition, wsdlMessageName, mode, partName, false, true);
        semm.addMethodParamPartsMapping(mpin);
    }

    private String getMode(boolean input, boolean output) {
        if (input & output) {
            return "INOUT";
        }
        if (input) {
            return "IN";
        }
        if (output) {
            return "OUT";
        }
        return "";
    }

    private String getMode(WSDLInterfaceOperation op, String name) {
        WSDLInterfaceOperationInput in = WSDLUtils.getWsdl11Input(op);
        WSDLInterfaceOperationOutput out = WSDLUtils.getWsdl11Output(op);
        boolean i = false;
        boolean o = false;
        if (in != null && in.getChildPart(name) != null) {
            i = true;
        }
        if (out != null && out.getChildPart(name) != null) {
            o = true;
        }
        if (i && o) {
            return "INOUT";
        }
        if (o) {
            return "OUT";
        }
        return "IN";
    }

    private void constructRPCParameters(ServiceEndpointMethodMapping semm, WSDLInterfaceOperation wiop, WSDLBindingOperation bindingOperation) {
        WSDLInterfaceOperationInput win = WSDLUtils.getWsdl11Input(wiop);
        if (win == null) {
            throw new WSException("RPC endpoints require an input message");
        }
        String wsdlMessageName = win.getMessageName().getLocalPart();
        JBossXSModel schemaModel = WSDLUtils.getSchemaModel(this.wsdlDefinitions.getWsdlTypes());
        RPCSignature signature = new RPCSignature(wiop);
        int i = 0;
        for (WSDLRPCPart part : signature.parameters()) {
            String partName = part.getName();
            QName xmlName = new QName(partName);
            QName xmlType = part.getType();
            XSTypeDefinition xt = schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
            if (xt instanceof XSSimpleTypeDefinition) {
                xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
            }
            MethodParamPartsMapping mpin = this.getMethodParamPartsMapping(semm, xmlName, xmlType, i++, wsdlMessageName, this.getMode(wiop, part.getName()), partName, false, true);
            semm.addMethodParamPartsMapping(mpin);
        }
        WSDLRPCPart returnParameter = signature.returnParameter();
        if (returnParameter != null) {
            String partName = returnParameter.getName();
            QName xmlName = new QName(partName);
            QName xmlType = returnParameter.getType();
            XSTypeDefinition xt = schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
            if (xt instanceof XSSimpleTypeDefinition) {
                xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
            }
            WsdlReturnValueMapping wrvm = new WsdlReturnValueMapping(semm);
            wrvm.setMethodReturnValue(this.getJavaTypeAsString(xmlName, xmlType, false, true));
            QName messageName = WSDLUtils.getWsdl11Output(wiop).getMessageName();
            wrvm.setWsdlMessage(new QName(messageName.getNamespaceURI(), messageName.getLocalPart(), "wsdlMsgNS"));
            wrvm.setWsdlMessagePartName(partName);
            semm.setWsdlReturnValueMapping(wrvm);
        }
        if (bindingOperation != null) {
            this.constructHeaderParameters(semm, wiop, bindingOperation);
        }
    }

    public void constructJavaXmlTypeMapping(JavaWsdlMapping jwm) {
        WSDLInterface[] intfArr = this.wsdlDefinitions.getInterfaces();
        int len = intfArr != null ? intfArr.length : 0;
        for (int i = 0; i < len; ++i) {
            WSDLInterface wi = intfArr[i];
            for (WSDLInterfaceOperation op : wi.getOperations()) {
                XSTypeDefinition xt;
                for (WSDLInterfaceOperationInput wSDLInterfaceOperationInput : op.getInputs()) {
                    if (this.isDocStyle()) {
                        xt = this.getXSType(wSDLInterfaceOperationInput);
                        this.addJavaXMLTypeMap(xt, wSDLInterfaceOperationInput.getElement().getLocalPart(), "", "", jwm, !this.isWrapped());
                        continue;
                    }
                    for (WSDLRPCPart part : wSDLInterfaceOperationInput.getChildParts()) {
                        this.addJavaXMLTypeMap(this.getXSType(part.getType()), wSDLInterfaceOperationInput.getElement().getLocalPart(), "", "", jwm, true);
                    }
                }
                for (WSDLInterfaceMessageReference wSDLInterfaceMessageReference : op.getOutputs()) {
                    if (this.isDocStyle()) {
                        xt = this.getXSType(wSDLInterfaceMessageReference);
                        this.addJavaXMLTypeMap(xt, wSDLInterfaceMessageReference.getElement().getLocalPart(), "", "", jwm, !this.isWrapped());
                        continue;
                    }
                    for (WSDLRPCPart part : wSDLInterfaceMessageReference.getChildParts()) {
                        this.addJavaXMLTypeMap(this.getXSType(part.getType()), wSDLInterfaceMessageReference.getElement().getLocalPart(), "", "", jwm, true);
                    }
                }
                for (Serializable serializable : wi.getFaults()) {
                    QName xmlType = ((WSDLInterfaceFault)serializable).getXmlType();
                    QName xmlName = ((WSDLInterfaceFault)serializable).getElement();
                    WSDLTypes types = this.wsdlDefinitions.getWsdlTypes();
                    JBossXSModel xsmodel = WSDLUtils.getSchemaModel(types);
                    XSTypeDefinition xt2 = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
                    this.addJavaXMLTypeMap(xt2, xmlName.getLocalPart(), "", "", jwm, true);
                    String exceptionType = this.getJavaTypeAsString(null, xmlType, false, true);
                    if (this.registeredExceptions.contains(exceptionType)) continue;
                    this.registeredExceptions.add(exceptionType);
                    ExceptionMapping exceptionMapping = new ExceptionMapping(jwm);
                    exceptionMapping.setExceptionType(exceptionType);
                    exceptionMapping.setWsdlMessage(((WSDLInterfaceFault)serializable).getName());
                    jwm.addExceptionMappings(exceptionMapping);
                }
                WSDLBindingOperation bindingOperation = HeaderUtil.getWSDLBindingOperation(this.wsdlDefinitions, op);
                if (bindingOperation == null) continue;
                this.constructHeaderJavaXmlTypeMapping(jwm, HeaderUtil.getSignatureHeaders(bindingOperation.getInputs()));
                this.constructHeaderJavaXmlTypeMapping(jwm, HeaderUtil.getSignatureHeaders(bindingOperation.getOutputs()));
            }
        }
    }

    public void constructHeaderJavaXmlTypeMapping(JavaWsdlMapping jwm, WSDLSOAPHeader[] headers) {
        for (WSDLSOAPHeader current : headers) {
            QName elementName = current.getElement();
            JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdlDefinitions.getWsdlTypes());
            XSElementDeclaration xe = xsmodel.getElementDeclaration(elementName.getLocalPart(), elementName.getNamespaceURI());
            XSTypeDefinition xt = xe.getTypeDefinition();
            this.addJavaXMLTypeMap(xt, elementName.getLocalPart(), "", "", jwm, true);
        }
    }

    private boolean unwrapRequest(ServiceEndpointMethodMapping methodMapping, String messageName, String containingElement, XSTypeDefinition xt) {
        if (!(xt instanceof XSComplexTypeDefinition)) {
            throw new WSException("Tried to unwrap a non-complex type.");
        }
        ArrayList<MethodParamPartsMapping> partsMappings = new ArrayList<MethodParamPartsMapping>();
        XSComplexTypeDefinition wrapper = (XSComplexTypeDefinition)xt;
        if (wrapper.getAttributeUses().getLength() > 0) {
            return false;
        }
        boolean unwrappedElement = false;
        XSParticle particle = wrapper.getParticle();
        if (particle == null) {
            return true;
        }
        XSTerm term = particle.getTerm();
        if (term instanceof XSModelGroup) {
            unwrappedElement = this.unwrapGroup(partsMappings, methodMapping, messageName, containingElement, (XSModelGroup)term);
        }
        if (unwrappedElement) {
            this.addMethodParamPartsMappings(partsMappings, methodMapping);
            return true;
        }
        return false;
    }

    private void addMethodParamPartsMappings(List<MethodParamPartsMapping> partsMappings, ServiceEndpointMethodMapping methodMapping) {
        for (MethodParamPartsMapping current : partsMappings) {
            methodMapping.addMethodParamPartsMapping(current);
        }
    }

    private boolean unwrapGroup(List<MethodParamPartsMapping> partsMappings, ServiceEndpointMethodMapping methodMapping, String messageName, String containingElement, XSModelGroup group) {
        if (group.getCompositor() != 1) {
            return false;
        }
        XSObjectList particles = group.getParticles();
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            XSTerm term = particle.getTerm();
            if (term instanceof XSModelGroup) {
                if (this.unwrapGroup(partsMappings, methodMapping, messageName, containingElement, (XSModelGroup)term)) continue;
                return false;
            }
            if (!(term instanceof XSElementDeclaration)) continue;
            XSElementDeclaration element = (XSElementDeclaration)term;
            XSTypeDefinition type = element.getTypeDefinition();
            QName xmlName = new QName(element.getNamespace(), element.getName());
            QName xmlType = type.getAnonymous() ? new QName(type.getNamespace(), containingElement + element.getName()) : new QName(type.getNamespace(), type.getName());
            boolean array = particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
            boolean primitive = !element.getNillable() && (particle.getMinOccurs() != 0 || particle.getMaxOccurs() != 1);
            MethodParamPartsMapping part = this.getMethodParamPartsMapping(methodMapping, xmlName, xmlType, partsMappings.size(), messageName, "IN", xmlName.getLocalPart(), array, primitive);
            partsMappings.add(part);
        }
        return true;
    }

    private void checkEssentials() {
        if (this.typeMapping == null) {
            throw new WSException("typeMapping is null");
        }
    }

    private XSTypeDefinition getXSType(WSDLInterfaceMessageReference part) {
        WSDLInterfaceOperation op = part.getWsdlOperation();
        String zeroarg1 = null;
        Object zeroarg2 = null;
        WSDLProperty prop1 = op.getProperty("http://www.jboss.org/jbossws/zero-args");
        if (prop1 != null) {
            zeroarg1 = prop1.getValue();
        }
        if (zeroarg1 != null && zeroarg2 != null && !zeroarg1.equals(zeroarg2)) {
            return null;
        }
        if (zeroarg1 != null && "true".equals(zeroarg1)) {
            return null;
        }
        QName xmlType = part.getXMLType();
        WSDLTypes types = this.wsdlDefinitions.getWsdlTypes();
        JBossXSModel xsmodel = WSDLUtils.getSchemaModel(types);
        return xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
    }

    private XSTypeDefinition getXSType(QName xmlType) {
        WSDLTypes types = this.wsdlDefinitions.getWsdlTypes();
        JBossXSModel xsmodel = WSDLUtils.getSchemaModel(types);
        return xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
    }

    private void addJavaXMLTypeMap(XSTypeDefinition xt, String name, String containingElement, String containingType, JavaWsdlMapping jwm, boolean skipWrapperArray) {
        JavaXmlTypeMapping jxtm = null;
        if (xt instanceof XSComplexTypeDefinition) {
            XSTerm xterm;
            XSParticle xp;
            XSModelGroup xm = null;
            XSComplexTypeDefinition xc = (XSComplexTypeDefinition)xt;
            if (xc.getContentType() != 0 && (xp = xc.getParticle()) != null && (xterm = xp.getTerm()) instanceof XSModelGroup) {
                xm = (XSModelGroup)xterm;
            }
            if (!(skipWrapperArray && this.isRepresentsArray(xt))) {
                XSObjectList attributeUses;
                XSSimpleTypeDefinition simple;
                String javaType;
                jxtm = new JavaXmlTypeMapping(jwm);
                String localName = xt.getName();
                if (localName == null) {
                    javaType = this.getJavaTypeAsString(null, new QName(containingElement + name), false, true);
                    StringBuilder temp = new StringBuilder();
                    if (containingType != null && containingType.length() > 0) {
                        temp.append(">").append(containingType);
                    }
                    temp.append(">").append(name);
                    localName = temp.toString();
                    jxtm.setAnonymousTypeQName(new QName(xt.getNamespace(), localName, "typeNS"));
                } else {
                    javaType = this.getJavaTypeAsString(null, new QName(localName), false, true);
                    jxtm.setRootTypeQName(new QName(xt.getNamespace(), xt.getName(), "typeNS"));
                }
                if (this.typeNamespace == null) {
                    this.typeNamespace = xt.getNamespace();
                }
                if (this.registeredTypes.contains(javaType)) {
                    return;
                }
                jxtm.setJavaType(javaType);
                jxtm.setQNameScope("complexType");
                this.registeredTypes.add(javaType);
                jwm.addJavaXmlTypeMappings(jxtm);
                if (xm != null) {
                    this.addVariableMappingMap(xm, jxtm, javaType);
                }
                if ((simple = xc.getSimpleType()) != null) {
                    this.addJavaXMLTypeMap((XSTypeDefinition)simple, xc.getName(), "", "", jwm, skipWrapperArray);
                }
                if ((attributeUses = xc.getAttributeUses()) != null) {
                    this.addAttributeMappings(attributeUses, jxtm);
                }
            }
            if (xm != null) {
                this.addGroup(xm, name, xc.getName(), jwm);
            }
        }
    }

    private void addVariableMappingMap(XSModelGroup xm, JavaXmlTypeMapping jxtm, String javaType) {
        XSObjectList xo = xm.getParticles();
        int len = xo != null ? xo.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            XSTerm xsterm = ((XSParticle)xo.item(i)).getTerm();
            if (xsterm instanceof XSModelGroup) {
                this.addVariableMappingMap((XSModelGroup)xsterm, jxtm, javaType);
                continue;
            }
            if (!(xsterm instanceof XSElementDeclaration)) continue;
            XSElementDeclaration xe = (XSElementDeclaration)xsterm;
            VariableMapping vm = new VariableMapping(jxtm);
            String name = xe.getName();
            vm.setJavaVariableName(ToolsUtils.convertInvalidCharacters(Introspector.decapitalize(name)));
            vm.setXmlElementName(name);
            jxtm.addVariableMapping(vm);
        }
    }

    private void addAttributeMappings(XSObjectList attributes, JavaXmlTypeMapping jxtm) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            XSAttributeUse obj = (XSAttributeUse)attributes.item(i);
            XSAttributeDeclaration att = obj.getAttrDeclaration();
            XSSimpleTypeDefinition simple = att.getTypeDefinition();
            this.addJavaXMLTypeMap((XSTypeDefinition)simple, "none", "", "", jxtm.getJavaWsdlMapping(), true);
            VariableMapping vm = new VariableMapping(jxtm);
            String name = att.getName();
            vm.setXmlAttributeName(name);
            vm.setJavaVariableName(ToolsUtils.convertInvalidCharacters(Introspector.decapitalize(name)));
            jxtm.addVariableMapping(vm);
        }
    }

    private void addGroup(XSModelGroup xm, String containingElement, String containingType, JavaWsdlMapping jwm) {
        XSObjectList xo = xm.getParticles();
        int len = xo != null ? xo.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            XSTerm xsterm = ((XSParticle)xo.item(i)).getTerm();
            if (xsterm instanceof XSModelGroup) {
                this.addGroup((XSModelGroup)xsterm, containingElement, containingType, jwm);
                continue;
            }
            if (!(xsterm instanceof XSElementDeclaration)) continue;
            XSElementDeclaration xe = (XSElementDeclaration)xsterm;
            XSTypeDefinition typeDefinition = xe.getTypeDefinition();
            String tempContainingElement = "";
            String tempContainingType = "";
            if (xe.getScope() != 1) {
                tempContainingElement = containingElement;
                tempContainingType = containingType;
            }
            this.addJavaXMLTypeMap(typeDefinition, xe.getName(), tempContainingElement, tempContainingType, jwm, !this.isWrapped());
        }
    }

    private String getJavaTypeAsString(QName xmlName, QName xmlType, boolean array, boolean primitive) {
        String arraySuffix;
        String jtype = null;
        String string = arraySuffix = array ? "[]" : "";
        if (!this.isDocStyle()) {
            JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdlDefinitions.getWsdlTypes());
            XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
            XSElementDeclaration unwrapped = SchemaUtils.unwrapArrayType(xt);
            StringBuilder builder = new StringBuilder();
            while (unwrapped != null) {
                xt = unwrapped.getTypeDefinition();
                primitive = !unwrapped.getNillable();
                builder.append("[]");
                unwrapped = SchemaUtils.unwrapArrayType(xt);
            }
            if (builder.length() > 0) {
                xmlType = new QName(xt.getNamespace(), xt.getName());
                arraySuffix = builder.toString();
            }
        }
        Class<SOAPElement> javaType = this.typeMapping.getJavaType(xmlType, primitive);
        if (xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && "anyType".equals(xmlType.getLocalPart()) && javaType == Element.class) {
            javaType = SOAPElement.class;
        }
        if ((javaType = this.makeCustomDecisions(javaType, xmlType)) == null) {
            log.debug((Object)("Typemapping lookup failed for " + xmlName));
            log.debug((Object)"Falling back to identifier generation");
            String className = xmlType.getLocalPart();
            if (className.charAt(0) == '>') {
                className = className.substring(1);
            }
            className = ToolsUtils.convertInvalidCharacters(className);
            jtype = this.packageName + "." + this.utils.firstLetterUpperCase(className);
        } else {
            jtype = javaType.isArray() ? JavaUtils.getSourceName(javaType) : javaType.getName();
        }
        return jtype + arraySuffix;
    }

    private boolean isDocStyle() {
        return "Document/Literal".equals(this.wsdlStyle);
    }

    private boolean isRepresentsArray(XSTypeDefinition xst) {
        boolean bool = false;
        if (xst instanceof XSComplexTypeDefinition) {
            XSModelGroup xm;
            XSObjectList xo;
            XSComplexTypeDefinition xc = (XSComplexTypeDefinition)xst;
            if (xc.getContentType() == 0) {
                return false;
            }
            XSParticle xsp = xc.getParticle();
            if (xsp == null) {
                return false;
            }
            XSTerm xsterm = xsp.getTerm();
            if (xsterm instanceof XSModelGroup && (xo = (xm = (XSModelGroup)xsterm).getParticles()).getLength() == 1) {
                XSParticle xp = (XSParticle)xo.item(0);
                bool = xp.getMaxOccursUnbounded() || xp.getMaxOccurs() > 1;
            }
        }
        return bool;
    }

    private Class makeCustomDecisions(Class javaType, QName xmlType) {
        if (javaType != null && xmlType != null && Byte[].class == javaType && "http://www.w3.org/2001/XMLSchema".equals(xmlType.getNamespaceURI()) && "base64Binary".equals(xmlType.getLocalPart())) {
            javaType = byte[].class;
        }
        return javaType;
    }

    private boolean isWrapped() {
        return "wrapped".equals(this.parameterStyle) && "Document/Literal".equals(this.wsdlStyle);
    }

    private MethodParamPartsMapping getMethodParamPartsMapping(ServiceEndpointMethodMapping semm, QName xmlName, QName xmlType, int paramPosition, String wsdlMessageName, String paramMode, String wsdlMessagePartName, boolean array, boolean primitive) {
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        MethodParamPartsMapping mppm = new MethodParamPartsMapping(semm);
        mppm.setParamPosition(paramPosition);
        String javaType = this.getJavaTypeAsString(xmlName, xmlType, array, primitive);
        mppm.setParamType(javaType);
        WsdlMessageMapping wmm = new WsdlMessageMapping(mppm);
        wmm.setParameterMode(paramMode);
        String wsdlNS = "wsdlMsgNS";
        wmm.setWsdlMessage(new QName(targetNS, wsdlMessageName, wsdlNS));
        wmm.setWsdlMessagePartName(wsdlMessagePartName);
        mppm.setWsdlMessageMapping(wmm);
        return mppm;
    }
}

