/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.metadata.WebMetaData;
import org.jboss.security.RealmMapping;
import org.jboss.security.SimplePrincipal;
import org.jboss.web.tomcat.security.JBossGenericPrincipal;
import org.jboss.web.tomcat.security.JaccAuthorizationRealm;
import org.jboss.web.tomcat.security.JaccContextValve;
import org.jboss.web.tomcat.security.SecurityAssociationActions;

public class ExtendedJaccAuthorizationRealm
extends JaccAuthorizationRealm {
    protected Principal getCachingPrincpal(RealmMapping realmMapping, Principal authPrincipal, Principal callerPrincipal, Object credential, Subject subject) {
        WebMetaData wmd;
        if (SecurityAssociationActions.getCallerRunAsIdentity() == null && (wmd = (WebMetaData)JaccContextValve.activeWebMetaData.get()) != null) {
            Set secroles = wmd.getSecurityRoleNamesByPrincipal(authPrincipal.getName());
            HashSet<SimplePrincipal> principalroles = new HashSet<SimplePrincipal>();
            if (secroles != null && !secroles.isEmpty()) {
                Iterator iter = secroles.iterator();
                while (iter.hasNext()) {
                    principalroles.add(new SimplePrincipal((String)iter.next()));
                }
                return new JBossGenericPrincipal(this, subject, authPrincipal, callerPrincipal, credential, new ArrayList(secroles), principalroles);
            }
        }
        return super.getCachingPrincpal(realmMapping, authPrincipal, callerPrincipal, credential, subject);
    }

    protected boolean checkSecurityAssociation(Permission perm, Principal requestPrincpal) {
        this.establishSubjectContext(requestPrincpal);
        Principal[] principals = null;
        if (requestPrincpal instanceof JBossGenericPrincipal) {
            JBossGenericPrincipal jgp = (JBossGenericPrincipal)((Object)requestPrincpal);
            String[] rolenames = jgp.getRoles();
            int len = rolenames.length;
            principals = new Principal[len];
            for (int i = 0; i < len; ++i) {
                principals[i] = new SimplePrincipal(rolenames[i]);
            }
        }
        return this.checkSecurityAssociation(perm, principals);
    }
}

