/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.bsf.util.StringUtils;

public class MethodUtils {
    private static boolean areMethodConvertable(Class[] classArray, Class[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (MethodUtils.isMethodConvertable(classArray[i], classArray2[i])) continue;
            return false;
        }
        return true;
    }

    private static String callToString(Class clazz, String string, Class[] classArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("static ");
        }
        stringBuffer.append(StringUtils.getClassName(clazz));
        if (string != null) {
            stringBuffer.append(".").append(string);
        }
        stringBuffer.append("(");
        if (classArray != null && classArray.length > 0) {
            stringBuffer.append(StringUtils.getClassName(classArray[0]));
            for (int i = 1; i < classArray.length; ++i) {
                stringBuffer.append(",").append(StringUtils.getClassName(classArray[i]));
            }
        } else {
            stringBuffer.append("[none]");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static int entryGetModifiers(Object object) {
        return object instanceof Method ? ((Method)object).getModifiers() : ((Constructor)object).getModifiers();
    }

    static String entryGetName(Object object) {
        return object instanceof Method ? ((Method)object).getName() : ((Constructor)object).getName();
    }

    static Class[] entryGetParameterTypes(Object object) {
        return object instanceof Method ? ((Method)object).getParameterTypes() : ((Constructor)object).getParameterTypes();
    }

    static String entryToString(Object object) {
        return object instanceof Method ? ((Method)object).toString() : ((Constructor)object).toString();
    }

    public static Constructor getConstructor(Class clazz, Class[] classArray) throws SecurityException, NoSuchMethodException {
        return (Constructor)MethodUtils.getEntryPoint(clazz, null, classArray, true);
    }

    private static Object getEntryPoint(Class clazz, String string, Class[] classArray, boolean bl) throws SecurityException, NoSuchMethodException {
        Object object = null;
        try {
            if (string != null) {
                object = clazz.getMethod(string, classArray);
                if (bl && !Modifier.isStatic(MethodUtils.entryGetModifiers(object))) {
                    throw new NoSuchMethodException(MethodUtils.callToString(clazz, string, classArray, bl) + " resolved to instance " + object);
                }
                return object;
            }
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (classArray == null || classArray.length == 0) {
                throw new NoSuchMethodException(MethodUtils.callToString(clazz, string, classArray, bl) + " not found.");
            }
            Executable[] executableArray = string != null ? clazz.getMethods() : clazz.getConstructors();
            if (0 == executableArray.length) {
                throw new NoSuchMethodException("No methods!");
            }
            MoreSpecific moreSpecific = new MoreSpecific();
            for (int i = 0; i < executableArray.length; ++i) {
                Executable executable = executableArray[i];
                if (!Modifier.isPublic(MethodUtils.entryGetModifiers(executable)) || string != null && !MethodUtils.entryGetName(executable).equals(string) || !MethodUtils.areMethodConvertable(MethodUtils.entryGetParameterTypes(executable), classArray)) continue;
                moreSpecific.addItem(executable);
            }
            object = moreSpecific.getMostSpecific(clazz, string, classArray, bl);
            if (object == null) {
                throw new NoSuchMethodException(MethodUtils.callToString(clazz, string, classArray, bl) + " -- no signature match");
            }
            if (string != null && bl && !Modifier.isStatic(MethodUtils.entryGetModifiers(object))) {
                throw new NoSuchMethodException(MethodUtils.callToString(clazz, string, classArray, bl) + " resolved to instance: " + object);
            }
            return object;
        }
    }

    public static Method getMethod(Class clazz, String string, Class[] classArray, boolean bl) throws SecurityException, NoSuchMethodException {
        return (Method)MethodUtils.getEntryPoint(clazz, string, classArray, bl);
    }

    public static Method getMethod(Object object, String string, Class[] classArray) throws SecurityException, NoSuchMethodException {
        boolean bl = object instanceof Class;
        return MethodUtils.getMethod(bl ? (Class<?>)object : object.getClass(), string, classArray, bl);
    }

    private static boolean isAssignmentConvertable(Class clazz, Class clazz2) {
        return clazz2.equals(Integer.TYPE) && (clazz.equals(Byte.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Character.TYPE)) || MethodUtils.isMethodConvertable(clazz, clazz2);
    }

    private static boolean isMethodConvertable(Class clazz, Class clazz2) {
        int n;
        int n2;
        if (clazz.equals(clazz2)) {
            return true;
        }
        if (clazz2 == null) {
            return !clazz.isPrimitive();
        }
        while (clazz.isArray()) {
            if (!clazz2.isArray()) {
                return false;
            }
            clazz = clazz.getComponentType();
            clazz2 = clazz2.getComponentType();
        }
        if (clazz2.isArray()) {
            return false;
        }
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.equals(Void.TYPE) || clazz.equals(Boolean.TYPE) || clazz2.equals(Void.TYPE) || clazz2.equals(Boolean.TYPE)) {
            return false;
        }
        Class[] classArray = new Class[]{Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        for (n2 = 0; n2 < classArray.length && !clazz.equals(classArray[n2]); ++n2) {
        }
        if (n2 >= classArray.length) {
            return false;
        }
        for (n = 0; n < classArray.length && !clazz2.equals(classArray[n]); ++n) {
        }
        if (n >= classArray.length) {
            return false;
        }
        return n < n2 && (n != 0 || n2 > 2);
    }

    private static class MoreSpecific
    extends Vector {
        private MoreSpecific() {
        }

        void addItem(Object object) {
            if (this.size() == 0) {
                this.addElement(object);
            } else {
                Class[] classArray = MethodUtils.entryGetParameterTypes(object);
                boolean bl = true;
                Enumeration enumeration = this.elements();
                while (bl & enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    Class[] classArray2 = MethodUtils.entryGetParameterTypes(e);
                    if (MethodUtils.areMethodConvertable(classArray2, classArray)) {
                        this.removeElement(e);
                        continue;
                    }
                    if (!MethodUtils.areMethodConvertable(classArray, classArray2)) continue;
                    bl = false;
                }
                if (bl) {
                    this.addElement(object);
                }
            }
        }

        Object getMostSpecific(Class clazz, String string, Class[] classArray, boolean bl) throws NoSuchMethodException {
            if (this.size() == 1) {
                return this.firstElement();
            }
            if (this.size() > 1) {
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration enumeration = this.elements();
                stringBuffer.append(enumeration.nextElement());
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(" and ").append(enumeration.nextElement());
                }
                throw new NoSuchMethodException(MethodUtils.callToString(clazz, string, classArray, bl) + " is ambiguous. It matches " + stringBuffer.toString());
            }
            return null;
        }
    }
}

