/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.spi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.xml.ws.spi.Provider;

public abstract class ProviderLoader {
    public static Provider loadProvider(String defaultFactory) {
        PrivilegedAction action;
        String javaHome;
        File jaxmFile;
        Class<?> factoryClass;
        Object factory = null;
        String factoryName = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String propertyName = "javax.xml.ws.spi.Provider";
        String filename = "META-INF/services/" + propertyName;
        InputStream inStream = loader.getResourceAsStream(filename);
        if (inStream != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                factoryName = br.readLine();
                br.close();
                if (factoryName != null) {
                    factoryClass = loader.loadClass(factoryName);
                    factory = factoryClass.newInstance();
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && (jaxmFile = new File((javaHome = (String)AccessController.doPrivileged(action = new PropertyAccessAction("java.home"))) + "/lib/jaxws.properties")).exists()) {
            try {
                action = new PropertyFileAccessAction(jaxmFile.getCanonicalPath());
                Properties jaxmProperties = (Properties)AccessController.doPrivileged(action);
                factoryName = jaxmProperties.getProperty(propertyName);
                if (factoryName != null) {
                    Class<?> factoryClass2 = loader.loadClass(factoryName);
                    factory = factoryClass2.newInstance();
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && (factoryName = (String)AccessController.doPrivileged(action = new PropertyAccessAction(propertyName))) != null) {
            try {
                factoryClass = loader.loadClass(factoryName);
                factory = factoryClass.newInstance();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, t);
            }
        }
        if (factory == null && defaultFactory != null) {
            try {
                Class<?> factoryClass3 = loader.loadClass(defaultFactory);
                factory = factoryClass3.newInstance();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to load: " + defaultFactory, t);
            }
        }
        return factory;
    }

    private static class PropertyFileAccessAction
    implements PrivilegedAction {
        private String filename;

        PropertyFileAccessAction(String filename) {
            this.filename = filename;
        }

        public Object run() {
            try {
                FileInputStream inStream = new FileInputStream(this.filename);
                Properties props = new Properties();
                props.load(inStream);
                return props;
            }
            catch (IOException ex) {
                throw new SecurityException("Cannot load properties: " + this.filename, ex);
            }
        }
    }

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;

        PropertyAccessAction(String name) {
            this.name = name;
        }

        public Object run() {
            return System.getProperty(this.name);
        }
    }
}

