/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class TriggerUtils {
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int LAST_DAY_OF_MONTH = -1;
    public static final long MILLISECONDS_IN_MINUTE = 60000L;
    public static final long MILLISECONDS_IN_HOUR = 3600000L;
    public static final long SECONDS_IN_DAY = 86400L;
    public static final long MILLISECONDS_IN_DAY = 86400000L;

    private static void validateDayOfWeek(int dayOfWeek) {
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException("Invalid day of week.");
        }
    }

    private static void validateHour(int hour) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Invalid hour (must be >= 0 and <= 23).");
        }
    }

    private static void validateMinute(int minute) {
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Invalid minute (must be >= 0 and <= 59).");
        }
    }

    private static void validateSecond(int second) {
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("Invalid second (must be >= 0 and <= 59).");
        }
    }

    private static void validateDayOfMonth(int day) {
        if ((day < 1 || day > 31) && day != -1) {
            throw new IllegalArgumentException("Invalid day of month.");
        }
    }

    private static void validateMonth(int month) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid month (must be >= 1 and <= 12.");
        }
    }

    private static void validateYear(int year) {
        if (year < 1970 || year > 2099) {
            throw new IllegalArgumentException("Invalid year (must be >= 1970 and <= 2099.");
        }
    }

    public static void setTriggerIdentity(Trigger trig, String name) {
        trig.setName(name);
        trig.setGroup("DEFAULT");
    }

    public static void setTriggerIdentity(Trigger trig, String name, String group) {
        trig.setName(name);
        trig.setGroup(group);
    }

    public static Trigger makeDailyTrigger(int hour, int minute) {
        TriggerUtils.validateHour(hour);
        TriggerUtils.validateMinute(minute);
        CronTrigger trig = new CronTrigger();
        try {
            trig.setCronExpression("0 " + minute + " " + hour + " ? * *");
        }
        catch (Exception ignore) {
            return null;
        }
        return trig;
    }

    public static Trigger makeWeeklyTrigger(int dayOfWeek, int hour, int minute) {
        TriggerUtils.validateDayOfWeek(dayOfWeek);
        TriggerUtils.validateHour(hour);
        TriggerUtils.validateMinute(minute);
        CronTrigger trig = new CronTrigger();
        try {
            trig.setCronExpression("0 " + minute + " " + hour + " ? * " + dayOfWeek);
        }
        catch (Exception ignore) {
            return null;
        }
        return trig;
    }

    public static Trigger makeMonthlyTrigger(int dayOfMonth, int hour, int minute) {
        TriggerUtils.validateDayOfMonth(dayOfMonth);
        TriggerUtils.validateHour(hour);
        TriggerUtils.validateMinute(minute);
        CronTrigger trig = new CronTrigger();
        try {
            if (dayOfMonth != -1) {
                trig.setCronExpression("0 " + minute + " " + hour + " " + dayOfMonth + " * ?");
            } else {
                trig.setCronExpression("0 " + minute + " " + hour + " L * ?");
            }
        }
        catch (Exception ignore) {
            return null;
        }
        return trig;
    }

    public static Trigger makeSecondlyTrigger() {
        return TriggerUtils.makeSecondlyTrigger(1, SimpleTrigger.REPEAT_INDEFINITELY);
    }

    public static Trigger makeSecondlyTrigger(int intervalInSeconds) {
        return TriggerUtils.makeSecondlyTrigger(intervalInSeconds, SimpleTrigger.REPEAT_INDEFINITELY);
    }

    public static Trigger makeSecondlyTrigger(int intervalInSeconds, int repeatCount) {
        SimpleTrigger trig = new SimpleTrigger();
        trig.setRepeatInterval((long)intervalInSeconds * 1000L);
        trig.setRepeatCount(repeatCount);
        return trig;
    }

    public static Trigger makeMinutelyTrigger() {
        return TriggerUtils.makeMinutelyTrigger(1, SimpleTrigger.REPEAT_INDEFINITELY);
    }

    public static Trigger makeMinutelyTrigger(int intervalInMinutes) {
        return TriggerUtils.makeMinutelyTrigger(intervalInMinutes, SimpleTrigger.REPEAT_INDEFINITELY);
    }

    public static Trigger makeMinutelyTrigger(int intervalInMinutes, int repeatCount) {
        SimpleTrigger trig = new SimpleTrigger();
        trig.setRepeatInterval((long)intervalInMinutes * 60000L);
        trig.setRepeatCount(repeatCount);
        return trig;
    }

    public static Trigger makeHourlyTrigger() {
        return TriggerUtils.makeHourlyTrigger(1, SimpleTrigger.REPEAT_INDEFINITELY);
    }

    public static Trigger makeHourlyTrigger(int intervalInHours) {
        return TriggerUtils.makeHourlyTrigger(intervalInHours, SimpleTrigger.REPEAT_INDEFINITELY);
    }

    public static Trigger makeHourlyTrigger(int intervalInHours, int repeatCount) {
        SimpleTrigger trig = new SimpleTrigger();
        trig.setRepeatInterval((long)intervalInHours * 3600000L);
        trig.setRepeatCount(repeatCount);
        return trig;
    }

    public static Date getEvenHourDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.setTime(date);
        c.setLenient(true);
        c.set(11, c.get(11) + 1);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getEvenHourDateBefore(Date date) {
        if (date == null) {
            date = new Date();
        }
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.setTime(date);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getEvenMinuteDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.setTime(date);
        c.setLenient(true);
        c.set(12, c.get(12) + 1);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getEvenMinuteDateBefore(Date date) {
        if (date == null) {
            date = new Date();
        }
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.setTime(date);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getEvenSecondDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.setTime(date);
        c.setLenient(true);
        c.set(13, c.get(13) + 1);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getEvenSecondDateBefore(Date date) {
        if (date == null) {
            date = new Date();
        }
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.setTime(date);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getNextGivenMinuteDate(Date date, int minuteBase) {
        if (minuteBase < 0 || minuteBase > 59) {
            throw new IllegalArgumentException("minuteBase must be >=0 and <= 59");
        }
        if (date == null) {
            date = new Date();
        }
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.setTime(date);
        c.setLenient(true);
        if (minuteBase == 0) {
            c.set(11, c.get(11) + 1);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            return c.getTime();
        }
        int minute = c.get(12);
        int arItr = minute / minuteBase;
        int nextMinuteOccurance = minuteBase * (arItr + 1);
        if (nextMinuteOccurance < 60) {
            c.set(12, nextMinuteOccurance);
            c.set(13, 0);
            c.set(14, 0);
            return c.getTime();
        }
        c.set(11, c.get(11) + 1);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getNextGivenSecondDate(Date date, int secondBase) {
        if (secondBase < 0 || secondBase > 59) {
            throw new IllegalArgumentException("secondBase must be >=0 and <= 59");
        }
        if (date == null) {
            date = new Date();
        }
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.setTime(date);
        c.setLenient(true);
        if (secondBase == 0) {
            c.set(12, c.get(12) + 1);
            c.set(13, 0);
            c.set(14, 0);
            return c.getTime();
        }
        int second = c.get(13);
        int arItr = second / secondBase;
        int nextSecondOccurance = secondBase * (arItr + 1);
        if (nextSecondOccurance < 60) {
            c.set(13, nextSecondOccurance);
            c.set(14, 0);
            return c.getTime();
        }
        c.set(12, c.get(12) + 1);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getDateOf(int second, int minute, int hour) {
        TriggerUtils.validateSecond(second);
        TriggerUtils.validateMinute(minute);
        TriggerUtils.validateHour(hour);
        Date date = new Date();
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.setTime(date);
        c.setLenient(true);
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getDateOf(int second, int minute, int hour, int dayOfMonth, int month) {
        TriggerUtils.validateSecond(second);
        TriggerUtils.validateMinute(minute);
        TriggerUtils.validateHour(hour);
        TriggerUtils.validateDayOfMonth(dayOfMonth);
        TriggerUtils.validateMonth(month);
        Date date = new Date();
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.setTime(date);
        c.set(2, month - 1);
        c.set(5, dayOfMonth);
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getDateOf(int second, int minute, int hour, int dayOfMonth, int month, int year) {
        TriggerUtils.validateSecond(second);
        TriggerUtils.validateMinute(minute);
        TriggerUtils.validateHour(hour);
        TriggerUtils.validateDayOfMonth(dayOfMonth);
        TriggerUtils.validateMonth(month);
        TriggerUtils.validateYear(year);
        Date date = new Date();
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.setTime(date);
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, dayOfMonth);
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        c.set(14, 0);
        return c.getTime();
    }

    public static List computeFireTimes(Trigger trigg, Calendar cal, int numTimes) {
        Date d;
        LinkedList<Date> lst = new LinkedList<Date>();
        Trigger t = (Trigger)trigg.clone();
        if (t.getNextFireTime() == null) {
            t.computeFirstFireTime(cal);
        }
        for (int i = 0; i < numTimes && (d = t.getNextFireTime()) != null; ++i) {
            lst.add(d);
            t.triggered(cal);
        }
        return Collections.unmodifiableList(lst);
    }

    public static List computeFireTimesBetween(Trigger trigg, Calendar cal, Date from, Date to) {
        Date d;
        LinkedList<Date> lst = new LinkedList<Date>();
        Trigger t = (Trigger)trigg.clone();
        if (t.getNextFireTime() == null) {
            t.computeFirstFireTime(cal);
        }
        while ((d = t.getNextFireTime()) != null) {
            if (d.before(from)) {
                t.triggered(cal);
                continue;
            }
            if (d.after(to)) break;
            lst.add(d);
            t.triggered(cal);
        }
        return Collections.unmodifiableList(lst);
    }

    public static Date translateTime(Date date, TimeZone src, TimeZone dest) {
        Date newDate = new Date();
        int offset = TriggerUtils.getOffset(date.getTime(), dest) - TriggerUtils.getOffset(date.getTime(), src);
        newDate.setTime(date.getTime() - (long)offset);
        return newDate;
    }

    public static int getOffset(long date, TimeZone tz) {
        if (tz.inDaylightTime(new Date(date))) {
            return tz.getRawOffset() + TriggerUtils.getDSTSavings(tz);
        }
        return tz.getRawOffset();
    }

    public static int getDSTSavings(TimeZone tz) {
        if (tz.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }
}

