/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import org.exoplatform.services.jcr.core.lock.ExtendedLock;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.lock.LockData;

public class LockImpl
implements ExtendedLock {
    private LockData lockData;
    private SessionImpl session;

    public LockImpl(SessionImpl session, LockData lockData) {
        this.lockData = lockData;
        this.session = session;
    }

    public String getLockOwner() {
        return this.lockData.getOwner();
    }

    public String getLockToken() {
        return this.lockData.getLockToken(this.session.getId());
    }

    public boolean isLive() {
        return this.lockData.isLive();
    }

    public void refresh() throws LockException, RepositoryException {
        if (!this.isLive()) {
            throw new LockException("Lock is not live");
        }
        this.lockData.refresh();
    }

    public Node getNode() {
        try {
            return (Node)this.session.getTransientNodesManager().getItemByIdentifier(this.lockData.getNodeIdentifier(), true);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isDeep() {
        return this.lockData.isDeep();
    }

    public boolean isSessionScoped() {
        return this.lockData.isSessionScoped();
    }

    public long getTimeToDeath() {
        return this.lockData.getTimeToDeath();
    }

    protected void setTimeOut(long timeOut) {
        this.lockData.setTimeOut(timeOut);
    }
}

