/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.value.BinaryValue;
import org.exoplatform.services.jcr.impl.core.value.BooleanValue;
import org.exoplatform.services.jcr.impl.core.value.DateValue;
import org.exoplatform.services.jcr.impl.core.value.DoubleValue;
import org.exoplatform.services.jcr.impl.core.value.LongValue;
import org.exoplatform.services.jcr.impl.core.value.NameValue;
import org.exoplatform.services.jcr.impl.core.value.PathValue;
import org.exoplatform.services.jcr.impl.core.value.PermissionValue;
import org.exoplatform.services.jcr.impl.core.value.ReferenceValue;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.WorkspaceFileCleanerHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ValueFactoryImpl
implements ValueFactory {
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.ValueFactoryImpl");
    private LocationFactory locationFactory;
    private FileCleaner fileCleaner;
    private File tempDirectory;
    private int maxBufferSize;

    public ValueFactoryImpl(LocationFactory locationFactory, WorkspaceEntry workspaceConfig, WorkspaceFileCleanerHolder cleanerHolder) {
        this.locationFactory = locationFactory;
        this.fileCleaner = cleanerHolder.getFileCleaner();
        this.tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        this.maxBufferSize = workspaceConfig.getContainer().getParameterInteger("max-buffer-size", 204800);
    }

    public ValueFactoryImpl(LocationFactory locationFactory) {
        this.locationFactory = locationFactory;
        this.tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        this.maxBufferSize = 204800;
    }

    public Value createValue(String value, int type) throws ValueFormatException {
        if (value == null) {
            return null;
        }
        try {
            switch (type) {
                case 1: {
                    return this.createValue(new String(value));
                }
                case 2: {
                    try {
                        return this.createValue(new ByteArrayInputStream(value.getBytes("UTF-8")));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("FATAL ERROR Charset UTF-8 is not supported!");
                    }
                }
                case 6: {
                    return this.createValue(Boolean.parseBoolean(value));
                }
                case 3: {
                    return this.createValue(Long.parseLong(value));
                }
                case 4: {
                    return this.createValue(Double.parseDouble(value));
                }
                case 5: {
                    Calendar cal = JCRDateFormat.parse(value);
                    return this.createValue(cal);
                }
                case 8: {
                    try {
                        JCRPath path = value.startsWith("/") ? this.locationFactory.parseAbsPath(value) : this.locationFactory.parseRelPath(value);
                        return this.createValue(path);
                    }
                    catch (RepositoryException e) {
                        throw new ValueFormatException("Path '" + value + "' is invalid");
                    }
                }
                case 7: {
                    try {
                        JCRName name = this.locationFactory.parseJCRName(value);
                        return this.createValue(name);
                    }
                    catch (RepositoryException e) {
                        throw new ValueFormatException("Name '" + value + "' is invalid", (Throwable)e);
                    }
                }
                case 9: {
                    return this.createValue(new Identifier(value));
                }
                case 100: {
                    try {
                        return PermissionValue.parseValue(value);
                    }
                    catch (IOException e) {
                        new ValueFormatException("Cant create PermissionValue " + e);
                    }
                }
            }
            throw new ValueFormatException("unknown type " + type);
        }
        catch (IllegalArgumentException e) {
            throw new ValueFormatException("Cant create value from string '" + value + "' for type " + PropertyType.nameFromValue((int)type));
        }
    }

    public Value createValue(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new StringValue(value);
        }
        catch (IOException e) {
            LOG.warn((Object)("Cannot create Value from String " + value), (Throwable)e);
            return null;
        }
    }

    public Value createValue(long value) {
        try {
            return new LongValue(value);
        }
        catch (IOException e) {
            LOG.warn((Object)("Cannot create Value from long " + value), (Throwable)e);
            return null;
        }
    }

    public Value createValue(double value) {
        try {
            return new DoubleValue(value);
        }
        catch (IOException e) {
            LOG.warn((Object)("Cannot create Value from double " + value), (Throwable)e);
            return null;
        }
    }

    public Value createValue(boolean value) {
        try {
            return new BooleanValue(value);
        }
        catch (IOException e) {
            LOG.warn((Object)("Cannot create Value from boolean " + value), (Throwable)e);
            return null;
        }
    }

    public Value createValue(Calendar value) {
        if (value == null) {
            return null;
        }
        try {
            return new DateValue(value);
        }
        catch (IOException e) {
            LOG.warn((Object)("Cannot create Value from Calendar " + value), (Throwable)e);
            return null;
        }
    }

    public Value createValue(InputStream value) {
        if (value == null) {
            return null;
        }
        try {
            return new BinaryValue(value, this.fileCleaner, this.tempDirectory, this.maxBufferSize);
        }
        catch (IOException e) {
            LOG.warn((Object)("Cannot create Value from InputStream " + value), (Throwable)e);
            return null;
        }
    }

    public Value createValue(Node value) throws RepositoryException {
        if (value == null) {
            return null;
        }
        if (!value.isNodeType("mix:referenceable")) {
            throw new ValueFormatException("Node " + value.getPath() + " is not referenceable");
        }
        try {
            if (value instanceof NodeImpl) {
                String jcrUuid = ((NodeImpl)value).getInternalIdentifier();
                return new ReferenceValue(new TransientValueData(jcrUuid));
            }
            throw new RepositoryException("Its need a NodeImpl instance of Node");
        }
        catch (IOException e) {
            throw new RepositoryException("Cannot create REFERENE Value from Node", (Throwable)e);
        }
    }

    public Value createValue(JCRName value) throws RepositoryException {
        if (value == null) {
            return null;
        }
        try {
            return new NameValue(value.getInternalName(), this.locationFactory);
        }
        catch (IOException e) {
            throw new RepositoryException("Cannot create NAME Value from JCRName", (Throwable)e);
        }
    }

    public Value createValue(JCRPath value) throws RepositoryException {
        if (value == null) {
            return null;
        }
        try {
            return new PathValue(value.getInternalPath(), this.locationFactory);
        }
        catch (IOException e) {
            throw new RepositoryException("Cannot create PATH Value from JCRPath", (Throwable)e);
        }
    }

    public Value createValue(Identifier value) {
        if (value == null) {
            return null;
        }
        try {
            return new ReferenceValue(value);
        }
        catch (IOException e) {
            LOG.warn((Object)("Cannot create REFERENCE Value from Identifier " + value), (Throwable)e);
            return null;
        }
    }

    public Value loadValue(TransientValueData data, int type) throws RepositoryException {
        try {
            switch (type) {
                case 1: {
                    return new StringValue(data);
                }
                case 2: {
                    return new BinaryValue(data, this.fileCleaner, this.tempDirectory, this.maxBufferSize);
                }
                case 6: {
                    return new BooleanValue(data);
                }
                case 3: {
                    return new LongValue(data);
                }
                case 4: {
                    return new DoubleValue(data);
                }
                case 5: {
                    return new DateValue(data);
                }
                case 8: {
                    return new PathValue(data, this.locationFactory);
                }
                case 7: {
                    return new NameValue(data, this.locationFactory);
                }
                case 9: {
                    return new ReferenceValue(data);
                }
                case 0: {
                    return null;
                }
                case 100: {
                    return new PermissionValue(data);
                }
            }
            throw new ValueFormatException("unknown type " + type);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public FileCleaner getFileCleaner() {
        return this.fileCleaner;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }
}

