/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.dataflow.serialization.UnknownClassIdException;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.dataflow.serialization.TransientNodeDataReader;
import org.exoplatform.services.jcr.impl.dataflow.serialization.TransientPropertyDataReader;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class ItemStateReader {
    private FileCleaner fileCleaner;
    private int maxBufferSize;
    private ReaderSpoolFileHolder holder;

    public ItemStateReader(FileCleaner fileCleaner, int maxBufferSize, ReaderSpoolFileHolder holder) {
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = maxBufferSize;
        this.holder = holder;
    }

    public ItemState read(ObjectReader in) throws UnknownClassIdException, IOException {
        int key = in.readInt();
        if (key != 3) {
            throw new UnknownClassIdException("There is unexpected class [" + key + "]");
        }
        ItemState is = null;
        try {
            int state = in.readInt();
            boolean isPersisted = in.readBoolean();
            boolean eventFire = in.readBoolean();
            boolean isNodeData = in.readBoolean();
            if (isNodeData) {
                TransientNodeDataReader rdr = new TransientNodeDataReader();
                is = new ItemState(rdr.read(in), state, eventFire, null, false, isPersisted);
            } else {
                TransientPropertyDataReader rdr = new TransientPropertyDataReader(this.fileCleaner, this.maxBufferSize, this.holder);
                is = new ItemState(rdr.read(in), state, eventFire, null, false, isPersisted);
            }
            return is;
        }
        catch (EOFException e) {
            throw new StreamCorruptedException("Unexpected EOF in middle of data block.");
        }
    }
}

