/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.chromattic;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.chromattic.LoginContext;
import org.exoplatform.services.jcr.core.ManageableRepository;

public class LifeCycleContext {
    static final ThreadLocal<LifeCycleContext> bootContext = new ThreadLocal();
    private final String workspaceName;
    private final ChromatticManager manager;
    private final ChromatticLifeCycle configurator;

    public LifeCycleContext(ChromatticLifeCycle configurator, ChromatticManager manager, String repositoryName) {
        this.configurator = configurator;
        this.manager = manager;
        this.workspaceName = repositoryName;
    }

    public Session doLogin() throws RepositoryException {
        LoginContext loginContext = this.configurator.getLoginContext();
        if (loginContext == null) {
            throw new IllegalStateException();
        }
        ManageableRepository repo = this.manager.repositoryService.getCurrentRepository();
        Session session = repo.getSystemSession(this.workspaceName);
        loginContext.loggedIn(session);
        return session;
    }
}

