/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.ui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.ColorBar;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.ContourPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.AxisPropertyEditPanel;
import org.jfree.chart.ui.ColorBarPropertyEditPanel;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.InsetsChooserPanel;
import org.jfree.ui.InsetsTextField;
import org.jfree.ui.PaintSample;
import org.jfree.ui.StrokeChooserPanel;
import org.jfree.ui.StrokeSample;

public class PlotPropertyEditPanel
extends JPanel
implements ActionListener {
    private PaintSample backgroundPaintSample;
    private StrokeSample outlineStrokeSample;
    private PaintSample outlinePaintSample;
    private AxisPropertyEditPanel domainAxisPropertyPanel;
    private AxisPropertyEditPanel rangeAxisPropertyPanel;
    private ColorBarPropertyEditPanel colorBarAxisPropertyPanel;
    private StrokeSample[] availableStrokeSamples;
    private Insets plotInsets;
    private InsetsTextField insetsTextField;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.ui.LocalizationBundle");

    public PlotPropertyEditPanel(Plot plot) {
        this.plotInsets = plot.getInsets();
        this.backgroundPaintSample = new PaintSample(plot.getBackgroundPaint());
        this.outlineStrokeSample = new StrokeSample(plot.getOutlineStroke());
        this.outlinePaintSample = new PaintSample(plot.getOutlinePaint());
        this.setLayout(new BorderLayout());
        this.availableStrokeSamples = new StrokeSample[3];
        this.availableStrokeSamples[0] = new StrokeSample((Stroke)new BasicStroke(1.0f));
        this.availableStrokeSamples[1] = new StrokeSample((Stroke)new BasicStroke(2.0f));
        this.availableStrokeSamples[2] = new StrokeSample((Stroke)new BasicStroke(3.0f));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), plot.getPlotType() + localizationResources.getString(":")));
        JPanel general = new JPanel(new BorderLayout());
        general.setBorder(BorderFactory.createTitledBorder(localizationResources.getString("General")));
        JPanel interior = new JPanel((LayoutManager)new LCBLayout(4));
        interior.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        interior.add(new JLabel(localizationResources.getString("Insets")));
        JButton button = new JButton(localizationResources.getString("Edit..."));
        button.setActionCommand("Insets");
        button.addActionListener(this);
        this.insetsTextField = new InsetsTextField(this.plotInsets);
        this.insetsTextField.setEnabled(false);
        interior.add((Component)this.insetsTextField);
        interior.add(button);
        interior.add(new JLabel(localizationResources.getString("Outline_stroke")));
        button = new JButton(localizationResources.getString("Select..."));
        button.setActionCommand("OutlineStroke");
        button.addActionListener(this);
        interior.add((Component)this.outlineStrokeSample);
        interior.add(button);
        interior.add(new JLabel(localizationResources.getString("Outline_Paint")));
        button = new JButton(localizationResources.getString("Select..."));
        button.setActionCommand("OutlinePaint");
        button.addActionListener(this);
        interior.add((Component)this.outlinePaintSample);
        interior.add(button);
        interior.add(new JLabel(localizationResources.getString("Background_paint")));
        button = new JButton(localizationResources.getString("Select..."));
        button.setActionCommand("BackgroundPaint");
        button.addActionListener(this);
        interior.add((Component)this.backgroundPaintSample);
        interior.add(button);
        general.add((Component)interior, "North");
        JPanel appearance = new JPanel(new BorderLayout());
        appearance.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        appearance.add((Component)general, "North");
        JTabbedPane tabs = new JTabbedPane();
        tabs.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        Axis domainAxis = null;
        if (plot instanceof CategoryPlot) {
            domainAxis = ((CategoryPlot)plot).getDomainAxis();
        } else if (plot instanceof XYPlot) {
            domainAxis = ((XYPlot)plot).getDomainAxis();
        }
        this.domainAxisPropertyPanel = AxisPropertyEditPanel.getInstance(domainAxis);
        if (this.domainAxisPropertyPanel != null) {
            this.domainAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            tabs.add(localizationResources.getString("Domain_Axis"), this.domainAxisPropertyPanel);
        }
        ValueAxis rangeAxis = null;
        if (plot instanceof CategoryPlot) {
            rangeAxis = ((CategoryPlot)plot).getRangeAxis();
        } else if (plot instanceof XYPlot) {
            rangeAxis = ((XYPlot)plot).getRangeAxis();
        }
        this.rangeAxisPropertyPanel = AxisPropertyEditPanel.getInstance(rangeAxis);
        if (this.rangeAxisPropertyPanel != null) {
            this.rangeAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            tabs.add(localizationResources.getString("Range_Axis"), this.rangeAxisPropertyPanel);
        }
        ColorBar colorBar = null;
        if (plot instanceof ContourPlot) {
            colorBar = ((ContourPlot)plot).getColorBar();
        }
        this.colorBarAxisPropertyPanel = ColorBarPropertyEditPanel.getInstance(colorBar);
        if (this.colorBarAxisPropertyPanel != null) {
            this.colorBarAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            tabs.add(localizationResources.getString("Color_Bar"), this.colorBarAxisPropertyPanel);
        }
        tabs.add(localizationResources.getString("Appearance"), appearance);
        panel.add(tabs);
        this.add(panel);
    }

    public Insets getPlotInsets() {
        if (this.plotInsets == null) {
            this.plotInsets = new Insets(0, 0, 0, 0);
        }
        return this.plotInsets;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaintSample.getPaint();
    }

    public Stroke getOutlineStroke() {
        return this.outlineStrokeSample.getStroke();
    }

    public Paint getOutlinePaint() {
        return this.outlinePaintSample.getPaint();
    }

    public AxisPropertyEditPanel getDomainAxisPropertyEditPanel() {
        return this.domainAxisPropertyPanel;
    }

    public AxisPropertyEditPanel getRangeAxisPropertyEditPanel() {
        return this.rangeAxisPropertyPanel;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("BackgroundPaint")) {
            this.attemptBackgroundPaintSelection();
        } else if (command.equals("OutlineStroke")) {
            this.attemptOutlineStrokeSelection();
        } else if (command.equals("OutlinePaint")) {
            this.attemptOutlinePaintSelection();
        } else if (command.equals("Insets")) {
            this.editInsets();
        }
    }

    private void attemptBackgroundPaintSelection() {
        Color c = JColorChooser.showDialog(this, localizationResources.getString("Background_Color"), Color.blue);
        if (c != null) {
            this.backgroundPaintSample.setPaint((Paint)c);
        }
    }

    private void attemptOutlineStrokeSelection() {
        StrokeChooserPanel panel = new StrokeChooserPanel(null, this.availableStrokeSamples);
        int result = JOptionPane.showConfirmDialog(this, panel, localizationResources.getString("Stroke_Selection"), 2, -1);
        if (result == 0) {
            this.outlineStrokeSample.setStroke(panel.getSelectedStroke());
        }
    }

    private void attemptOutlinePaintSelection() {
        Color c = JColorChooser.showDialog(this, localizationResources.getString("Outline_Color"), Color.blue);
        if (c != null) {
            this.outlinePaintSample.setPaint((Paint)c);
        }
    }

    private void editInsets() {
        InsetsChooserPanel panel = new InsetsChooserPanel(this.plotInsets);
        int result = JOptionPane.showConfirmDialog(this, panel, localizationResources.getString("Edit_Insets"), 2, -1);
        if (result == 0) {
            this.plotInsets = panel.getInsets();
            this.insetsTextField.setInsets(this.plotInsets);
        }
    }

    public void updatePlotProperties(Plot plot) {
        Plot p;
        plot.setOutlinePaint(this.getOutlinePaint());
        plot.setOutlineStroke(this.getOutlineStroke());
        plot.setBackgroundPaint(this.getBackgroundPaint());
        plot.setInsets(this.getPlotInsets());
        if (this.domainAxisPropertyPanel != null) {
            Axis domainAxis = null;
            if (plot instanceof CategoryPlot) {
                p = (CategoryPlot)plot;
                domainAxis = ((CategoryPlot)p).getDomainAxis();
            } else if (plot instanceof XYPlot) {
                p = (XYPlot)plot;
                domainAxis = ((XYPlot)p).getDomainAxis();
            }
            if (domainAxis != null) {
                this.domainAxisPropertyPanel.setAxisProperties(domainAxis);
            }
        }
        if (this.rangeAxisPropertyPanel != null) {
            ValueAxis rangeAxis = null;
            if (plot instanceof CategoryPlot) {
                p = (CategoryPlot)plot;
                rangeAxis = ((CategoryPlot)p).getRangeAxis();
            } else if (plot instanceof XYPlot) {
                p = (XYPlot)plot;
                rangeAxis = ((XYPlot)p).getRangeAxis();
            }
            if (rangeAxis != null) {
                this.rangeAxisPropertyPanel.setAxisProperties(rangeAxis);
            }
        }
        if (this.colorBarAxisPropertyPanel != null) {
            ColorBar colorBar = null;
            if (plot instanceof ContourPlot) {
                p = (ContourPlot)plot;
                colorBar = ((ContourPlot)p).getColorBar();
            }
            if (colorBar != null) {
                this.colorBarAxisPropertyPanel.setAxisProperties(colorBar);
            }
        }
    }
}

