/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.info.RuntimeOptionInfo;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationLocal;
import org.gatein.registration.RegistrationManager;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPExceptionFactory;
import org.gatein.wsrp.producer.MarkupHandler;
import org.gatein.wsrp.producer.MarkupInterface;
import org.gatein.wsrp.producer.PortletManagementHandler;
import org.gatein.wsrp.producer.PortletManagementInterface;
import org.gatein.wsrp.producer.RegistrationHandler;
import org.gatein.wsrp.producer.RegistrationInterface;
import org.gatein.wsrp.producer.ServiceDescriptionHandler;
import org.gatein.wsrp.producer.ServiceDescriptionInterface;
import org.gatein.wsrp.producer.WSRPProducer;
import org.gatein.wsrp.producer.WSRPValidator;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.ProducerConfigurationService;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.oasis.wsrp.v1.AccessDenied;
import org.oasis.wsrp.v1.BlockingInteractionResponse;
import org.oasis.wsrp.v1.ClonePortlet;
import org.oasis.wsrp.v1.CookieProtocol;
import org.oasis.wsrp.v1.DestroyPortlets;
import org.oasis.wsrp.v1.DestroyPortletsResponse;
import org.oasis.wsrp.v1.GetMarkup;
import org.oasis.wsrp.v1.GetPortletDescription;
import org.oasis.wsrp.v1.GetPortletProperties;
import org.oasis.wsrp.v1.GetPortletPropertyDescription;
import org.oasis.wsrp.v1.GetServiceDescription;
import org.oasis.wsrp.v1.InconsistentParameters;
import org.oasis.wsrp.v1.InitCookie;
import org.oasis.wsrp.v1.InvalidCookie;
import org.oasis.wsrp.v1.InvalidHandle;
import org.oasis.wsrp.v1.InvalidRegistration;
import org.oasis.wsrp.v1.InvalidSession;
import org.oasis.wsrp.v1.InvalidUserCategory;
import org.oasis.wsrp.v1.MarkupResponse;
import org.oasis.wsrp.v1.MissingParameters;
import org.oasis.wsrp.v1.ModifyRegistration;
import org.oasis.wsrp.v1.OperationFailed;
import org.oasis.wsrp.v1.PerformBlockingInteraction;
import org.oasis.wsrp.v1.PortletContext;
import org.oasis.wsrp.v1.PortletDescription;
import org.oasis.wsrp.v1.PortletDescriptionResponse;
import org.oasis.wsrp.v1.PortletPropertyDescriptionResponse;
import org.oasis.wsrp.v1.PortletStateChangeRequired;
import org.oasis.wsrp.v1.PropertyList;
import org.oasis.wsrp.v1.RegistrationContext;
import org.oasis.wsrp.v1.RegistrationData;
import org.oasis.wsrp.v1.RegistrationState;
import org.oasis.wsrp.v1.ReleaseSessions;
import org.oasis.wsrp.v1.ReturnAny;
import org.oasis.wsrp.v1.ServiceDescription;
import org.oasis.wsrp.v1.SetPortletProperties;
import org.oasis.wsrp.v1.UnsupportedLocale;
import org.oasis.wsrp.v1.UnsupportedMimeType;
import org.oasis.wsrp.v1.UnsupportedMode;
import org.oasis.wsrp.v1.UnsupportedWindowState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPProducerImpl
implements WSRPProducer {
    private static final Logger log = LoggerFactory.getLogger(WSRPProducerImpl.class);
    private PortletInvoker invoker;
    private final MarkupHandler markupHandler = new MarkupHandler(this);
    private final ServiceDescriptionHandler serviceDescriptionHandler = new ServiceDescriptionHandler(this);
    private final RegistrationHandler registrationHandler = new RegistrationHandler(this);
    private final PortletManagementHandler portletManagementHandler = new PortletManagementHandler(this);
    private RegistrationManager registrationManager;
    private ProducerConfigurationService configurationService;
    private boolean started = false;
    private Boolean remotableByDefault;

    static WSRPProducerImpl getInstance() {
        return InstanceHolder.producer;
    }

    static boolean isProducerStarted() {
        return InstanceHolder.producer.started;
    }

    private WSRPProducerImpl() {
    }

    ProducerRegistrationRequirements getProducerRegistrationRequirements() {
        return this.getProducerConfiguration().getRegistrationRequirements();
    }

    @Override
    public ServiceDescription getServiceDescription(GetServiceDescription gs) throws InvalidRegistration, OperationFailed {
        log.debug("getServiceDescription invoked");
        ServiceDescription sd = this.serviceDescriptionHandler.getServiceDescription(gs);
        log.debug("end getServiceDescription");
        return sd;
    }

    @Override
    public MarkupResponse getMarkup(GetMarkup getMarkup) throws UnsupportedWindowState, InvalidCookie, InvalidSession, AccessDenied, InconsistentParameters, InvalidHandle, UnsupportedLocale, UnsupportedMode, OperationFailed, MissingParameters, InvalidUserCategory, InvalidRegistration, UnsupportedMimeType {
        log.debug("getMarkup invoked");
        MarkupResponse response = this.markupHandler.getMarkup(getMarkup);
        log.debug("end getMarkup");
        return response;
    }

    @Override
    public BlockingInteractionResponse performBlockingInteraction(PerformBlockingInteraction performBlockingInteraction) throws InvalidSession, UnsupportedMode, UnsupportedMimeType, OperationFailed, UnsupportedWindowState, UnsupportedLocale, AccessDenied, PortletStateChangeRequired, InvalidRegistration, MissingParameters, InvalidUserCategory, InconsistentParameters, InvalidHandle, InvalidCookie {
        log.debug("performBlockingInteraction invoked");
        BlockingInteractionResponse interactionResponse = this.markupHandler.performBlockingInteraction(performBlockingInteraction);
        log.debug("end performBlockingInteraction");
        return interactionResponse;
    }

    @Override
    public ReturnAny releaseSessions(ReleaseSessions releaseSessions) throws InvalidRegistration, OperationFailed, MissingParameters, AccessDenied {
        log.debug("releaseSessions invoked");
        ReturnAny returnAny = this.markupHandler.releaseSessions(releaseSessions);
        log.debug("end releaseSessions");
        return returnAny;
    }

    @Override
    public ReturnAny initCookie(InitCookie initCookie) throws AccessDenied, OperationFailed, InvalidRegistration {
        log.debug("initCookie invoked");
        ReturnAny returnAny = this.markupHandler.initCookie(initCookie);
        log.debug("end initCookie");
        return returnAny;
    }

    @Override
    public RegistrationContext register(RegistrationData register) throws MissingParameters, OperationFailed {
        log.debug("register invoked");
        RegistrationContext registrationContext = this.registrationHandler.register(register);
        log.debug("end register");
        return registrationContext;
    }

    @Override
    public ReturnAny deregister(RegistrationContext deregister) throws OperationFailed, InvalidRegistration {
        log.debug("deregister invoked");
        ReturnAny returnAny = this.registrationHandler.deregister(deregister);
        log.debug("end deregister");
        return returnAny;
    }

    @Override
    public RegistrationState modifyRegistration(ModifyRegistration modifyRegistration) throws MissingParameters, OperationFailed, InvalidRegistration {
        log.debug("modifyRegistration invoked");
        RegistrationState registrationState = this.registrationHandler.modifyRegistration(modifyRegistration);
        log.debug("end modifyRegistration");
        return registrationState;
    }

    @Override
    public PortletDescriptionResponse getPortletDescription(GetPortletDescription getPortletDescription) throws AccessDenied, InvalidHandle, InvalidUserCategory, InconsistentParameters, MissingParameters, InvalidRegistration, OperationFailed {
        log.debug("getPortletDescription invoked");
        PortletDescriptionResponse description = this.portletManagementHandler.getPortletDescription(getPortletDescription);
        log.debug("end getPortletDescription");
        return description;
    }

    @Override
    public PortletContext clonePortlet(ClonePortlet clonePortlet) throws InvalidUserCategory, AccessDenied, OperationFailed, InvalidHandle, InvalidRegistration, InconsistentParameters, MissingParameters {
        log.debug("clonePortlet invoked");
        PortletContext portletContext = this.portletManagementHandler.clonePortlet(clonePortlet);
        log.debug("end clonePortlet");
        return portletContext;
    }

    @Override
    public DestroyPortletsResponse destroyPortlets(DestroyPortlets destroyPortlets) throws InconsistentParameters, MissingParameters, InvalidRegistration, OperationFailed {
        log.debug("destroyPortlets invoked");
        DestroyPortletsResponse destroyPortletsResponse = this.portletManagementHandler.destroyPortlets(destroyPortlets);
        log.debug("end destroyPortlets");
        return destroyPortletsResponse;
    }

    @Override
    public PortletContext setPortletProperties(SetPortletProperties setPortletProperties) throws OperationFailed, InvalidHandle, MissingParameters, InconsistentParameters, InvalidUserCategory, AccessDenied, InvalidRegistration {
        log.debug("setPortletProperties invoked");
        PortletContext portletContext = this.portletManagementHandler.setPortletProperties(setPortletProperties);
        log.debug("end setPortletProperties");
        return portletContext;
    }

    @Override
    public PropertyList getPortletProperties(GetPortletProperties getPortletProperties) throws InvalidHandle, MissingParameters, InvalidRegistration, AccessDenied, OperationFailed, InconsistentParameters, InvalidUserCategory {
        log.debug("getPortletProperties invoked");
        PropertyList list = this.portletManagementHandler.getPortletProperties(getPortletProperties);
        log.debug("end getPortletProperties");
        return list;
    }

    @Override
    public PortletPropertyDescriptionResponse getPortletPropertyDescription(GetPortletPropertyDescription getPortletPropertyDescription) throws MissingParameters, InconsistentParameters, InvalidUserCategory, InvalidRegistration, AccessDenied, InvalidHandle, OperationFailed {
        log.debug("getPortletPropertyDescription invoked");
        PortletPropertyDescriptionResponse descriptionResponse = this.portletManagementHandler.getPortletPropertyDescription(getPortletPropertyDescription);
        log.debug("end getPortletPropertyDescription");
        return descriptionResponse;
    }

    private ProducerConfiguration getProducerConfiguration() {
        return this.configurationService.getConfiguration();
    }

    @Override
    public RegistrationManager getRegistrationManager() {
        return this.registrationManager;
    }

    @Override
    public void setRegistrationManager(RegistrationManager registrationManager) {
        this.registrationManager = registrationManager;
    }

    @Override
    public void setConfigurationService(ProducerConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public ProducerConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Override
    public synchronized void start() {
        if (!this.started) {
            ProducerConfiguration configuration = this.configurationService.getConfiguration();
            configuration.addChangeListener(this);
            this.usingStrictModeChangedTo(configuration.isUsingStrictMode());
            ProducerRegistrationRequirements registrationRequirements = this.getProducerRegistrationRequirements();
            registrationRequirements.addRegistrationPolicyChangeListener(this.registrationManager);
            registrationRequirements.addRegistrationPropertyChangeListener(this.registrationManager);
            if (registrationRequirements.isRegistrationRequired()) {
                this.registrationManager.setPolicy(registrationRequirements.getPolicy());
            }
            this.started = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            ProducerRegistrationRequirements registrationRequirements = this.getProducerRegistrationRequirements();
            registrationRequirements.removeRegistrationPropertyChangeListener(this.registrationManager);
            registrationRequirements.removeRegistrationPolicyChangeListener(this.registrationManager);
            this.getProducerConfiguration().removeChangeListener(this);
            this.started = false;
        }
    }

    int getExpirationTime() {
        return this.getProducerConfiguration().getSessionExpirationTime();
    }

    CookieProtocol getRequiresInitCookie() {
        return this.getProducerConfiguration().getRequiresInitCookie();
    }

    @Override
    public PortletInvoker getPortletInvoker() {
        return this.invoker;
    }

    @Override
    public void setPortletInvoker(PortletInvoker invoker) {
        this.invoker = invoker;
    }

    Portlet getPortletWith(org.gatein.pc.api.PortletContext portletContext, Registration registration) throws InvalidHandle, PortletInvokerException {
        Portlet portlet;
        try {
            RegistrationLocal.setRegistration(registration);
            portlet = this.invoker.getPortlet(portletContext);
        }
        catch (NoSuchPortletException e) {
            throw (InvalidHandle)WSRPExceptionFactory.throwWSException((String)"InvalidHandle", (String)("Couldn't find portlet with handle '" + portletContext.getId() + "'"), null);
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
        if (!this.isRemotable(portlet)) {
            throw (InvalidHandle)WSRPExceptionFactory.throwWSException((String)"InvalidHandle", (String)("Portlet '" + portletContext.getId() + "' is not remotely available."), null);
        }
        return portlet;
    }

    Set<Portlet> getRemotablePortlets() throws PortletInvokerException {
        log.debug("Retrieving remotable portlets");
        Set allPortlets = this.invoker.getPortlets();
        int portletNumber = allPortlets.size();
        Set<Portlet> remotablePortlets = Collections.emptySet();
        if (portletNumber > 0) {
            remotablePortlets = new HashSet<Portlet>(portletNumber);
            for (Portlet portlet : allPortlets) {
                log.debug("Found portlet: " + portlet.getContext());
                if (!this.isRemotable(portlet)) continue;
                remotablePortlets.add(portlet);
                log.debug("Adding remotable portlet to set: " + portlet.getContext());
            }
        }
        return remotablePortlets;
    }

    public PortletDescription getPortletDescription(PortletContext portletContext, List<String> locales, Registration registration) throws InvalidHandle, OperationFailed {
        return this.serviceDescriptionHandler.getPortletDescription(portletContext, locales, registration);
    }

    public PortletDescription getPortletDescription(Portlet portlet, List<String> locales) {
        return this.serviceDescriptionHandler.getPortletDescription(portlet, locales);
    }

    Registration getRegistrationOrFailIfInvalid(RegistrationContext registrationContext) throws InvalidRegistration, OperationFailed {
        Registration registration = this.registrationHandler.getRegistrationFrom(registrationContext);
        this.registrationHandler.isRegistrationValid(registration, true);
        return registration;
    }

    public Boolean isRemotableByDefault() {
        return this.remotableByDefault;
    }

    public void setRemotableByDefault(Boolean remotableByDefault) {
        this.remotableByDefault = remotableByDefault;
    }

    private boolean isRemotable(Portlet portlet) {
        Map runtimeOptions = portlet.getInfo().getRuntimeOptionsInfo();
        RuntimeOptionInfo runtimeOptionInfo = (RuntimeOptionInfo)runtimeOptions.get("org.jboss.portletcontainer.remotable");
        return runtimeOptionInfo != null && "true".equals(runtimeOptionInfo.getValues().get(0));
    }

    public List<String> getSupportedLocales() {
        return WSRPConstants.getDefaultLocales();
    }

    @Override
    public void usingStrictModeChangedTo(boolean strictMode) {
        WSRPValidator.setStrict(strictMode);
    }

    MarkupInterface getMarkupInterface() {
        return this.markupHandler;
    }

    ServiceDescriptionInterface getServiceDescriptionInterface() {
        return this.serviceDescriptionHandler;
    }

    RegistrationInterface getRegistrationInterface() {
        return this.registrationHandler;
    }

    PortletManagementInterface getPortletManagementInterface() {
        return this.portletManagementHandler;
    }

    private static final class InstanceHolder {
        public static final WSRPProducerImpl producer = new WSRPProducerImpl();

        private InstanceHolder() {
        }
    }
}

