/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168.api;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.apache.log4j.Logger;
import org.gatein.pc.api.info.PreferenceInfo;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyContext;
import org.gatein.pc.portlet.impl.info.ContainerPreferenceInfo;
import org.gatein.pc.portlet.impl.info.ContainerPreferencesInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPreferencesImpl
implements PortletPreferences {
    protected static final Logger log = Logger.getLogger(PortletPreferencesImpl.class);
    public static final int ACTION = 1;
    public static final int RENDER = 0;
    protected final PropertyContext prefs;
    protected final PreferencesValidator validator;
    protected final ContainerPreferencesInfo containerPrefs;
    protected final int mode;
    protected final Map<String, PropertyChange> updates;

    public PortletPreferencesImpl(PropertyContext prefs, ContainerPreferencesInfo containerPrefs, PreferencesValidator validator, int mode) {
        this.prefs = prefs;
        this.validator = validator;
        this.containerPrefs = containerPrefs;
        this.mode = mode;
        this.updates = new HashMap<String, PropertyChange>();
    }

    public Map<String, String[]> getMap() {
        return new PreferencesMap();
    }

    public Enumeration<String> getNames() {
        HashSet<String> names = new HashSet<String>(this.containerPrefs.getKeys());
        names.addAll(this.prefs.getKeys());
        for (PropertyChange change : this.updates.values()) {
            if (change.getType() == 0) {
                names.add(change.getKey());
                continue;
            }
            names.remove(change.getKey());
        }
        return Collections.enumeration(names);
    }

    private List<String> getValue(String key) {
        List<String> value = null;
        PropertyChange change = this.updates.get(key);
        if (change != null) {
            if (change.getType() == 0) {
                value = change.getValue();
            } else {
                ContainerPreferenceInfo containerPref = this.containerPrefs.getContainerPreference(key);
                if (containerPref != null) {
                    value = containerPref.getDefaultValue();
                }
            }
        } else {
            ContainerPreferenceInfo containerPref;
            value = this.prefs.getValue(key);
            if ((value == null || this.isDDReadOnly(key)) && (containerPref = this.containerPrefs.getContainerPreference(key)) != null) {
                value = containerPref.getDefaultValue();
            }
        }
        return value;
    }

    private boolean isDDReadOnly(String key) {
        PreferenceInfo pref = this.containerPrefs.getPreference(key);
        if (pref != null) {
            return Boolean.TRUE.equals(pref.isReadOnly());
        }
        return false;
    }

    public String getValue(String key, String def) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        List<String> value = this.getValue(key);
        if (value == null || value.isEmpty()) {
            return def;
        }
        return value.get(0);
    }

    public String[] getValues(String key, String[] def) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        List<String> value = this.getValue(key);
        if (value == null || value.isEmpty()) {
            return def;
        }
        return value.toArray(new String[value.size()]);
    }

    public boolean isReadOnly(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (this.mode == 1) {
            return this.prefs.isReadOnly() || this.isDDReadOnly(key);
        }
        return this.isDDReadOnly(key);
    }

    public void reset(String key) throws IllegalArgumentException, ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException("Key " + key + " cannot be written");
        }
        this.updates.put(key, PropertyChange.newReset((String)key));
    }

    public void setValue(String key, String value) throws IllegalArgumentException, ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException("Key " + key + " cannot be written");
        }
        this.updates.put(key, PropertyChange.newUpdate((String)key, (String)value));
    }

    public void setValues(String key, String[] values) throws IllegalArgumentException, ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException("Key " + key + " cannot be written");
        }
        if (values == null) {
            values = new String[1];
        }
        this.updates.put(key, PropertyChange.newUpdate((String)key, (String[])values));
    }

    public void store() throws IOException, ValidatorException {
        if (this.mode != 1) {
            throw new IllegalStateException("Store must be called within the scope of an action request");
        }
        if (this.prefs.isReadOnly()) {
            throw new IOException("Should not happen");
        }
        if (this.validator != null) {
            this.validator.validate((PortletPreferences)this);
        }
        PropertyChange[] changes = this.updates.values().toArray(new PropertyChange[this.updates.size()]);
        this.prefs.update(changes);
        this.updates.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreferencesMap
    extends HashMap<String, String[]> {
        private static final long serialVersionUID = 6969583304804836926L;

        public PreferencesMap() {
            String[] value;
            super(10);
            for (String key : PortletPreferencesImpl.this.containerPrefs.getKeys()) {
                List<String> defaultValue = PortletPreferencesImpl.this.containerPrefs.getContainerPreference(key).getDefaultValue();
                value = defaultValue.toArray(new String[defaultValue.size()]);
                super.put(key, value);
            }
            for (String key : PortletPreferencesImpl.this.prefs.getKeys()) {
                List persistentValue = PortletPreferencesImpl.this.prefs.getValue(key);
                value = persistentValue.toArray(new String[persistentValue.size()]);
                super.put(key, value);
            }
            for (PropertyChange change : PortletPreferencesImpl.this.updates.values()) {
                String key = change.getKey();
                if (change.getType() == 1) {
                    super.remove(key);
                    continue;
                }
                List updatedValue = change.getValue();
                String[] value2 = updatedValue.toArray(new String[updatedValue.size()]);
                super.put(key, value2);
            }
        }

        @Override
        public boolean containsValue(Object value) {
            if (value instanceof String[]) {
                Object[] strings = (String[])value;
                for (Object[] other : super.values()) {
                    if (!Arrays.equals(strings, other)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public String[] get(Object key) {
            return (String[])super.get(key);
        }

        @Override
        public Collection<String[]> values() {
            return super.values();
        }

        @Override
        public Set<Map.Entry<String, String[]>> entrySet() {
            return super.entrySet();
        }

        @Override
        public String[] put(String key, String[] value) {
            return null;
        }

        @Override
        public String[] remove(Object key) {
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends String[]> m) {
        }

        @Override
        public void clear() {
        }
    }
}

