/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.util.Collections;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.jmx.ManageableContainer;
import org.exoplatform.container.jmx.ManagementContextImpl;
import org.exoplatform.container.jmx.PropertiesInfo;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.jmx.annotations.NamingContext;

public class ExoModelMBean
extends RequiredModelMBean
implements ManagementContext {
    private Object mr;
    private ManagementContextImpl parentContext;
    private ManagementContextImpl context;

    public ExoModelMBean(ManagementContextImpl parentContext, Object mr, ModelMBeanInfo mbi) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        super(mbi);
        this.parentContext = parentContext;
        this.mr = mr;
        this.setManagedResource(mr, "ObjectReference");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String opName, Object[] opArgs, String[] sig) throws MBeanException, ReflectionException {
        ExoContainer container = this.context.findContainer();
        if (container != null) {
            RequestLifeCycle.begin(container);
            try {
                Object object = super.invoke(opName, opArgs, sig);
                return object;
            }
            finally {
                RequestLifeCycle.end();
            }
        }
        return super.invoke(opName, opArgs, sig);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        name = super.preRegister(server, name);
        if (this.mr instanceof MBeanRegistration) {
            ((MBeanRegistration)this.mr).preRegister(server, name);
        }
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        PropertiesInfo info = PropertiesInfo.resolve(this.mr.getClass(), NamingContext.class);
        Map scopingProperties = info != null ? info.resolve(this.mr) : Collections.emptyMap();
        this.context = this.mr instanceof ManageableContainer ? ((ManageableContainer)((Object)this.mr)).managementContext : new ManagementContextImpl(this.parentContext);
        this.context.scopingProperties = scopingProperties;
        if (this.mr instanceof ManagementAware) {
            ((ManagementAware)this.mr).setContext(this);
        }
        if (this.mr instanceof MBeanRegistration) {
            ((MBeanRegistration)this.mr).postRegister(registrationDone);
        }
    }

    public void preDeregister() throws Exception {
        if (this.mr instanceof MBeanRegistration) {
            ((MBeanRegistration)this.mr).preDeregister();
        }
        if (this.mr instanceof ManagementAware) {
            ((ManagementAware)this.mr).setContext(null);
        }
        super.preDeregister();
    }

    public void postDeregister() {
        if (this.mr instanceof MBeanRegistration) {
            ((MBeanRegistration)this.mr).postDeregister();
        }
        super.postDeregister();
    }

    public ManagementContext getManagementContext() {
        return this.context;
    }

    public Object getManagedResource() {
        return this.mr;
    }

    public void register(Object o) throws IllegalArgumentException, NullPointerException {
        this.context.register(o);
    }

    public void unregister(Object o) throws IllegalArgumentException, NullPointerException {
        this.context.unregister(o);
    }
}

