/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormCheckBoxInput<T>
extends UIFormInputBase<T> {
    private boolean checked = false;
    private String onchange_;
    private String componentEvent_ = null;

    public UIFormCheckBoxInput(String name, String bindingExpression, T value) {
        super(name, bindingExpression, null);
        if (value != null) {
            this.typeValue_ = value.getClass();
        }
        this.value_ = value;
        this.setId(name);
    }

    @Override
    public UIFormInput setValue(T value) {
        if (value == null) {
            return super.setValue(value);
        }
        if (value instanceof Boolean) {
            this.checked = (Boolean)value;
        } else if (Boolean.TYPE.isInstance(value)) {
            this.checked = Boolean.TYPE.cast(value);
        }
        this.typeValue_ = value.getClass();
        return super.setValue(value);
    }

    public void setOnChange(String onchange) {
        this.onchange_ = onchange;
    }

    public void setComponentEvent(String com) {
        this.componentEvent_ = com;
    }

    public void setOnChange(String event, String com) {
        this.onchange_ = event;
        this.componentEvent_ = com;
    }

    public String renderOnChangeEvent(UIForm uiForm) throws Exception {
        if (this.componentEvent_ == null) {
            return uiForm.event(this.onchange_, null);
        }
        return uiForm.event(this.onchange_, this.componentEvent_, (String)null);
    }

    public final boolean isChecked() {
        return this.checked;
    }

    public final UIFormCheckBoxInput setChecked(boolean check) {
        this.checked = check;
        return this;
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) throws Exception {
        if (!this.isEnable()) {
            return;
        }
        this.checked = input != null;
        if (this.typeValue_ == Boolean.class || this.typeValue_ == Boolean.TYPE) {
            this.value_ = this.typeValue_.cast(this.checked);
        }
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        w.write("<input type='checkbox' name='");
        w.write(this.name);
        w.write("'");
        w.write(" value='");
        if (this.value_ != null) {
            w.write(String.valueOf(this.value_));
        }
        w.write("' ");
        if (this.onchange_ != null) {
            UIForm uiForm = this.getAncestorOfType(UIForm.class);
            w.append(" onclick=\"").append(this.renderOnChangeEvent(uiForm)).append("\"");
        }
        if (this.checked) {
            w.write(" checked ");
        }
        if (!this.enable_) {
            w.write(" disabled ");
        }
        w.write(" class='checkbox'/>");
        if (this.isMandatory()) {
            w.write(" *");
        }
    }
}

