/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.builder;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.chromattic.api.Chromattic;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.core.Domain;
import org.chromattic.core.DomainSessionImpl;
import org.chromattic.core.jcr.SessionWrapperImpl;
import org.chromattic.spi.jcr.SessionLifeCycle;

public class ChromatticImpl
implements Chromattic {
    private SessionLifeCycle sessionLifeCycle;
    private Domain domain;

    ChromatticImpl(Domain domain, SessionLifeCycle sessionLifeCycle) {
        this.domain = domain;
        this.sessionLifeCycle = sessionLifeCycle;
    }

    public ChromatticSession openSession() {
        try {
            Session session = this.sessionLifeCycle.login();
            SessionWrapperImpl wrapper = new SessionWrapperImpl(this.sessionLifeCycle, session, this.domain.isHasPropertyOptimized(), this.domain.isHasNodeOptimized());
            return new DomainSessionImpl(this.domain, wrapper);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public ChromatticSession openSession(String workspace) {
        try {
            Session session = this.sessionLifeCycle.login(workspace);
            SessionWrapperImpl wrapper = new SessionWrapperImpl(this.sessionLifeCycle, session, this.domain.isHasPropertyOptimized(), this.domain.isHasNodeOptimized());
            return new DomainSessionImpl(this.domain, wrapper);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public ChromatticSession openSession(Credentials credentials, String workspace) {
        try {
            Session session = this.sessionLifeCycle.login(credentials, workspace);
            SessionWrapperImpl wrapper = new SessionWrapperImpl(this.sessionLifeCycle, session, this.domain.isHasPropertyOptimized(), this.domain.isHasNodeOptimized());
            return new DomainSessionImpl(this.domain, wrapper);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public ChromatticSession openSession(Credentials credentials) {
        try {
            Session session = this.sessionLifeCycle.login(credentials);
            SessionWrapperImpl wrapper = new SessionWrapperImpl(this.sessionLifeCycle, session, this.domain.isHasPropertyOptimized(), this.domain.isHasNodeOptimized());
            return new DomainSessionImpl(this.domain, wrapper);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }
}

