/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.onetoone.embedded;

import org.chromattic.core.EmbeddedContext;
import org.chromattic.core.EntityContext;
import org.chromattic.core.bean.BeanValueInfo;
import org.chromattic.core.bean.SingleValuedPropertyInfo;
import org.chromattic.core.mapper.RelatedPropertyMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCREmbeddedParentPropertyMapper
extends RelatedPropertyMapper<SingleValuedPropertyInfo<BeanValueInfo>, EntityContext> {
    private final Class relatedClass;

    public JCREmbeddedParentPropertyMapper(SingleValuedPropertyInfo<BeanValueInfo> info) throws ClassNotFoundException {
        super(EntityContext.class, info);
        this.relatedClass = Thread.currentThread().getContextClassLoader().loadClass(info.getValue().getTypeInfo().getName());
    }

    @Override
    public Class<?> getRelatedClass() {
        return this.relatedClass;
    }

    @Override
    public Object get(EntityContext context) throws Throwable {
        EmbeddedContext mixinCtx = context.getEmbedded(this.relatedClass);
        return mixinCtx != null ? mixinCtx.getObject() : null;
    }

    @Override
    public void set(EntityContext context, Object value) throws Throwable {
        if (value == null) {
            throw new UnsupportedOperationException("todo mixin removal");
        }
        if (!this.relatedClass.isInstance(value)) {
            throw new ClassCastException();
        }
        EmbeddedContext mixinCtx = context.getSession().unwrapMixin(value);
        context.addMixin(mixinCtx);
    }
}

