/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.api.invocation.response;

import org.apache.log4j.Logger;
import org.gatein.common.util.Exceptions;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;

public class ErrorResponse
extends PortletInvocationResponse {
    private final Throwable cause;
    private final String message;

    public ErrorResponse(Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException("There must be a cause");
        }
        this.cause = cause;
        this.message = cause.getMessage();
    }

    public ErrorResponse(String message, Throwable cause) {
        if (message == null) {
            throw new IllegalArgumentException("There must be a message");
        }
        if (cause == null) {
            throw new IllegalArgumentException("There must be a cause");
        }
        this.cause = cause;
        this.message = message;
    }

    public ErrorResponse(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null.");
        }
        this.message = message;
        this.cause = null;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String getMessage() {
        if (this.message == null) {
            return this.cause.getClass().getName();
        }
        return this.message;
    }

    public void logErrorTo(Logger log, String logMessage) {
        if (this.cause != null) {
            log.error((Object)logMessage, this.cause);
        } else {
            log.error((Object)(logMessage + "\n" + this.message));
        }
    }

    public String toHTML() {
        if (this.cause != null) {
            return Exceptions.toHTML((Throwable)this.cause);
        }
        StringBuffer sb = new StringBuffer(255);
        sb.append("<div><code>").append(this.message).append("</code></div>");
        return sb.toString();
    }
}

